/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-hostname.c,v 1.6 2004/04/27 22:17:38 ca Exp $")
#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/str.h"
#include "sm/test.h"
#include "sm/io.h"
#include "sm/hostname.h"

static int Verbosity = 0;

static void
test(bool lower)
{
	sm_ret_T ret;
	sm_str_P mhn;

	mhn = NULL;
	ret = sm_myhostname(&mhn);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(mhn != NULL);
	if (mhn != NULL)
	{
		if (lower)
			sm_str2lower(mhn);
		SM_TEST(strchr((const char *) sm_str_getdata(mhn), '.')
			!= NULL);
		if (Verbosity > 1)
		{
			sm_io_fprintf(smioout, "hostname='%S'\n", mhn);
			sm_io_flush(smioout);
		}
		else if (Verbosity > 0)
		{
			sm_io_fprintf(smioout, "%S\n", mhn);
			sm_io_flush(smioout);
		}
	}
	SM_STR_FREE(mhn);
	return;
}

int
main(int argc, char *argv[])
{
	int c;
	bool lower;

	lower = false;
	while ((c = getopt(argc, argv, "lV")) != -1)
	{
		switch (c)
		{
		  case 'l':
			lower = true;
			break;
		  case 'V':
			++Verbosity;
			break;
		}
	}
	sm_test_begin(argc, argv, "test myhostname");
#if 0
	argc -= optind;
	argv += optind;
#endif /* 0 */
	test(lower);
	return sm_test_end();
}
