/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: smtlsversion.c,v 1.6 2005/05/31 21:03:57 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "sm/tls.h"

#if SM_USE_TLS

/*
**  SM_TLSVERSIONOK -- OpenSSL version OK?
**
**	Parameters:
**		none
**
**	Returns:
**		usual sm_error code.
*/

sm_ret_T
sm_tlsversionok(void)
{
	uint linkversion;

	linkversion = (uint) SSLeay();
	if ((uint) OPENSSL_VERSION_NUMBER == linkversion)
		return SM_SUCCESS;
	else
		return sm_error_perm(SM_EM_TLS, SM_E_VER_MIX);
}

/*
**  SM_TLSVERSIONPRT -- show OpenSSL version
**
**	Parameters:
**		fp -- file for output
**
**	Returns:
**		usual sm_error code.
*/

sm_ret_T
sm_tlsversionprt(sm_file_T *fp)
{
	uint linkversion;

	linkversion = (uint) SSLeay();
	sm_io_fprintf(fp,
		"OpenSSL versions:\n"
		"compiled against: version=0x%08x\n"
		"linked against:   version=0x%08x\n"
		, (uint) OPENSSL_VERSION_NUMBER, linkversion);
	return sm_tlsversionok();
}
#endif /* SM_USE_TLS */
