/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fput3int.c,v 1.1 2002/08/01 01:32:26 ca Exp $")
#include "sm/error.h"
#include "sm/types.h"
#include "sm/io.h"
#include "sm/assert.h"
#include "io-int.h"
#include "fvwrite.h"

/*
**  SM_IO_FPUT3UINT32 -- add 3 32bit integers to the buffer for the file pointer
**
**	Parameters:
**		fp -- the file pointer for the buffer to be written to
**		n1 -- int to be placed in the buffer
**		n2 -- int to be placed in the buffer
**		n3 -- int to be placed in the buffer
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_io_fput3uint32(sm_file_T *fp, uint32_t n1, uint32_t n2, uint32_t n3)
{
	sm_uio_T uio;
	sm_iov_T iov[3];

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);
	iov[0].iov_base = (void *) &n1;
	iov[0].iov_len = sizeof(uint32_t);
	iov[1].iov_base = (void *) &n2;
	iov[1].iov_len = sizeof(uint32_t);
	iov[2].iov_base = (void *) &n3;
	iov[2].iov_len = sizeof(uint32_t);
	uio.uio_resid = 3 * sizeof(uint32_t);
	uio.uio_iov = &(iov[0]);
	uio.uio_iovcnt = 3;
	return sm_fvwrite(fp, &uio);
}
