/*
 * Copyright (c) 2002, 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: cstrscpyn.c,v 1.10 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/cstr.h"
#include "sm/limits.h"

/*
**  SM_CSTR_SCPYN -- Create a cstring and copy n bytes from src into it
**
**	Parameters:
**		src -- Byte array to copy from
**		n -- Number of bytes to copy from src
**
**	Returns:
**		New cstr object
**		NULL on error (ENOMEM, mutex_init)
**
**	Side Effects: none on error
**
**	Last code review: 2005-03-18 23:42:52
**	Last code change:
*/

sm_cstr_P
sm_cstr_scpyn(const uchar *src, uint n)
{
	sm_cstr_P cstr;
#if SM_USE_PTHREADS
	int r;
#endif

	SM_REQUIRE(src != NULL);
	cstr = sm_malloc(sizeof(*cstr));
	if (cstr == NULL)
		return NULL;
	cstr->sm_cstr_base = sm_malloc(n);
	if (cstr->sm_cstr_base == NULL)
	{
		sm_free_size(cstr, sizeof(*cstr));
		return NULL;
	}
#if SM_USE_PTHREADS
	r = pthread_mutex_init(&(cstr->sm_cstr_mutex), NULL);
	if (r != 0)
	{
		sm_free_size(cstr->sm_cstr_base, n);
		sm_free_size(cstr, sizeof(*cstr));
		return NULL;
	}
#endif /* SM_USE_PTHREADS */
	cstr->sm_cstr_len = n;
	cstr->sm_cstr_refcnt = 1;
	sm_memcpy(cstr->sm_cstr_base, src, n);
	cstr->sm_magic = SM_CSTR_MAGIC;
	return cstr;
}
