/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: sm-conf-type-bytes.c,v 1.7 2005/05/24 17:57:28 ca Exp $")

#if SM_LIBCONF_ALONE
#include "sm-conf.h"
#else /* SM_LIBCONF_ALONE */
#include "sm/sm-conf.h"
#endif /* SM_LIBCONF_ALONE */

#include "sm-conf-type.h"

static int
sm_conf_type_bytes_node_to_value(
	sm_conf_T			*smc,
	sm_conf_definition_T const	*def,
	sm_conf_node_T			*node,
	void				*data)
{
	char const			*text;
	size_t				text_n;
	int				err;

	SM_IS_CONF_DEF(def);
	err = sm_conf_node_to_value(smc, "byte string", node, &text, &text_n);
	if (err != 0)
		return err;

	if (data != NULL)
	{
		((sm_conf_bytes_T *)data)->scb_data = text;
		((sm_conf_bytes_T *)data)->scb_size = text_n;
	}
	return 0;
}

static int
sm_conf_type_bytes_value_check(
	sm_conf_T			*smc,
	sm_conf_definition_T const	*def,
	void const			*data)
{
	SM_IS_CONF_DEF(def);
	/* if we have a check function, use it. */
	if (def->scd_check != NULL)
		return (* def->scd_check)(smc, def->scd_check_data, def, data);
	return 0;
}

static int
sm_conf_type_bytes_value_null(
	sm_conf_T			*smc,
	sm_conf_definition_T const	*def,
	void				*data)
{
	SM_IS_CONF_DEF(def);
	if (data != NULL)
	{
		((sm_conf_bytes_T *)data)->scb_data = def->scd_default;
		((sm_conf_bytes_T *)data)->scb_size = def->scd_size;
	}
	return 0;
}

sm_conf_type_T const
sm_conf_type_bytes_data =
{
	sm_conf_type_bytes_node_to_value,
	sm_conf_type_bytes_value_check,
	sm_conf_type_bytes_value_null
};
