/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sm-conf-scan.h,v 1.6 2005/09/26 23:26:41 ca Exp $
 */

#ifndef SM_CONF_SCAN_H
#define SM_CONF_SCAN_H 1

#if SM_LIBCONF_ALONE
#include "sm-conf.h"
#else
#include "sm/sm-conf.h"
#endif

int sm_conf_scan_node(
	sm_conf_T			*_handle,
	sm_conf_definition_T const	*_def,
	sm_conf_node_T			*_node,
	unsigned int			f_lags,
	void				*_data);

int sm_conf_scan_value_check(
	sm_conf_T			*_handle,
	char const			*_name,
	size_t				_name_n,
	sm_conf_definition_T const	*_def,
	sm_conf_node_T const		*_node,
	void				*_data);

int sm_conf_scan_node_to_value(
	sm_conf_T			*_handle,
	char const			*_name,
	size_t				_name_n,
	sm_conf_definition_T const	*_def,
	sm_conf_node_T			*_node,
	void				*_data);

#endif	/* SM_CONF_SCAN_H */
