/*
 * Copyright (c) 2002-2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: stthreads.h,v 1.4 2005/06/16 00:09:35 ca Exp $
 */

#ifndef SM_STTHREADS_H
#define SM_STTHREADS_H 1

#include "sm/generic.h"
#include "sm/error.h"

#ifdef ETIMEDOUT
# define IS_ETIMEDOUT(e)	((e) == ETIMEDOUT)
#else /* ETIMEDOUT */
# define IS_ETIMEDOUT(e)	false
#endif /* ETIMEDOUT */

#ifdef ETIME
# define IS_ETIME(e)	((e) == ETIME)
#else /* ETIME */
# define IS_ETIME(e)	false
#endif /* ETIME */

#ifdef EAGAIN
# define IS_EAGAIN(e)	((e) == EAGAIN)
#else /* EAGAIN */
# define IS_EAGAIN(e)	false
#endif /* EAGAIN */

#ifdef EWOULDBLOCK
# define IS_EWOULDBLOCK(e)	((e) == EWOULDBLOCK)
#else /* EWOULDBLOCK */
# define IS_EWOULDBLOCK(e)	false
#endif /* EWOULDBLOCK */

#ifdef EINTR
# define IS_EINTR(e)	((e) == EINTR)
#else /* EINTR */
# define IS_EINTR(e)	false
#endif /* EINTR */

/*
**  Let's hope the compiler can optimize this...
**  Note: This can't be optimized if errno is used directly as argument
**  and errno is a #define which resolves to a function call.
*/

#define E_IS_TEMP(e)	\
	(IS_ETIMEDOUT(e) ||	\
	 IS_EAGAIN(e) ||	\
	 IS_EWOULDBLOCK(e) ||	\
	 IS_EINTR(e) ||	\
	 IS_ETIME(e))

#endif /* SM_STTHREADS_H */
