/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: mfapi.h,v 1.5 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_MFAPI_H
#define SM_MFAPI_H 1

#include "sm/smreplycodes.h"

/*
**  Attempt to provide a minimal sendmail "milter" compatibility layer
**  Note: this isn't complete.
*/

/* pmilter session context, must be passed to almost all pmilter functions */
typedef struct pmse_ctx_S	*pmse_ctx_P;

/* prototypes for pmilter functions */
typedef sm_ret_T (*xxfi_connect_F)(pmse_ctx_P, char *, void *);
typedef sm_ret_T (*xxfi_helo_F)(pmse_ctx_P, char *);
typedef sm_ret_T (*xxfi_envfrom_F)(pmse_ctx_P, char **);
typedef sm_ret_T (*xxfi_envrcpt_F)(pmse_ctx_P, char **);
typedef sm_ret_T (*xxfi_header_F)(pmse_ctx_P, char *, char *);
typedef sm_ret_T (*xxfi_eoh_F)(pmse_ctx_P);
typedef sm_ret_T (*xxfi_body_F)(pmse_ctx_P, unsigned char *, size_t);
typedef sm_ret_T (*xxfi_eom_F)(pmse_ctx_P);
typedef sm_ret_T (*xxfi_abort_F)(pmse_ctx_P);
typedef sm_ret_T (*xxfi_close_F)(pmse_ctx_P);
typedef sm_ret_T (*xxfi_unknown_F)(pmse_ctx_P, char *);
typedef sm_ret_T (*xxfi_data_F)(pmse_ctx_P);

/* description of one pmilter */
typedef struct pmilt_desc_S	pmilt_desc_T, *pmilt_desc_P;
struct pmilt_desc_S
{
	char		*xxfi_name;	/* filter name */
	int		 xxfi_version;	/* version code -- do not change */
	unsigned long	 xxfi_flags;	/* flags */

	/* connection info filter */
	xxfi_connect_F	xxfi_connect;

	/* SMTP EHLO/HELO command filter */
	xxfi_helo_F	xxfi_helo;

	/* SMTP MAIL command; envelope sender filter */
	xxfi_envfrom_F	xxfi_envfrom;

	/* SMTP RCPT command; envelope recipient filter */
	xxfi_envrcpt_F	xxfi_envrcpt;

	/* header filter */
	xxfi_header_F	xxfi_header;

	/* end of header */
	xxfi_eoh_F	xxfi_eoh;

	/* body block */
	xxfi_body_F	xxfi_body;

	/* end of message */
	xxfi_eom_F	xxfi_eom;

	/* message aborted */
	xxfi_abort_F	xxfi_abort;

	/* connection cleanup */
	xxfi_close_F	xxfi_close;

	/* any unrecognized or unimplemented command filter */
	xxfi_unknown_F	xxfi_unknown;

	/* DATA command */
	xxfi_data_F	xxfi_data;
};

/* pmilter API (function prototypes) */
char	*smfi_getsymval(pmse_ctx_P _ctx, char *_symval);
int	 smfi_setreply(pmse_ctx_P _ctx, char *_rcode, char *_xcode, char *_message);
int	 smfi_setmlreply(pmse_ctx_P _ctx, const char *_rcode, const char *_xcode, ...);
int	 smfi_addheader(pmse_ctx_P _ctx, char *_headerf, char *headerv);
int	 smfi_chgheader(pmse_ctx_P _ctx, char *_headerf, int _hdridx, char *_headerv);
int	 smfi_insheader(pmse_ctx_P _ctx, int _hdridx, char *_headerf, char *_headerv);
int	 smfi_addrcpt(pmse_ctx_P _ctx, char *_rcpt);
int	 smfi_delrcpt(pmse_ctx_P _ctx, char *_rcpt);
int	 smfi_progress(pmse_ctx_P _ctx);
int	 smfi_replacebody(pmse_ctx_P _ctx, unsigned char *_bodyp, int _bodylen);
int	 smfi_quarantine(pmse_ctx_P _ctx, char *_reason);
int	 smfi_setpriv(pmse_ctx_P _ctx, void *_privatedata);
void	*smfi_getpriv(pmse_ctx_P _ctx);
#if 0
sm_ret_T	sm_pmilt_rdcf(pmilt_ctx_P *pmilt_ctx, int _argc, char **argv);
#endif
sm_ret_T	smfi_register(pmilt_desc_T _smfilter);
int	 smfi_stop(void);
int	 smfi_opensocket(bool _rmsocket);
int	 smfi_setdbg(int _odbg);
int	 smfi_settimeout(int _otimeout);
int	 smfi_setconn(char *_oconn);
int	 smfi_setbacklog(int _obacklog);
int	 smfi_main(void);
size_t	 smfi_setmaxdatasize(size_t _size);

#endif /* SM_MFAPI_H */
