#!/bin/sh
# $Id: t-smtp-retry.sh,v 1.31 2005/09/01 21:13:15 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# run test program twice:
# 1. "load" defedb, i.e., try a mail that can't be delivered now
# 2. read defedb and try delivery again.
# uses smtp1.sh
# ----------------------------------------
#
test -s stop && exit 1
#
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
I=""
ERRS=0
EDBROK="../qmgr/t-smtpf-edbr.ok"
EDBROK2="../qmgr/t-smtpf-edbr2.ok"
SKIP=""

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
# ----------------------------------------
# 1. "load" defedb, i.e., try a mail that can't be delivered now
# because recipient address is <4xy@...>
#
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<a01@b.c>
	rcpts_tot=1
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=452
	aqt_rcpts_ar=0
got recipient
	rcpt=<452@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=452
EOF

# try again in 20s at the earliest (depends on QMGR to double min time)
ERR=false
${SHELL} ${SD}/smtp1.sh -O ${EDBROK} -i10 -S"a01@b.c" -R"452@y.z" || ERR=true
# show content of defedb
${VERBOSE} && ${EDBR} -VV
if ${ERR}
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && exit 1
fi

${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<a01@b.c>
	rcpts_tot=1
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=452
	aqt_rcpts_ar=0
got recipient
	rcpt=<452@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=452
got transaction
	mail=<a02@b.c>
	rcpts_tot=1
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=453
	aqt_rcpts_ar=0
got recipient
	rcpt=<453@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=453
EOF

# 2. read defedb and try delivery again.
# try again in 20s at the earliest (depends on QMGR to double min time)
# sleep 60s before terminating MTS
ERR=false
${SHELL} ${SD}/smtp1.sh -E 5 -O ${EDBROK} -i10 -D -I -M -s60 -S"a02@b.c" -R"453@y.z" || ERR=true
${VERBOSE} && ${EDBR} -VV
if ${ERR}
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# another test

TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
# ----------------------------------------
# 1. "load" defedb, i.e., try a mail that can't be delivered now
# because recipient address is <4xy@...>
# this test sends one "OK" recipient during the second half
#
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<a11@b.c>
	rcpts_tot=2
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=0
	aqt_rcpts_ar=0
got recipient
	rcpt=<452@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=452
EOF

ERR=false
${SHELL} ${SD}/smtp1.sh -E 2 -O ${EDBROK} -i10 -S"a11@b.c" -R"452@y.z -Rok1@y.z" || ERR=true
# show content of defedb
${VERBOSE} && ${EDBR} -VV
if ${ERR}
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && exit 1
fi

${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<a11@b.c>
	rcpts_tot=2
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=0
	aqt_rcpts_ar=0
got recipient
	rcpt=<452@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=452
got transaction
	mail=<a12@b.c>
	rcpts_tot=2
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=0
	aqt_rcpts_ar=0
got recipient
	rcpt=<453@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=453
EOF

# 2. read defedb and try delivery again.
# send one tempfail and one "ok" recipient
# try again in 20s at the earliest (depends on QMGR to double min time)
# sleep 60s before terminating MTS
ERR=false
${SHELL} ${SD}/smtp1.sh -E 6 -O ${EDBROK} -i10 -D -I -M -s60 -S"a12@b.c" -R"453@y.z -Rok2@y.z" || ERR=true
${VERBOSE} && ${EDBR} -VV
if ${ERR}
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

TEST=3
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
# ----------------------------------------
# 1. "load" defedb, i.e., try a mail that can't be delivered now
# because recipient address is <4xy@...> (two temp fail rcpts)
#

${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<a21@b.c>
	rcpts_tot=2
	rcpts_left=2
	rcpts_temp=2
	rcpts_perm=0
	state=451
	aqt_rcpts_ar=0
got recipient
	rcpt=<452@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=452
got recipient
	rcpt=<451@y.z>
	aqr_rcpt_idx=1
	aqr_da_idx=0
	aqr_status=451
EOF

${CAT} > ${EDBROK2} <<EOF
got transaction
	mail=<a21@b.c>
	rcpts_tot=2
	rcpts_left=2
	rcpts_temp=2
	rcpts_perm=0
	state=452
	aqt_rcpts_ar=0
got recipient
	rcpt=<452@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=452
got recipient
	rcpt=<451@y.z>
	aqr_rcpt_idx=1
	aqr_da_idx=0
	aqr_status=451
EOF

ERR=false
${SHELL} ${SD}/smtp1.sh -E 2 -O ${EDBROK} -K ${EDBROK2} -i10 -S"a21@b.c" -R"452@y.z -R451@y.z" || ERR=true
# show content of defedb
${VERBOSE} && ${EDBR} -VV
if ${ERR}
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "$0: test ${TEST} failed, part 1"
  test X"${SM_STOPONERROR}" != X && exit 1
fi
# 2. read defedb and try delivery again.
# the sink will accept all mails after 20s
# try again in 20s at the earliest (depends on QMGR to double min time)
ERR=false
${SHELL} ${SD}/smtp1.sh -E 6 -o20 -i10 -D -I -M -s60 -S"a22@b.c" -R"453@y.z" || ERR=true
${VERBOSE} && ${EDBR} -VV
if ${ERR}
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "$0: test ${TEST} failed, part 2"
  test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

TEST=4
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
# ----------------------------------------
# 1. "load" defedb, i.e., try a mail that can't be delivered now
# because recipient address is <4xy@...> (tempfail from sink)
# and <ar1t@t.z> (tempfail from AR)
#

${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<a31@b.c>
	rcpts_tot=3
	rcpts_left=3
	rcpts_temp=3
	rcpts_perm=0
	state=451
	aqt_rcpts_ar=0
got recipient
	rcpt=<452@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=452
got recipient
	rcpt=<451@y.z>
	aqr_rcpt_idx=1
	aqr_da_idx=0
	aqr_status=451
got recipient
	rcpt=<ar1t@t.z>
	aqr_rcpt_idx=2
	aqr_da_idx=0
	aqr_status=481
EOF

${CAT} > ${EDBROK2} <<EOF
got transaction
	mail=<a31@b.c>
	rcpts_tot=3
	rcpts_left=3
	rcpts_temp=3
	rcpts_perm=0
	state=452
	aqt_rcpts_ar=0
got recipient
	rcpt=<452@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=452
got recipient
	rcpt=<451@y.z>
	aqr_rcpt_idx=1
	aqr_da_idx=0
	aqr_status=451
got recipient
	rcpt=<ar1t@t.z>
	aqr_rcpt_idx=2
	aqr_da_idx=0
	aqr_status=481
EOF

ERR=false
${SHELL} ${SD}/smtp1.sh -E 2 -i10 -O ${EDBROK} -K ${EDBROK2} -S"a31@b.c" -R"452@y.z -R451@y.z -Rar1t@t.z" || ERR=true
# show content of defedb
${VERBOSE} && ${EDBR} -VV
if ${ERR}
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && exit 1
fi

# only recipient left is the one that the AR fails on
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<a31@b.c>
	rcpts_tot=3
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=0
	aqt_rcpts_ar=0
got recipient
	rcpt=<ar1t@t.z>
	aqr_rcpt_idx=2
	aqr_da_idx=0
	aqr_status=481
EOF

# 2. read defedb and try delivery again.
# try in 20s at the earliest (depends on QMGR to double min time)
# the sink will accept all mails after 20s
# sleep 60s before terminating MTS
ERR=false
${SHELL} ${SD}/smtp1.sh -E 6 -O ${EDBROK} -o20 -i10 -D -I -M -s60 -S"a32@b.c" -R"453@y.z" || ERR=true
${VERBOSE} && ${EDBR} -VV
if ${ERR}
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
