#!/bin/sh
# $Id: t-pmilter-2.sh,v 1.9 2005/10/19 18:34:53 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test pmilter abort behavior
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`

if ../smtps/smtps -VVV | ${GREP} SM_USE_PMILTER >/dev/null
then
  :
else
  echo "$0: smtps not compiled with SM_USE_PMILTER (--enable-pmilter); test SKIPPED"
  exit 0
fi

OUT="t-pmilter-0.out"
#PMPRG="-p ../libpmilter/t-pmilter-1"
PMPRG=""

if test X"`uname`" != "XOSF1"
then
while getopts p:s:V FLAG
do
  case "${FLAG}" in
    p) PMPRG="-p ${OPTARG}";;
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }

smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
policy_milter { socket {type=unix; path="pmilter.sock";} timeout=2; }
}

EOF


# ----------------------------------------
# abort after mail command in milter
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh ${PMPRG} -P '-d 1' -Z 'smtpc2' -c '-a m=0x0100' -c '-E' -E 0 -A 0 -X 0 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'abort_ta' m0.log >/dev/null
then
  :
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi

## 
## # ----------------------------------------
## # reject rcpt command in milter
## TEST=2
## if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
## then
## if ${SHELL} ${SCRIPTS}/smtpcnf.sh -P "-r r=550" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S"a@b.c" -R"x@y.z"
## then
##     ERR=false
## else
##     ERR=true
##     echo "$0: test ${TEST} failed"
##     test X"${SM_STOPONERROR}" != X && exit 1
## fi
## if ${GREP} 'RCPT=error' ${CLTL} >/dev/null
## then
##   :
## else
##   ERR=true
## fi
## if ${ERR}
## then
##     echo "$0: test ${TEST} check failed"
##     ERRS=`expr ${ERRS} + 1 `
##     test X"${SM_STOPONERROR}" != X && exit 1
## else
##     ${VERBOSE} && echo "test ${TEST} succeeded"
## fi
## fi
## 
## # ----------------------------------------
## # reject DATA command in milter
## TEST=3
## if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
## then
## if ${SHELL} ${SCRIPTS}/smtpcnf.sh -P "-r d=550" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S"a@b.c" -R"x@y.z"
## then
##     ERR=false
## else
##     echo "$0: test ${TEST} failed"
##     ERR=true
##     test X"${SM_STOPONERROR}" != X && exit 1
## fi
## if ${GREP} 'DATA=error' ${CLTL} >/dev/null
## then
##   :
## else
##   ERR=true
## fi
## if ${ERR}
## then
##     echo "$0: test ${TEST} check failed"
##     test X"${SM_STOPONERROR}" != X && exit 1
## else
##     ${VERBOSE} && echo "test ${TEST} succeeded"
## fi
## fi
## 
## # ----------------------------------------
## # reject final dot command in milter
## TEST=4
## if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
## then
## if ${SHELL} ${SCRIPTS}/smtpcnf.sh -P "-r b=550" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S"a@b.c" -R"x@y.z"
## then
##     ERR=false
## else
##     echo "$0: test ${TEST} failed"
##     ERR=true
##     test X"${SM_STOPONERROR}" != X && exit 1
## fi
## if ${GREP} 'DOT=error' ${CLTL} >/dev/null
## then
##   :
## else
##   ERR=true
## fi
## if ${ERR}
## then
##     echo "$0: test ${TEST} check failed"
##     ERRS=`expr ${ERRS} + 1 `
##     test X"${SM_STOPONERROR}" != X && exit 1
## else
##     ${VERBOSE} && echo "test ${TEST} succeeded"
## fi
## fi
## 
## # ----------------------------------------
## # accept mail, write to file, check content
## TEST=5
## if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
## then
## 
## DF=pmilter.data
## CF=pbody0
## rm -f ${DF} ${CF}
## 
## ${CAT} > ${DF} <<EOF
## From: sender@this.dom.ain
## To: rcpt@this.dom.ain
## Subject: copy
## 
## this is the body of the mail that
## should be stored in a file.
## 
## Just an idea how to spy on users...
## EOF
## 
## if ${SHELL} ${SCRIPTS}/smtpcnf.sh -P "-f ${CF}" -Z 'smtpc2' -c "-D ${DF} -E" -E 1 -A 1 -X 1 $@ -S"s${TEST}@b.c" -R"r${TEST}@y.z"
## then
##     ERR=false
## else
##     echo "$0: test ${TEST} failed"
##     ERR=true
##     test X"${SM_STOPONERROR}" != X && exit 1
## fi
## 
## if test -s ${CF}
## then
##   # add end of body to input, see statethreads/examples/smtpc2.c
##   ${CAT} >> ${DF} <<EOF
## 
## .
## EOF
##   if diff ${CF} ${DF} >/dev/null
##   then
##     :
##   else
##     ERR=true
##   fi
## else
##   ERR=true
## fi
## 
## if ${ERR}
## then
##     echo "$0: test ${TEST} check failed"
##     ERRS=`expr ${ERRS} + 1 `
##     test X"${SM_STOPONERROR}" != X && exit 1
## else
##     ${VERBOSE} && echo "test ${TEST} succeeded"
## fi
## fi
## 
## # ----------------------------------------
## # accept mail, write to file, check length of content
## TEST=6
## if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
## then
## 
## CF=pbody0
## DS=65536
## # + \r\n.\r\n
## DS2=`expr ${DS} + 5 `
## rm -f ${CF}
## 
## if ${SHELL} ${SCRIPTS}/smtpcnf.sh -P "-f ${CF}" -Z 'smtpc2' -c "-l ${DS} -E" -E 1 -A 1 -X 1 $@ -S"s${TEST}@b.c" -R"r${TEST}@y.z"
## then
##     ERR=false
## else
##     echo "$0: test ${TEST} failed"
##     ERR=true
##     test X"${SM_STOPONERROR}" != X && exit 1
## fi
## 
## if test -s ${CF}
## then
##   S=`wc -c < ${CF}`
##   if test ${S} -eq ${DS2}
##   then
##     :
##   else
##     echo "$0: test ${TEST}: size: ${S}, expected: ${DS2}"
##     ERR=true
##   fi
## else
##   ERR=true
## fi
## 
## if ${ERR}
## then
##     echo "$0: test ${TEST} check failed"
##     ERRS=`expr ${ERRS} + 1 `
##     test X"${SM_STOPONERROR}" != X && exit 1
## else
##     ${VERBOSE} && echo "test ${TEST} succeeded"
## fi
## fi
## 
## 
## # ----------------------------------------
## # discard mail (body)
## TEST=7
## if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
## then
## 
## if ${SHELL} ${SCRIPTS}/smtpcnf.sh -P "-r b=90" -Z 'smtpc2' -A 1 -E 0 -X 0 $@ -S"s${TEST}@b.c" -R"r${TEST}@y.z"
## then
##     ERR=false
## else
##     echo "$0: test ${TEST} failed"
##     ERR=true
## fi
## 
## # check whether there's a mail body
## rm -f ${OUT}
## ls ?/S* > ${OUT} 2>/dev/null
## if test -s ${OUT}
## then
##     ERR=true
##     echo "$0: test ${TEST} failed: found mail in queue"
##     ${VERBOSE} && ${CAT} ${OUT}
## fi
## 
## if ${ERR}
## then
##     echo "$0: test ${TEST} check failed"
##     ERRS=`expr ${ERRS} + 1 `
##     test X"${SM_STOPONERROR}" != X && exit 1
## else
##     ${VERBOSE} && echo "test ${TEST} succeeded"
## fi
## fi
## 
## 
## # ----------------------------------------
## # discard recipient
## TEST=8
## if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
## then
## 
## if ${SHELL} ${SCRIPTS}/smtpcnf.sh -P "-r r=90" -Z 'smtpc2' -A 1 -E 0 -X 0 $@ -S"s${TEST}@b.c" -R"r${TEST}@y.z"
## then
##     ERR=false
## else
##     echo "$0: test ${TEST} failed"
##     ERR=true
## fi
## 
## # check whether there's a mail body
## rm -f ${OUT}
## ls ?/S* > ${OUT} 2>/dev/null
## if test -s ${OUT}
## then
##     ERR=true
##     echo "$0: test ${TEST} failed: found mail in queue"
##     ${VERBOSE} && ${CAT} ${OUT}
## fi
## 
## if ${ERR}
## then
##     echo "$0: test ${TEST} check failed"
##     test X"${SM_STOPONERROR}" != X && exit 1
## else
##     ${VERBOSE} && echo "test ${TEST} succeeded"
## fi
## fi
## 
## 
## # ----------------------------------------
## # discard sender
## TEST=9
## if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
## then
## 
## if ${SHELL} ${SCRIPTS}/smtpcnf.sh -P "-r m=90" -Z 'smtpc2' -A 1 -E 0 -X 0 $@ -S"s${TEST}@b.c" -R"r${TEST}@y.z"
## then
##     ERR=false
## else
##     echo "$0: test ${TEST} failed"
##     ERR=true
## fi
## 
## # check whether there's a mail body
## rm -f ${OUT}
## ls ?/S* > ${OUT} 2>/dev/null
## if test -s ${OUT}
## then
##     ERR=true
##     echo "$0: test ${TEST} failed: found mail in queue"
##     ${VERBOSE} && ${CAT} ${OUT}
## fi
## 
## if ${ERR}
## then
##     echo "$0: test ${TEST} check failed"
##     ERRS=`expr ${ERRS} + 1 `
##     test X"${SM_STOPONERROR}" != X && exit 1
## else
##     ${VERBOSE} && echo "test ${TEST} succeeded"
## fi
## fi

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
