#!/bin/sh
# $Id: t-mcpmts-0.sh,v 1.18 2005/07/21 22:07:38 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test program running the full system, uses mcpmts.sh
# ----------------------------------------
#
test -s stop && exit 1
#

# source directory of this (and other) shell script
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

# cd to right directory
cd ../qmgr || exit 1
rm -f ${MTMAP}

SHELL=/bin/sh
test -x /bin/ksh && SHELL=/bin/ksh

# create directory to pass socket
if test -d smtps
then
  :
else
  mkdir smtps
fi

# ----------------------------------------
${CAT} >${SMXCNF} <<EOF
smtps { log_level = 12;pass_fd_socket = smtps/smtpsfd; wait_for_server=4;
	listen_socket { type=inet; port=${SRVPORT}; }
	start_action = pass; user = ${USER};
	path = ../smtps/smtps;
	arguments = "smtps -f ${SMXCNF} ${SM_SERVER_OPTIONS}";
}
smtpc { log_level = 12;remote_port = ${SNKPORT}; wait_for_server=4;
	start_action = wait; user = ${USER};
	path = "../smtpc/smtpc"; arguments = "smtpc -f ${SMXCNF}";
}
qmgr { log_level = 12;wait_for_server=4; wait_for_client=4; 
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,smtpc,smar, };
	path = "../qmgr/qmgr"; arguments = "qmgr -f ${SMXCNF}";
}
smar { log_level = 12;
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,qmgr };
	path = "../smar/smar"; arguments = "smar -f ${SMXCNF}";
}
EOF

for i in smar smtps smtpc qmgr
do
  cp /dev/null ${i}.log
done

# ----------------------------------------
${SHELL} ${SD}/mcpmts.sh -1 $@ || exit 1

exit 0
