#!/bin/sh
# $Id: t-mail-lu-0.sh,v 1.6 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test rejection of MAIL due to unknown local user
# uses smtpcnf.sh
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
OUT="t-alias-0.out"
LUM="lu.db"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
long: <user0@some.long.domain> <user1@some.long.domain> <user2@some.long.domain> <user3@some.long.domain> <user4@some.long.domain> <user5@some.long.domain> <user6@some.long.domain> <user7@some.long.domain> <user8@some.long.domain> <user9@some.long.domain> <user10@some.long.domain> <user11@some.long.domain> <user12@some.long.domain> <user13@some.long.domain> <user14@some.long.domain> <user15@some.long.domain> <user16@some.long.domain> <user17@some.long.domain> <user18@some.long.domain> <user19@some.long.domain> <user20@some.long.domain> <user21@some.long.domain> <user22@some.long.domain> <user23@some.long.domain> <user24@some.long.domain> <user25@some.long.domain> <user26@some.long.domain> <user27@some.long.domain> <user28@some.long.domain> <user29@some.long.domain> <user30@some.long.domain> <user31@some.long.domain> <user32@some.long.domain> <user33@some.long.domain> <user34@some.long.domain> <user35@some.long.domain> <user36@some.long.domain> <user37@some.long.domain> <user38@some.long.domain> <user39@some.long.domain>
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
some.dom	[127.0.0.1]
EOF

# ----------------------------------------
${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4;
}
smar {
aliases { flags = {local_domains, replace_macros}; }
Log_Level = 12;
nameserver = ${NS};
DNS_timeout = 5;
}
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
}
EOF

# ----------------------------------------
# test: send mail with local address which is not an alias, hence sender is
# rejected by smtps.

TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Stestsender${TEST}@local.dom -Ruser@local.dom -E 0 -X 0 -A 0
then
  if test -s ${B1}
  then
    ERR=true
  else
    :
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi


# ----------------------------------------
# test: send mail with local address which is an alias, hence sender is
# accepted by smtps.

TEST=2
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Ssender@local.dom -Ruser@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
    :
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi


# ----------------------------------------
# test: send mail with local address which is an alias but very long;
# sender is accepted by smtps.

TEST=3
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Slong@local.dom -Ruser@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
    :
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi


rm -f ${MTMAP} ${ALIMAP}
# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
