#!/bin/sh
# $Id: t-regex1.sh,v 1.8 2005/05/31 21:00:28 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
test -s stop && exit 1
#
IN="t-regex1.in"
OUT="t-regex1.out"
ERRORS=0
#
rm -f ${OUT}
./b-regex1 2>/dev/null <<EOF | grep -v time > ${OUT}
ab.de
sendmail.org
asendmail.org
sendmail.orgb
1.sendmail.org
EOF
cat > ${IN} <<EOF
match ab.de=1
match sendmail.org=0
match asendmail.org=1
match sendmail.orgb=1
match 1.sendmail.org=0
EOF
diff ${OUT} ${IN}
R=$?
if test ${R} != 0
then
   ERRORS=`expr ${ERRORS} + 1 `
fi

rm -f ${OUT}
./b-regex1 -p '^sendmail\.org$' 2>/dev/null <<EOF | grep -v time > ${OUT}
ab.de
sendmail.org
asendmail.org
sendmail.orgb
1.sendmail.org
EOF
cat > ${IN} <<EOF
match ab.de=1
match sendmail.org=0
match asendmail.org=1
match sendmail.orgb=1
match 1.sendmail.org=1
EOF
diff ${OUT} ${IN}
R=$?
if test ${R} != 0
then
   ERRORS=`expr ${ERRORS} + 1 `
fi

rm -f ${OUT}
./b-regex1 -p '^endmail\.org$' 2>/dev/null <<EOF | grep -v time > ${OUT}
ab.de
sendmail.org
asendmail.org
sendmail.orgb
1.sendmail.org
endmail.orgb
endmail.org
EOF
cat > ${IN} <<EOF
match ab.de=1
match sendmail.org=1
match asendmail.org=1
match sendmail.orgb=1
match 1.sendmail.org=1
match endmail.orgb=1
match endmail.org=0
EOF
diff ${OUT} ${IN}
R=$?
if test ${R} != 0
then
   ERRORS=`expr ${ERRORS} + 1 `
fi

if test ${ERRORS} -eq 0
then
  rm -f ${IN} ${OUT}
fi

exit ${ERRORS}
