/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-rdstr.c,v 1.1 2005/02/11 23:49:04 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/str.h"
#include "sm/cstr.h"
#include "sm/rdstr.h"
#include "sm/test.h"

#include <stdio.h>

#define SMAXLEN	256

const char *magic = "magic buf";

static int
test1(sm_rdstr_P rdstr)
{
	size_t l;
	uchar *data;

	l = SM_RDSTR_GETLEN(rdstr);
	SM_TEST(l == strlen(magic));
	SM_TEST(SM_RDSTR_RD_ELEM(rdstr, 0) == 'm');
	SM_TEST(SM_RDSTR_RD_ELEM(rdstr, 1) == 'a');
	SM_TEST(SM_RDSTR_RD_ELEM(rdstr, 5) == ' ');
	SM_TEST(SM_RDSTR_RD_ELEM(rdstr, l - 1) == 'f');
	data = SM_RDSTR_DATA(rdstr);
	SM_TEST(data != NULL);
	SM_TEST(data[0] == 'm');
	SM_TEST(data[1] == 'a');
	SM_TEST(data[5] == ' ');
	SM_TEST(data[l - 1] == 'f');
	return 0;
}

static void
test_harness(void)
{
	sm_str_P str;
	sm_cstr_P cstr;

	str = sm_str_scpy(NULL, magic, SMAXLEN);
	SM_TEST(str != NULL);
	SM_TEST(sm_str_getlen(str) == strlen(magic));
	(void) test1((sm_rdstr_P) str);
	sm_str_free(str);

	cstr = sm_cstr_scpyn((uchar *)magic, strlen(magic));
	SM_TEST(cstr != NULL);
	SM_TEST(sm_cstr_getlen(cstr) == strlen(magic));
	(void) test1((sm_rdstr_P) cstr);
	sm_cstr_free(cstr);
}

int
main(int argc, char *argv[])
{
	sm_test_begin(argc, argv, "test rdstr");
	test_harness();
	return sm_test_end();
}
