/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-mkdir.c,v 1.1 2004/02/05 21:52:10 ca Exp $")
#include "sm/error.h"
#include "sm/stat.h"
#include "sm/test.h"

/*
**  MAIN -- guess...
**
**	Parameters:
**		argc -- arg counter
**		argv -- arg vector
**
**	Returns:
**		usual exit code
*/

int
main(int argc, char *argv[])
{
	int r;

	while ((r = getopt(argc, argv, "V")) != -1)
	{
		switch (r)
		{
#if 0
		  case 'V':
			Verbose++;
			break;
#endif /* 0 */
		  default:
/*
			usage(argv[0]);
*/
			return 1;
		}
	}

	sm_test_begin(argc, argv, "test sm_mkdir");
	for (r = optind; r < argc; r++)
	{
		sm_mkdir(argv[r], 0750);
	}
	return sm_test_end();
}
