/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: st-net.c,v 1.5 2005/05/31 21:00:28 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/fcntl.h"
#include "sm/net.h"

#include "statethreads/st.h"
#include "st-net.h"

void
net_st_socket_close(st_netfd_t sock)
{
	st_netfd_close(sock);
}

st_netfd_t
net_st_client_connect(char *ip, int port, st_utime_t tmo)
{
	st_netfd_t nfd;
	int sockfd;
	struct sockaddr_in servaddr;
	ulong hostaddr;

	SM_ASSERT(ip != NULL);
	SM_ASSERT(port > 0);

	if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1)
		return NULL;

	sm_memset(&servaddr, '\0', sizeof(servaddr));
	servaddr.sin_family = AF_INET;
	servaddr.sin_port = htons(port);
	if ((hostaddr = inet_addr(ip)) == INADDR_NONE)
		return NULL;
	sm_memcpy(&servaddr.sin_addr, &hostaddr, sizeof(hostaddr));

	nfd = st_netfd_open_socket(sockfd);
	if (nfd == NULL)
		return NULL;
	if (st_connect(nfd, (struct sockaddr *) &servaddr,
		     sizeof(servaddr), tmo) == -1)
		return NULL;

	return nfd;
}

#if 0
st_netfd_t
net_st_server_accept(st_netfd_t listenfd, struct sockaddr *addr, sockaddr_len_T *addrlen)
{
	st_netfd_t connfd;
	int sockopt;

	SM_ASSERT(listenfd >= 0);
	SM_ASSERT(addr != NULL);
	SM_ASSERT(addrlen != NULL);

	sockopt = 1;
	connfd = st_accept(listenfd, (struct sockaddr *)addr, addrlen, -1);
	if (connfd == NULL)
	{
		if (errno != EAGAIN)
			return NULL;
	}
	else
	{
#if 0
		if (setsockopt(connfd, SOL_SOCKET, SO_KEEPALIVE,
			       (void *) &sockopt, sizeof(sockopt)) == -1)
			return sm_err_perm(errno);
#endif /* 0 */
	}
	return connfd;
}
#endif /* 0 */
