/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: prterr.c,v 1.2 2002/05/06 02:39:30 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "sm/ctype.h"
#include <stdio.h>


/*
**  PRTSTR -- print a message to stderr, then a string,
**		convert unprintable chars to hex
**
**	Parameters:
**		msg -- leading message
**		str --  string to print
**		n -- size of string.
**
**	Returns:
**		nothing.
*/

void
prtstr(char *msg, char *str, int n)
{
	int l;

	if (msg != NULL)
		fprintf(stderr, "%s: ", msg);
	for (l = 0; l < n; l++)
	{
		if (isprint(str[l]))
			putc(str[l], stderr);
		else
			fprintf(stderr, " %02x ", str[l]);
	}
	fprintf(stderr, "\n");
}

/*
**  PRTERR -- print an error text to stderr
**
**	Parameters:
**		msg -- leading message
**		res -- error value to display
**
**	Returns:
**		nothing.
*/

void
prterr(char *msg, sm_ret_T res)
{
	if (res != SM_IO_EOF)
	{
		fprintf(stderr, "%s: res=%x, type=%d, value=%d\n", msg,
			res, sm_error_type(res), sm_error_value(res));
#if HAVE_STRERROR
		fprintf(stderr, "%s: %s\n", msg, strerror(sm_error_value(res)));
#endif /* HAVE_STRERROR */
	}
	else
		fprintf(stderr, "%s: EOF\n", msg);
}
