/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-rcpt-id.c,v 1.1 2005/03/18 19:49:28 ca Exp $")
#include "sm/io.h"
#include "sm/mta.h"
#include "sm/test.h"
#include <stdio.h>

/*
**  TESTIDX -- test extraction of thread index from DA ta id
**
**	Parameters:
**		incr -- when to double step
**		debug -- debug level
**
**	Returns:
**		usual sm_error code.
*/

static int
testidx(uint incr, int debug)
{
	sessta_id_T da_id;
	uint i, j, n, id_count, idx, step;
	int r;

	id_count = 1234;
	n = UINT_MAX / 2 + 1;
	step = 1;
	for (i = 0, j = 0; i < n && j <= UINT_MAX; j += step, i++)
	{
		id_count++;
		sm_snprintf(da_id, SMTP_STID_SIZE, SMTPC_STID_FORMAT,
				4, id_count, j);
		r = SMTPC_GETTHRIDX(da_id, idx);
		SM_TEST(r == 1);
		SM_TEST(idx == j);
		if (idx != j)
		{
			sm_io_fprintf(smioerr, "idx=%u/%X, j=%u/%X, da_id=%s\n",
				idx, idx, j, j, da_id);
			return -1;
		}
		if (j >= UINT_MAX)
			break;
		if (j > UINT_MAX / 16 * 15)
			step = UINT_MAX - j;
/*
		else if (j == UINT_MAX / 2)
			step = UINT_MAX / 4;
		else if (j == 65536)
			step *= 2;
		else if (j == 1024)
			step *= 2;
		else if (j == 256)
			step *= 2;
*/
		else if (i % incr == 0)
		{
			step *= 2;
			if (debug > 1)
				sm_io_fprintf(smioerr, "i=%u, j=%u, step=%u\n",
					i, j, step);
		}
	}
	return 0;
}

int
main(int argc, char *argv[])
{
	int c, debug;
	uint incr;
	sm_ret_T ret;

	incr = 1024;
	debug = 0;
	while ((c = getopt(argc, argv, "d:s:")) != -1)
	{
		switch (c)
		{
		  case 'd':
			debug = strtol(optarg, NULL, 0);
			break;
		  case 's':
			incr = strtol(optarg, NULL, 0);
			break;
#if 0
		  default:
			usage(argv[0]);
			return(1);
#endif
		}
	}

	sm_test_begin(argc, argv, "test rcpt id");
	ret = testidx(incr, debug);
	return sm_test_end();
}
