#!/bin/sh

WHERE=$(dirname $0)
PATH=${WHERE}:/bin:/usr/bin:/usr/local/bin
LOCKFILES=${WHERE}/lockfiles
# edit and un-comment the following line
#DB=~rancid/<group-name>/router.db

if [ -z "${DB}" ]; then
  echo "set DB in $0 before running"
  exit 1
fi

for rt in $(awk -F: '($2 == "cisco" && $3 == "up") { print $1 }' ${DB}); do
  echo "$(date) gathering data from ${rt}"
  lockf -s -t 10 ${LOCKFILES}/lock.${rt} ${WHERE}/poll_cisco.sh ${rt}
done

for rt in $(awk -F: '($2 == "juniper" && $3 == "up") { print $1 }' ${DB}); do
  echo "$(date) gathering data from ${rt}"
  lockf -s -t 10 ${LOCKFILES}/lock.${rt} ${WHERE}/poll_juniper.sh ${rt}
done

