#!/usr/bin/awk -f
#
# $Id: filter_audit.awk,v 1.1.1.1 2002/10/23 07:01:36 jabley Exp $
#
# Search router configs for filter list abuse.

BEGIN {
  IGNORECASE = 1;

# if there are standard filters which all routers hold, regardless of
# whether they are used, you can specify them here. These filters can
# be unused on routers without complaints being generated.
#
#  standard["community-list standard-foo"] = 1;
#  standard["community-list standard-bar"] = 1;
#  standard["as-path-access-list 11"] = 1;
#  standard["route-map some-standard-route-map"] = 1;
#  standard["prefix-list some-standard-prefix-list"] = 1;
#  standard["access-list 76"] = 1;

}


# new router
{
  if (FILENAME != old_filename) {
    router = FILENAME;
    sub(/^.*\//, "", router);
    old_filename = FILENAME;
  }
}


# found a route-map reference
/^ neighbor [a-z0-9\.-]+ route-map / {
  ref[router " route-map " $4] = 1;
  next;
}


# found a prefix-list reference
/^ neighbor [a-z0-9\.-]+ prefix-list / {
  ref[router " prefix-list " $4] = 1;
  next;
}

/^ match ip address prefix-list / {
  ref[router " prefix-list " $5] = 1;
  next;
}


# found an access-list reference
/^ ip access-group / {
  ref[router " access-list " $3] = 1;
  next;
}

/^ match ip address / {
  ref[router " access-list " $4] = 1;
  next;
}

/^ access-class / {
  ref[router " access-list " $2] = 1;
  next;
}


# found an as-path access-list reference
/^ neighbor [a-z0-9\.-]+ filter-list / {
  ref[router " as-path-access-list " $4] = 1;
  next;
}

/^ match as-path / {
  ref[router " as-path-access-list " $3] = 1;
  next;
}


# found a community-list reference
/^ match community / {
  ref[router " community-list " $3] = 1;
  next;
}

/^ set comm-list / {
  ref[router " community-list " $3] = 1;
  next;
}


# found a route-map definition
/^route-map / {
  def[router " route-map " $2] = 1;
  next;
}


# found a prefix-list definition
/^ip prefix-list / {
  def[router " prefix-list " $3] = 1;
  next;
}


# found an access-list definition
/^access-list / {
  def[router " access-list " $2] = 1;
  next;
}

/^ip access-list / {
  def[router " access-list " $4] = 1;
  next;
}


# found an as-path access-list definition
/^ip as-path access-list / {
  def[router " as-path-access-list " $4] = 1;
  next;
}


# found a community-list definition
/^ip community-list expanded / {
  def[router " community-list " $4] = 1;
  next;
}

/^ip community-list standard / {
  def[router " community-list " $4] = 1;
  next;
}

/^ip community-list / {
  def[router " community-list " $3] = 1;
  next;
}


# display results
END {
  for (n in def) {
    split(n, a);
    if (ref[n] != 1 && standard[a[2] " " a[3]] != 1)
      print "unused " n;
  }

  for (n in ref)
    if (def[n] != 1)
      print "undefined " n;
}

