package dbmigs

import (
	"github.com/go-pg/migrations/v7"
)

func init() {
	migrations.MustRegisterTx(func(db migrations.DB) error {
		_, err := db.Exec(`
             -- Add config_hash column to kea_daemon.
             ALTER TABLE kea_daemon ADD COLUMN config_hash TEXT;
        `)
		return err
	}, func(db migrations.DB) error {
		_, err := db.Exec(`
             -- Remove config_hash column from kea_daemon.
             ALTER TABLE kea_daemon DROP COLUMN config_hash;
        `)
		return err
	})
}
