#!/usr/bin/awk -f
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

#
# $Id: named-parse.awk,v 1.3 2002/12/06 21:38:44 lidl Exp $
#

# re-format a named query log for stats gathering

BEGIN {
  month["Jan"] = "01";
  month["Feb"] = "02";
  month["Mar"] = "03";
  month["Apr"] = "04";
  month["May"] = "05";
  month["Jun"] = "06";
  month["Jul"] = "07";
  month["Aug"] = "08";
  month["Sep"] = "09";
  month["Oct"] = "10";
  month["Nov"] = "11";
  month["Dec"] = "12";
}

/query: .*org.isc.org/ {
  split($3, t, /:/);
  logfile = sprintf("/var/log/org/stats/named.2002-%s-%02d", \
    month[$1], int($2));
  print "ote-query", 0, "2002", "09", $2, t[1], t[2], t[3], 0 >>logfile;
}

/query: / {
  split($3, t, /:/);
  logfile = sprintf("/var/log/org/stats/named.2002-%s-%02d", \
    month[$1], int($2));
  print "org-query", 0, "2002", "09", $2, t[1], t[2], t[3], 0 >>logfile;
}

{}
