#!/bin/sh
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: ka_xaction.sh,v 1.3 2002/12/06 21:38:44 lidl Exp $

ISC_MSGQ_PROTO=tcp; export ISC_MSGQ_PROTO
ISC_SRS_DBNAME=${1}_srs ; export ISC_SRS_DBNAME

PATH=@prefix@:$PATH; export PATH
LOGDIR=@logdir@
LOGFILE=${LOGDIR}/xaction-$1.log
XACTIONSLEEP=10

case $1 in
org)
	ISC_MSGQ_PORT=9913
	;;
ote)
	ISC_MSGQ_PORT=9914
	;;
*)
	ISC_MSGQ_PORT=9912
	ISC_SRS_DBNAME=srs
	LOGFILE=${LOGDIR}/xaction.log
	;;
esac
export ISC_MSGQ_PORT

(	while :
	do
		xaction
		sleep ${XACTIONSLEEP}
	done
) >> ${LOGFILE} 2>&1

