#!/usr/bin/awk -f
#
# $Id: torrp.awk,v 1.1 2002/09/02 06:09:53 jabley Exp $

# keep state
{
  prev = this;
  prev_arg = this_arg;

  this = $1;
  this_arg = "";
}

# create out-of-zone nameservers
/^1 / {
  if (prev != "")
    print ".";
  print "ADD\nEntityName:nameserver\nNameserver:" $2;
  next;
}

# create domains
/^2 / {
  this_arg = $2;

  if (this != prev || this_arg != last_arg) {
    if (prev != "")
      print ".";
    print "ADD\nEntityName:domain\nDomainName:" $2;
  }

  print "NameServer:" $3;
  next;
}

/^3 / {
  this_arg = $2;

  if (this != prev || this_arg != last_arg) {
    if (prev != "")
      print ".";
    print "ADD\nEntityName:nameserver\nNameserver:" $2;
  }

  print "IPAddress:" $3;
  next;
}

/^4 / {
  this_arg = $2;

  if (this != prev || this_arg != last_arg) {
    if (prev != "")
      print ".";
    print "MOD\nEntityName:domain\nDomainName:" $2;
  }

  print "Nameserver: " $3;
  next;
}

# ignore everything else
{}

END {
  if (prev != "")
    print ".";
}

