#!/usr/bin/env perl
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: test-db.pl,v 1.10 2002/12/06 21:59:07 lidl Exp $

use lib '@prefix@';

use strict;
use warnings;

use ISC::SRS::DB;
use ISC::Random;
use Time::HiRes qw(gettimeofday tv_interval);

my $srs = new ISC::SRS::DB(replication => "master",
			   replication_name => "srs");
my $rnd = new ISC::Random(strength => "weak");


my $count = 1000000;

my $start = gettimeofday;
my $last = $start;

my $domain = $rnd->base64(12);
print "Using suffix $domain.org\n";

my $c;
for ($c = 0 ; $c < $count ; $c++) {
    my $fqdn = $c . $domain . ".org";
    if ($c % 500 == 0 && $c != 0) {
	my $now = gettimeofday;
	my $interval = $now - $last;
	my $overall = $now - $start;
	printf("%d added in %6.4f seconds (%6.4f) (overall %d, rate %6.4f)\n",
	       500, $interval, 500 / $interval, $c, $c / $overall);
	$last = $now;
    }

    $srs->domain_add(period => 5,
		     fqdn => $fqdn,
		     created_by => 1,
		     status => ["ACTIVE"],
		     registrar_id => 1);
}

my $now = gettimeofday;
my $overall = $now - $start;
printf("Overall insert rate: %6.4f)\n", $c / $overall);
