# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: Direct.pm,v 1.2 2002/12/06 02:21:10 lidl Exp $

package ISC::CC::Direct;

use strict;
use warnings;

use ISC::CC::Message;
use ISC::Net::LengthPrefix;

BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    $VERSION = do { my @r = (q$Revision: 1.2 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};
    @ISA = qw(Exporter);
    @EXPORT = qw();
    @EXPORT_OK = qw();
    %EXPORT_TAGS = ();
}

our @EXPORT_OK;

END {
}

sub new {
    my ($class, %args) = @_;

    $class = ref($class) || $class;

    my $self = bless({}, $class);

    die "Missing argument:  cb" if (!$args{cb});
    die "Missing argument:  error_cb" if (!$args{error_cb});

    $self->{cb} = $args{cb};
    $self->{error_cb} = $args{error_cb};
    $self->{data} = $args{data};

    return $self;
}

sub DESTROY {
    my ($self) = @_;
}

sub data {
    my ($self, $data) = @_;

    if (defined($data)) {
	$self->{data} = $data;
    }

    return $self->{data};
}

sub name {
    my ($self) = @_;

    return $self->{name};
}

sub _msg_cb {
    my ($lp, $buf) = @_;

    my $self = $lp->data;

    my $msg;

    eval {
	$msg = ISC::CC::Message::fromwire($buf);
    };
    if ($@) {
    } else {
	$self->{cb}->(bless($lp, "ISC::CC::DirectSocket"), $msg);
    }
}

sub _msg_err {
    my ($lp, $err) = @_;

    my $self = $lp->data;

    my $errmsg = "Error on socket: " . $lp->name . ": $err";

    $self->{error_cb}->($lp, $errmsg);
}

#
# fully close down the connections
#
sub close {
    my ($self) = @_;
}

package ISC::CC::DirectSocket;

BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    $VERSION = do { my @r = (q$Revision: 1.2 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};
    @ISA = qw(Exporter ISC::Net::LengthPrefix);
    @EXPORT = qw();
    @EXPORT_OK = qw();
    %EXPORT_TAGS = ();
}

our @EXPORT_OK;

sub send {
    my ($self, $msg) = @_;

    my $buf;

    $buf = ISC::CC::Message::towire($msg);
    $self->SUPER::send($buf);
}

1;
