#!/usr/bin/env perl
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: test-crlf-listen.pl,v 1.6 2002/12/06 21:59:07 lidl Exp $

use lib '@prefix@';

use strict;
use warnings;

use Data::Dumper;
use Event qw(loop unloop);

use ISC::Net::CRLF;
use ISC::Net::Listen;

my $sock = new ISC::Net::Listen(cb => \&_listen_cb,
				error_cb => \&_listen_err,
				LocalPort => 4455,
				ReuseAddr => 1,
				Proto => "tcp");

sub _listen_cb {
    my ($l, $sock) = @_;

    warn "New connection";

    my $crlf = new ISC::Net::CRLF(cb => \&_msg_cb,
				  error_cb => \&_msg_err,
				  socket => $sock,
				  oneshot => 1,
				  flush => 1,
				  max_lines => 500,
				  max_line_length => 100,
				  in_block_terminator => ".",
				  out_block_terminator => ".");
}

sub _listen_err {
    my ($foo, $msg) = @_;

    warn "ERROR: $msg";
    unloop();
}

sub _msg_err {
    my ($lp, $msg) = @_;

    print "Error on socket: " . $lp->name . ": $msg\n";
    unloop();
}

my $count = 0;

sub _msg_cb {
    my ($l, $lines) = @_;

    print Data::Dumper->Dump([$lines], ["lines"]);

    $l->send("Got it, thanks. (count = $count)");
    $l->oneshot_reset;
    $count++;
    if ($count > 5) {
	my $s = 'test' x 18;
	my @msg;
	for (my $i = 1 ; $i <= 1000 ; $i++) {
	    push(@msg, "$i " . $s);
	}
	push(@msg, "Last line before shutdown");
	$l->send(\@msg);
	$l->shutdown(10);
    }
}

$Event::DIED = sub {
    Event::verbose_exception_handler(@_);
    Event::unloop_all();
};

Event::loop();
