--
-- Copyright (C) 2002  Internet Software Consortium.
--
-- Permission to use, copy, modify, and distribute this software for any
-- purpose with or without fee is hereby granted, provided that the above
-- copyright notice and this permission notice appear in all copies.
--
-- THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
-- DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
-- IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
-- INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
-- INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
-- FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
-- NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
-- WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

-- $Id: srs-mappings.sql,v 1.5 2002/12/06 21:25:44 lidl Exp $

--
-- contact status table values
--
-- NOTE: currently, there is not support for "PENDING" mode status/operations
--

INSERT INTO contact_status (code, status, description)
        VALUES ('A', 'ok', 'Object is active');
INSERT INTO contact_status (code, status, description)
        VALUES ('d', 'clientDeleteProhibited', 'Client delete prohibited');
INSERT INTO contact_status (code, status, description)
        VALUES ('D', 'serverDeleteProhibited', 'Server delete prohibited');
INSERT INTO contact_status (code, status, description)
        VALUES ('t', 'clientTransferProhibited', 'Client transfer prohibited');
INSERT INTO contact_status (code, status, description)
        VALUES ('T', 'serverTransferProhibited', 'Server transfer prohibited');
INSERT INTO contact_status (code, status, description)
        VALUES ('u', 'clientUpdateProhibited', 'Client update prohibited');
INSERT INTO contact_status (code, status, description)
        VALUES ('U', 'serverUpdateProhibited', 'Server update prohibited');

--
-- domain status table values
--
-- NOTE: we do not support "PENDING" mode status/operations
--
-- NOTE: any 'linked' status field will have to be generated on
--       the fly, as that is really a statement about the data
--       in the database 
--
INSERT INTO domain_status (code, status, description)
        VALUES ('A', 'ok', 'Object is active');
INSERT INTO domain_status (code, status, description)
        VALUES ('I', 'inactive', 'Object is inactive');
INSERT INTO domain_status (code, status, description)
        VALUES ('d', 'clientDeleteProhibited', 'Client delete prohibited');
INSERT INTO domain_status (code, status, description)
        VALUES ('D', 'serverDeleteProhibited', 'Server delete prohibited');
INSERT INTO domain_status (code, status, description)
        VALUES ('h', 'clientHold', 'Client hold on domain');
INSERT INTO domain_status (code, status, description)
        VALUES ('H', 'serverHold', 'Server hold on domain');
INSERT INTO domain_status (code, status, description)
        VALUES ('r', 'clientRenewProhibited', 'Client renew prohibited');
INSERT INTO domain_status (code, status, description)
        VALUES ('R', 'serverRenewProhibited', 'Server renew prohibited');
INSERT INTO domain_status (code, status, description)
        VALUES ('t', 'clientTransferProhibited', 'Client transfer prohibited');
INSERT INTO domain_status (code, status, description)
        VALUES ('T', 'serverTransferProhibited', 'Server transfer prohibited');
INSERT INTO domain_status (code, status, description)
        VALUES ('u', 'clientUpdateProhibited', 'Client update prohibited');
INSERT INTO domain_status (code, status, description)
        VALUES ('U', 'serverUpdateProhibited', 'Server update prohibited');

--
-- host status table values
--
INSERT INTO host_status (code, status, description)
        VALUES ('A', 'ok', 'Object is active');
INSERT INTO host_status (code, status, description)
        VALUES ('d', 'clientDeleteProhibited', 'Client delete prohibited');
INSERT INTO host_status (code, status, description)
        VALUES ('D', 'serverDeleteProhibited', 'Server delete prohibited');
INSERT INTO host_status (code, status, description)
        VALUES ('u', 'clientUpdateProhibited', 'Client update prohibited');
INSERT INTO host_status (code, status, description)
        VALUES ('U', 'serverUpdateProhibited', 'Server update prohibited');

