/*  $Revision: 1.21 $
**
**  pathgrep, Tobias.Hennerich@swabsib.s.bawue.de
*/
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include "configdata.h"
#include "clibrary.h"
#include <ctype.h>
#include <sys/stat.h>
#if	defined(DO_NEED_TIME)
#include <time.h>
#endif	/* defined(DO_NEED_TIME) */
#include <sys/time.h>
#include <errno.h>
#include "paths.h"
#include "libinn.h"
#include "inndcomm.h"
#include "dbz.h"
#include "macros.h"
#include "mydir.h"
#include "tree.h"
#include "can.h"
#include "qci.h"


typedef struct _BUFFER {
    char	*Data;
    int		Size;
    int		Used;
} BUFFER;

/*
**  Information about the schema of the news overview files.
*/
typedef struct _ARTOVERFIELD {
    char	*Header;
    int		Length;
    BOOL	HasHeader;
} ARTOVERFIELD;

STATIC char		SPOOL[] = _PATH_SPOOL;
STATIC char		*SCHEMA = _PATH_SCHEMA;
STATIC ARTOVERFIELD	*ARTfields;
STATIC int		ARTfieldsize;

/*
**  Read the overview schema.
*/
static void
ARTreadschema()
{
    register FILE		*F;
    register char		*p;
    register ARTOVERFIELD	*fp;
    register int		i;
    char			buff[SMBUF];

    /* Open file, count lines. */
    if ((F = fopen(SCHEMA, "r")) == NULL) {
	(void)fprintf(stderr, "Can't open %s, %s\n", SCHEMA, strerror(errno));
	exit(1);
    }
    for (i = 0; fgets(buff, sizeof buff, F) != NULL; i++)
	continue;
    (void)fseek(F, (OFFSET_T)0, SEEK_SET);
    ARTfields = NEW(ARTOVERFIELD, i + 1);

    /* Parse each field. */
    for (fp = ARTfields; fgets(buff, sizeof buff, F) != NULL; ) {
	/* Ignore blank and comment lines. */
	if ((p = strchr(buff, '\n')) != NULL)
	    *p = '\0';
	if ((p = strchr(buff, COMMENT_CHAR)) != NULL)
	    *p = '\0';
	if (buff[0] == '\0')
	    continue;
	if ((p = strchr(buff, ':')) != NULL) {
	    *p++ = '\0';
	    fp->HasHeader = EQ(p, "full");
	}
	else
	    fp->HasHeader = FALSE;
	fp->Header = COPY(buff);
	fp->Length = strlen(buff);
	fp++;
    }
    ARTfieldsize = fp - ARTfields;
    (void)fclose(F);
}


/*
**  Read an article and create an overview line without the trailing
**  newline.  Returns pointer to static space or NULL on error.
*/
STATIC char *
OVERgen(canpos)
    char			*canpos;
{
    static ARTOVERFIELD		*Headers;
    static BUFFER		B;
    register ARTOVERFIELD	*fp;
    register ARTOVERFIELD	*hp;
    register ARTOVERFIELD	*lasthp = 0;
    register QCISTATE		*qp;
    register char		*colon;
    register char		*line;
    register char		*p;
    register char		*q;
    register int		i;
    register int		size;
    register int		ov_size;
    register long		lines;
    long			t;
    char			value[10];
    char			buffer[MAXHEADERSIZE];
    
    /* Open article. */
    if ((qp = QCIopen(canpos, QCI_BUFFER)) == NULL)
	return NULL;

    /* Set up place to store headers. */
    if (Headers == NULL) {
	Headers = NEW(ARTOVERFIELD, ARTfieldsize);
	for (hp = Headers, i = ARTfieldsize; --i >= 0; hp++)
	    hp->Length = 0;
    } else {
	/* This disposes from the previous call.  This simplifies
	   handling later on.  We trade off this readable code
	   for the problem that nothing DISPOSEs() the last
	   caller's use.  mibsoft 8/22/97
	 */
	for (hp = Headers, i = ARTfieldsize; --i >= 0; hp++) {
	    if (hp->HasHeader) {
		DISPOSE(hp->Header);
		hp->Header = 0;
	    }
	    hp->Length = 0;
	}
    }
    for (hp = Headers, i = ARTfieldsize; --i >= 0; hp++)
	hp->HasHeader = FALSE;

    for ( ; ; ) {
	/* Read next line. */
	if ((line = QCIread(qp)) == NULL) {
	    if (QCItoolong(qp))
		continue;
	    /* Error or EOF (in headers!?); shouldn't happen. */
	    QCIclose(qp);
	    return NULL;
	}

	/* End of headers? */
	if (*line == '\0')
	    break;

	/* See if we want this header. */
	fp = ARTfields;
	for (hp = Headers, i = ARTfieldsize; --i >= 0; hp++, fp++) {
	    colon = &line[fp->Length];
	    if (*colon != ':')
		continue;
	    *colon = '\0';
	    if (!caseEQ(line, fp->Header)) {
		*colon = ':';
		continue;
	    }
	    *colon = ':';
	    if (fp->HasHeader)
		p = line;
	    else
		/* Skip colon and whitespace, store value. */
		for (p = colon; *++p && ISWHITE(*p); )
		    continue;
	    size = strlen(p);
            hp->Length = size;
            hp->Header = NEW(char, hp->Length + 1);
	    (void)strcpy(hp->Header, p);
	    for (p = hp->Header; *p; p++)
		if (*p == '\t' || *p == '\n' || *p == '\r')
		    *p = ' ';
	    hp->HasHeader = TRUE;
            lasthp = hp;
            break ;             /* the first one is used */
	}
        /* handle multi-line headers -- kondou@uxd.fc.nec.co.jp */
        if (i < 0) {
            if (lasthp && ISWHITE(*line)) {
                lasthp->Length += strlen(line);
                RENEW(lasthp->Header, char, lasthp->Length + 1);
                for (p = line; *p; p++)
                    if (*p == '\t' || *p == '\n' || *p == '\r')
                        *p = ' ';
                strcat(lasthp->Header, line);
            } else {
                lasthp = 0 ;
            }
        }
    }

    /* Read body of article, just to get lines. */
    for (lines = 0; ; lines++)
	if ((p = QCIread(qp)) == NULL) {
	    if (QCItoolong(qp))
		continue;
	    if (QCIerror(qp)) {
		QCIclose(qp);
		return NULL;
	    }
	    break;
	}

    /* Calculate total size, fix hardwired headers. */
    ov_size = ARTfieldsize + 2;
    for (hp = Headers, fp = ARTfields, i = ARTfieldsize; --i >= 0; hp++, fp++) {
	if (caseEQ(fp->Header, "Bytes") || caseEQ(fp->Header, "Lines")) {
	    if (fp->Header[0] == 'B' || fp->Header[0] == 'b')
		t = QCIartsize(qp);
	    else
		t = lines;

	    (void)sprintf(value, "%ld", t);
	    size = strlen(value);
	    if (hp->Length == 0) {
		 hp->Length = size;
		hp->Header = NEW(char, hp->Length + 1);
	    }
	    else if (hp->Length < size) {
		hp->Length = size;
		RENEW(hp->Header, char, hp->Length + 1);
	    }
	    (void)strcpy(hp->Header, value);
	    hp->HasHeader = TRUE;
       }
       if (hp->HasHeader)
	   ov_size += strlen(hp->Header);
	   
	if(caseEQ(fp->Header, "Xref"))
	{   p=strchr(hp->Header, ' ')+1;
	    p=strchr(p, ' ')+1;

	    q=buffer;

	    while( *p )
	    {	*q=*p;
	    	if( *q=='.' || *q==':' )
		    *q='/';
		
		p++;
		q++;
	    }
	    
	    *q='\0';
	}	    
    }

    ov_size+=strlen(buffer);
    
    /* Get space. */
    if (B.Size == 0) {
	B.Size = ov_size;
	B.Data = NEW(char, B.Size + 1);
    }
    else if (B.Size < ov_size) {
	B.Size = ov_size;
	RENEW(B.Data, char, B.Size + 1);
    }

    /* Glue all the fields together. */
    p = B.Data + strlen(strcpy(B.Data, buffer));
    for (hp = Headers, i = ARTfieldsize; --i >= 0; hp++) {
	*p++ = '\t';
	if (hp->HasHeader)
	    p += strlen(strcpy(p, hp->Header));
    }
    *p = '\0';

    QCIclose(qp);
    return B.Data;
}

/*
**  Process one newsgroup directory.
*/
STATIC void
DoCan(canName)
    char		*canName;
{
    struct stat		Sb;
    int			fd;
    char		buff[SPOOLNAMEBUFF];
    long		Bytepos;
    char		artsize[20];
    char		*p;
    long		artlength;
    int			artcount;
    
    if( stat(canName, &Sb)<0 )
    {	(void)fprintf(stderr, "Can't stat %s, %s\n", canName, strerror(errno));
    	return ;
    }

    if( (fd=open(canName, O_RDONLY, 0666))<0 )
    {   (void)fprintf(stderr, "Can't open %s, %s\n", canName, strerror(errno));
	return;
    }
    
    Bytepos=47;						/* !!! */
    lseek(fd, Bytepos, SEEK_SET);
    artcount=0;
    fprintf(stderr, "can %s: ", canName);

    for( ;; )
    {   if( read(fd, artsize, 12)!=12 )
	    break;
	    
	if( *artsize!='-' && *artsize!='+' )
	    break;
    
	if( strspn(artsize+1, "0123456789")!=10 )
	    break;

	if( artsize[11]!='\n' )
	    break;
	
	artlength=atol(artsize);

	if( artlength>0 )
	{   sprintf(buff, "%s!%010ld", canName, Bytepos);
	
	    if( (p=OVERgen(buff))==NULL )
	    	continue;
	
	    printf("%s\n", p);
	}
	else
	    artlength = -artlength;
	
	Bytepos+=artlength+12;
	artcount++;
	lseek(fd, Bytepos, SEEK_SET);
    }
    
    fprintf(stderr, "%d articles\n", artcount);

    close(fd);    
}


int
main(ac, av)
    int			ac;
    char		*av[];
{
    static char		CANTCD[] = "Can't cd to %s, %s\n";
    DIR			*dirp, *shelfDirp;
    DIRENTRY		*dp, *shelfDp;
    char		name[SPOOLNAMEBUFF];

    if (chdir(SPOOL) < 0) {
	(void)fprintf(stderr, CANTCD, SPOOL, strerror(errno));
	exit(1);
    }

    ARTreadschema();

    dirp=opendir(".");
    for( dp=readdir(dirp); dp!=NULL; dp=readdir(dirp) )
    {	if( !strncmp(dp->d_name, "shelf.", 6))
	{   shelfDirp=opendir(dp->d_name);
	
	    for(shelfDp=readdir(shelfDirp);shelfDp;shelfDp=readdir(shelfDirp) )
	    {	if( strlen(shelfDp->d_name)!=strlen("yyyymmddhhxx") )
		    continue;

		sprintf(name, "%s/%s", dp->d_name, shelfDp->d_name);

		DoCan(name);
	    }

	    closedir(shelfDirp);
	}
    }
    closedir(dirp);

    exit(0);
    /* NOTREACHED */
}
