/*  $Revision: 1.1.1.1 $
**
**  Newsgroups and the active file.
*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/uio.h>
#include "configdata.h"
#include "clibrary.h"
#include "nnrpd.h"
#include "mydir.h"
#include "macros.h"
#include "tree.h"
#include "can.h"

/*
**  Newsgroup hashing stuff.  See comments in innd/ng.c.
*/

#define GRP_HASH(Name, p, j)	\
	for (p = Name, j = 0; *p; ) j = (j << 5) + j + *p++
#define GRP_SIZE	512
#define GRP_BUCKET(j)	&GRPtable[j & (GRP_SIZE - 1)]

typedef struct _GRPHASH {
    int		Size;
    int		Used;
    GROUPENTRY	**Groups;
} GRPHASH;


STATIC GRPHASH		GRPtable[GRP_SIZE];
STATIC GROUPENTRY	*GRPentries;
STATIC int		GRPbuckets;
STATIC int		GRPsize;

/*
** Kopierter Krempel aus article.c, Tobi
*/

typedef struct _ARTOVERFIELD {
    char	*Header;
    int		Length;
    BOOL	HasHeader;
    BOOL	NeedsHeader;
} ARTOVERFIELD;

extern ARTOVERFIELD	*ARTfields;
extern int		ARTfieldsize;
extern int		ARTfirstfullfield;

/*
** und expireover.c, Tobi
*/

/*
**  A buffer; re-uses space.
*/
typedef struct _BUFFER {
    int		Used;
    int		Size;
    char	*Data;
} BUFFER;

/*
**   Information about a line in the overview file.
*/
typedef struct _LINE {
    ARTNUM	Article;
    char	*Start;
    int		Length;
    int		Offset;
    char	*Canpos;
} LINE;

/*
**  Unlock the group.
*/
STATIC void
UnlockGroup(lfd, lockfile)
    int		lfd;
    char	*lockfile;
{
    if (lfd > 0) {
	if (unlink(lockfile) < 0 && errno != ENOENT)
	    (void)fprintf(stderr, "expireover cant unlink %s %s\n",
		    lockfile, strerror(errno));
	if (close(lfd) < 0)
	    (void)fprintf(stderr, "expireover cant close %s %s\n",
		    lockfile, strerror(errno));
	lfd = -1;
    }
}

/*
**  See if a given newsgroup exists.
*/
GROUPENTRY *
GRPfind(group)
    register char		*group;
{
    register char		*p;
    register unsigned int	j;
    register int		i;
    register GROUPENTRY		**gpp;
    GRPHASH			*htp;
    char			c;

    /* SUPPRESS 6 *//* Over/underflow from plus expression */
    GRP_HASH(group, p, j);
    htp = GRP_BUCKET(j);
    for (c = *group, gpp = htp->Groups, i = htp->Used; --i >= 0; gpp++)
	if (c == gpp[0]->Name[0] && EQ(group, gpp[0]->Name))
	    return gpp[0];
    return NULL;
}


STATIC void
GRPhash()
{
    register char		*p;
    register int		i;
    register GROUPENTRY		*gp;
    register unsigned int	j;
    register GRPHASH		*htp;

    /* Set up the default hash buckets. */
    GRPbuckets = GRPsize / GRP_SIZE;
    if (GRPbuckets == 0)
	GRPbuckets = 1;
    if (GRPtable[0].Groups)
	for (i = GRP_SIZE, htp = GRPtable; --i >= 0; htp++)
	    htp->Used = 0;
    else
	for (i = GRP_SIZE, htp = GRPtable; --i >= 0; htp++) {
	    htp->Size = GRPbuckets;
	    htp->Groups = NEW(GROUPENTRY*, htp->Size);
	    htp->Used = 0;
	}

    /* Now put all groups into the hash table. */
    for (i = GRPsize, gp = GRPentries; --i >= 0; gp++) {
	/* SUPPRESS 6 *//* Over/underflow from plus expression */
	GRP_HASH(gp->Name, p, j);
	htp = GRP_BUCKET(j);
	if (htp->Used >= htp->Size) {
	    htp->Size += GRPbuckets;
	    RENEW(htp->Groups, GROUPENTRY*, htp->Size);
	}
	htp->Groups[htp->Used++] = gp;
    }

    /* Note that we don't sort the buckets. */
}


/*
**  Read the active file into memory, sort it, and set the number of
**  newsgroups read in.  Return TRUE if okay, FALSE on error.
*/
BOOL
GetGroupList()
{
    static char			*active;
    register char		*p;
    register char		*q;
    register GROUPENTRY		*gp;
    register int		i;

    /* If re-scanning, free previous groups. */
    if (active != NULL) {
	DISPOSE(active);
	DISPOSE(GRPentries);
    }

    /* Get the new file. */
    active = ReadInFile(ACTIVE, (struct stat *)NULL);
    if (active == NULL) {
	syslog(L_ERROR, "%s cant read %s %m", ClientHost, ACTIVE);
	return FALSE;
    }

    /* Count lines. */
    for (p = active, i = 0; (p = strchr(p, '\n')) != NULL; p++, i++)
	continue;

    /* Fill in the group array. */
    GRPentries = NEW(GROUPENTRY, i);
    for (i = 0, gp = GRPentries, p = active; *p; i++, gp++, p = q + 1) {
	gp->Name = p;
	if ((p = strchr(p, ' ')) == NULL) {
	    syslog(L_ERROR, "%s internal no_space1 \"%.20s...\"",
		ClientHost, gp->Name);
	    return FALSE;
	}
	*p++ = '\0';

	/* Get the high mark. */
	if ((q = strchr(p, ' ')) == NULL) {
	    syslog(L_ERROR, "%s internal no_space2 \"%.20s...\"",
		ClientHost, gp->Name);
	    return FALSE;
	}
	*q++ = '\0';
	gp->High = atol(p);

	/* Get the low mark. */
	if ((p = strchr(q, ' ')) == NULL) {
	    syslog(L_ERROR, "%s internal no_space3 \"%.20s...\"",
		ClientHost, gp->Name);
	    return FALSE;
	}
	*p++ = '\0';
	gp->Low = atol(q);

	/* Kill the newline. */
	if ((q = strchr(p, '\n')) == NULL) {
	    syslog(L_ERROR, "%s internal newline \"%.20s...\"",
		ClientHost, gp->Name);
	    return FALSE;
	}
	*q = '\0';
	gp->Flag = *p;
	gp->Alias = gp->Flag == NF_FLAG_ALIAS ? p + 1 : NULL;
    }

    GRPsize = i;
    GRPhash();
    return TRUE;
}


/*
**  Sorting predicate to put lines in numeric order.
*/
STATIC int
LINEcompare(p1, p2)
    CPOINTER p1;
    CPOINTER p2;
{
    LINE	*lp1;
    LINE	*lp2;

    lp1 = CAST(LINE*, p1);
    lp2 = CAST(LINE*, p2);
    return lp1->Article - lp2->Article;
}

/*
**  Fill in ARTnumbers with the numbers of the articles in the current
**  group.
*/
STATIC void
GRPscandir(dir)
    char		*dir;
{
    static char		SPOOL[] = _PATH_SPOOL;
    static int		ARTarraysize=0;
    static char		**mallocbase=NULL;
    char		**currentbase=NULL;
    char		*currentARTcanpos=NULL;
    int			currentblocksize=64*1024;
    register char	*p;
    char		*next;
    int			i;
    QIOSTATE		*OVERqp;
    static int		field=0;
    char		name[SPOOLNAMEBUFF];
    char		*OVERline;
    time_t		now;
    BOOL		mustSort;
    static BUFFER	B;
    static LINE		*Lines;
    static int		LineSize;
    register struct iovec	*vp;
    register LINE	*lp;
    register LINE	*end;
    char		lockfile[SPOOLNAMEBUFF];
    int			fd;
    int			lfd;
    struct stat		Sb;
    struct iovec	iov[8];
    int			iTobi;
    char		*pTobi;
    
    /* Go to the directory. */
    if (chdir(SPOOL) < 0) {
	syslog(L_FATAL, "%s cant cd %s %m", ClientHost, SPOOL);
	ExitWithStats(1);
    }
    
    if (ARTarraysize == 0) {
	ARTarraysize = 1024;
	ARTnumbers = NEW(ARTNUM, ARTarraysize);
	ARTcanpos = NEW(char *, ARTarraysize);

	mallocbase=currentbase=(char **)calloc(16, sizeof(char *));
	*currentbase=NEW(char, currentblocksize);
	currentARTcanpos=*currentbase;
    }
    else
    {	i=1;
    	while( mallocbase[i] )
	{   free(mallocbase[i]);
	    mallocbase[i]=NULL;
	    i++;
	}
	currentbase=mallocbase;
	currentARTcanpos=*currentbase;
	currentblocksize=64*1024;
    }

    /* The newsgroup directory might not exist; treat it as empty. */
    GRPcount++;

    if( !field )
    {	for (field = 0, i = 0; i < ARTfieldsize; i++)
	{	if (caseEQ(ARTfields[i].Header, "Xcanpos")) {
		field = i + 1;
		break;
	    }
	}
    }
        
    if( field==0 )
    {	syslog(L_FATAL, "%s cant find Xcanpos in nov", ClientHost);
	ExitWithStats(1);
    }

    do
    {   (void)time(&now);
	mustSort=FALSE;
    	ARTsize = 0;

	(void)sprintf(name, "%s/%s/%s", _PATH_OVERVIEWDIR, dir, 
							_PATH_OVERVIEW);
	if( OVERqp = QIOopen(name, QIO_BUFFER) )
	{   for ( ; ; )
	    {   OVERline = QIOread(OVERqp);
		
		if( OVERline==NULL )
		{   if( QIOtoolong(OVERqp) )
			continue;
		    break;
		}
	
		if (ARTsize + 1 >= ARTarraysize) {
		    ARTarraysize += 1024;
		    RENEW(ARTnumbers, ARTNUM, ARTarraysize);
		    RENEW(ARTcanpos, char *, ARTarraysize);
		}
    
		ARTnumbers[ARTsize] = atol(OVERline);
    
		p=OVERline;
		for( i=field; --i>=0 && *p; p++ )
		{   if( (p=strchr(p, '\t'))==NULL )
			continue;
		}
		if( *p=='\0' )
		    continue;
    
		if( CANdelete(p)<now )
		    continue;
    
		if( ARTsize )
		{   if( ARTnumbers[ARTsize]<=ARTnumbers[ARTsize-1] )
		    {   mustSort=TRUE;
			break;
		    }
		}
		
		if( ARTfields[field-1].NeedsHeader )	/* was HasHeader !!! */
		    p+=ARTfields[field-1].Length+2;		/* Tobi */
		
		if ((next = strchr(p, '\t')) != NULL)
		    i = next - p;
		else
		    i = strlen(p);
    
		if( currentARTcanpos+i+1>*currentbase+currentblocksize )
		{   currentbase++;
		    currentblocksize*=2;
		    *currentbase=NEW(char, currentblocksize);
		    currentARTcanpos=*currentbase;
		}
	
		ARTcanpos[ARTsize] = currentARTcanpos;	
		(void)strncpy(ARTcanpos[ARTsize], p, i);
		ARTcanpos[ARTsize][i]='\0';
		currentARTcanpos+=i+1;
		
		ARTsize++;
		
	/*	if( (ARTsize%10000)==0 )
	 *	    sleep(1);
	 */ }
	    QIOclose(OVERqp);
	}
    
	if( mustSort )
	{   syslog(L_NOTICE, "must resort %s", name);	
	
    	    ARTsize = 0;
	    /* Lock the group. */
	    (void)sprintf(lockfile, "%s/%s/.LCK%s", _PATH_OVERVIEWDIR,
	    						dir, _PATH_OVERVIEW);
	    lfd = open(lockfile, O_WRONLY | O_TRUNC | O_CREAT, ARTFILE_MODE);
	    if (lfd < 0) {
		if( errno!=EEXIST )
		    syslog(L_ERROR, "Can't open %s, %m", lockfile);
		sleep(1);
		continue;
	    }
	
	    /* Open file, lock it. */
	    for ( ; ; ) {
		if ((fd = open(name, O_RDWR)) < 0) {
		    if( errno!=ENOENT )
			syslog(L_ERROR, "Can't open %s, %m", name);
		    UnlockGroup(lfd, lockfile);
		    return;
		}
		if (LockFile(fd, FALSE) >= 0)
		    break;
	/* Wait for lock; close file -- might be unlinked -- and try again. */
		(void)LockFile(fd, TRUE);
		(void)close(fd);
	    }
	
	    if (fstat(fd, &Sb) < 0) {
		syslog(L_ERROR, "Can't open %s, %m", name);
		UnlockGroup(lfd, lockfile);
		(void)close(fd);
		continue;
	    }
	    if (Sb.st_size == 0) {
		/* Empty file; done deleting. */
		UnlockGroup(lfd, lockfile);
		(void)close(fd);
		continue;
	    }
	
	    /* Read in the whole file. */
	    if (B.Size == 0) {
		B.Size = Sb.st_size + 1;
		B.Data = NEW(char, B.Size);
	    }
	    else if (B.Size <= Sb.st_size) {
		B.Size = Sb.st_size + 1;
		RENEW(B.Data, char, B.Size);
	    }
	    if (xread(fd, B.Data, Sb.st_size) < 0) {
		syslog(L_ERROR, "Can't read %s, %m", name);
		UnlockGroup(lfd, lockfile);
		(void)close(fd);
		continue;
	    }
	    B.Data[Sb.st_size] = '\0';
	
	    /* Count lines, get space. */
	    for (i = 1, p = B.Data; (p = strchr(p, '\n')) != NULL && *++p; i++)
		continue;
	    if (LineSize == 0) {
		LineSize = i;
		Lines = NEW(LINE, LineSize + 1);
	    }
	    else if (LineSize < i) {
		LineSize = i;
		RENEW(Lines, LINE, LineSize + 1);
	    }
	
	    /* Build line array. */
	    for (lp = Lines, p = B.Data; ; p = next, lp++) {
		if ((next = strchr(p, '\n')) == NULL)
		    break;
		lp->Start = p;
		lp->Length = ++next - p;
		lp->Article = atol(p);
	
		pTobi=p;
		for( iTobi=field; --iTobi>=0 && *p; pTobi++ )
		{   if( (pTobi=strchr(pTobi, '\t'))==NULL )
			break;
		}
		if( pTobi==NULL || *pTobi=='\0' )
		{   syslog(L_ERROR, "corrupt line in %s", name);
		    continue;
		}
		
		if( ARTfields[field-1].HasHeader )
		    pTobi+=ARTfields[field-1].Length+2;
		
		lp->Canpos=pTobi;
	    }
	    qsort((POINTER)Lines, (SIZE_T)(lp - Lines), sizeof lp[0], 
	    							LINEcompare);
	
	    /* Remove duplicates. */
	    for (end = lp - 1, lp = Lines; lp < end; lp++)
		if (lp[0].Article == lp[1].Article)
		    lp->Article = 0;
		
	    iov[0].iov_len = 0;
	    for (vp = iov, lp = Lines; lp < end + 1; lp++) {
		/* An already-removed article, or one that should be? */
		if (lp->Article == 0)
		    continue;
	
		if( CANdelete(lp->Canpos)<now )
		    continue;
	
		/* We're keeping this entry; see if we can add it to any
		    * in-progress iov element. */
		if (vp->iov_len) {
		    if (((char *) vp->iov_base) + vp->iov_len == lp->Start) {
			/* Contiguous. */
			vp->iov_len += lp->Length;
			continue;
		    }
	
		    /* Doesn't fit -- get a new element. */
		    if (++vp == ENDOF(iov)) {
			if (xwritev(lfd, iov, SIZEOF(iov)) < 0) {
			    syslog(L_ERROR, "Can't write %s, %m", lockfile);
			    UnlockGroup(lfd, lockfile);
			    (void)close(fd);
			    return;
			}
			vp = iov;
		    }
		}
	
		/* Start new element. */
		vp->iov_base = lp->Start;
		vp->iov_len = lp->Length;
	    }
	
	    /* Write out remaining. */
	    if (vp->iov_len)
		vp++;
	    if (iov[0].iov_len && xwritev(lfd, iov, vp - iov) < 0) {
		syslog(L_ERROR, "Can't write %s, %m", lockfile);
		UnlockGroup(lfd, lockfile);
		(void)close(fd);
		continue;
	    }
	
	    if (rename(lockfile, name) < 0)
		syslog(L_ERROR, "Can't rename %s, %m", lockfile);
	
	    /* Don't call UnlockGroup; do it inline. */
	    if (close(lfd) < 0)
		syslog(L_ERROR, "cant close %s %m", name);
	    if (close(fd) < 0)
		syslog(L_ERROR, "cant close unlinked %s %m", name);
	}
    }
    while( mustSort );
    
    ARTcache = NULL;
}


/*
**  Change to or list the specified newsgroup.  If invalid, stay in the old
**  group.
*/
FUNCTYPE
CMDgroup(ac, av)
    int			ac;
    char		*av[];
{
    static time_t	last_time;
    static char		NOSUCHGROUP[] = NNTP_NOSUCHGROUP;
    register char	*p;
    register int	i;
    time_t		now;
    char		*grplist[2];
    char		*group;
    char		buff[SPOOLNAMEBUFF];

    if (!PERMcanread) {
	Reply("%s\r\n", NOACCESS);
	return;
    }

    /* Parse arguments. */
    if (ac == 1) {
	if (GRPcount == 0) {
	    Printf("%d No group specified\r\n", NNTP_XGTITLE_BAD);
	    return;
	}
	(void)strcpy(buff, GRPlast);
	for (p = buff; *p; p++)
	    if (*p == '/')
		*p = '.';
	group = buff;
    }
    else
	group = av[1];
    if (GRPfind(group) == NULL) {
	Reply("%s %s\r\n", NOSUCHGROUP,group);
	return;
    }

    /* If permission is denied, pretend group doesn't exist. */
    if (PERMspecified) {
	grplist[0] = group;
	grplist[1] = NULL;
	if (!PERMmatch(PERMdefault, PERMlist, grplist)) {
	    Reply("%s\r\n", NOSUCHGROUP);
	    return;
	}
    }
    else if (!PERMdefault) {
	Reply("%s\r\n", NOSUCHGROUP);
	return;
    }

    /* Close out any existing article, report group stats. */
    ARTclose();
    ARTindex = 0;
    GRPreport();

    /* Make the group name a directory name. */
    (void)strcpy(buff, group);
    for (p = buff; *p; p++)
	if (*p == '.')
	    *p = '/';

    /* If we haven't been in the group recently, rescan. */
    (void)time(&now);
    if (!EQ(buff, GRPlast) || now > last_time + NNRP_RESCAN_DELAY) {
	GRPscandir(buff);
	(void)strcpy(GRPlast, buff);
	last_time = now;
    }

    /* Close down any overview file. */
    OVERclose();

    /* Doing a "group" command? */
    if (caseEQ(av[0], "group")) {
	if (ARTsize == 0)
	    Reply("%d 0 0 0 %s\r\n", NNTP_GROUPOK_VAL, group);
	else
	    Reply("%d %d %ld %ld %s\r\n",
		NNTP_GROUPOK_VAL,
		ARTsize, ARTnumbers[0], ARTnumbers[ARTsize - 1], group);
    }
    else {
	/* Must be doing a "listgroup" command. */
	Reply("%d Article list follows\r\n", NNTP_GROUPOK_VAL);
	for (i = 0; i < ARTsize; i++)
	    Printf("%ld\r\n", ARTnumbers[i]);
	Printf(".\r\n");
    }
}


/*
**  Report on the number of articles read in the group, and clear the count.
*/
void
GRPreport()
{
    register char	*p;
    char		buff[SPOOLNAMEBUFF];

    if (GRPlast[0] && GRParticles != 0) {
	(void)strcpy(buff, GRPlast);
	for (p = buff; *p; p++)
	    if (*p == '/')
		*p = '.';
	syslog(L_NOTICE, "%s group %s %ld", ClientHost, buff, GRParticles);
	GRParticles = 0;
    }
}


/*
**  Used by ANU-News clients.
*/
FUNCTYPE
CMDxgtitle(ac, av)
    int			ac;
    char		*av[];
{
    register QIOSTATE	*qp;
    register char	*line;
    register char	*p;
    register char	*q;
    char		save;

    /* Parse the arguments. */
    if (ac == 1) {
	if (GRPcount == 0) {
	    Printf("%d No group specified\r\n", NNTP_XGTITLE_BAD);
	    return;
	}
	p = GRPlast;
    }
    else
	p = av[1];

    /* Open the file, get ready to scan. */
    if ((qp = QIOopen(NEWSGROUPS, QIO_BUFFER)) == NULL) {
	syslog(L_ERROR, "%s cant open %s %m", ClientHost, NEWSGROUPS);
	Printf("%d Can't open %s\r\n", NNTP_XGTITLE_BAD, NEWSGROUPS);
	return;
    }
    Printf("%d list follows\r\n", NNTP_XGTITLE_OK);

    /* Print all lines with matching newsgroup name. */
    while ((line = QIOread(qp)) != NULL) {
	for (q = line; *q && !ISWHITE(*q); q++)
	    continue;
	save = *q;
	*q = '\0';
	if (wildmat(line, p)) {
	    *q = save;
	    Printf("%s\r\n", line);
	}
    }

    /* Done. */
    QIOclose(qp);
    Printf(".\r\n");
}
