#include <port_before.h>
#include <bind_registry.h>
#include <port_after.h>

/*
 * Module Variables
 */
static char systemDir[MAX_PATH];
static char namedBase[MAX_PATH];
static DWORD baseLen = MAX_PATH;

BOOL InitPaths()
{
	HKEY hKey;

	memset(namedBase, 0, MAX_PATH);
	if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, BIND_SUBKEY, 0, KEY_READ, &hKey) != ERROR_SUCCESS)
		return(FALSE);
	
	// Get the named directory
	if(RegQueryValueEx(hKey, "InstallDir", NULL, NULL, (LPBYTE)namedBase, &baseLen) != ERROR_SUCCESS)
		return(FALSE);
	
	RegCloseKey(hKey);

	GetSystemDirectory(systemDir, MAX_PATH);
	return(TRUE);	
}

char *BINDPath(int id)
{
	static char buf[_MAX_PATH];
	memset(buf, 0, _MAX_PATH);

	switch(id)
	{
		case PATH_ETC_ID:
			sprintf(buf, "%s\\etc", namedBase);
			break;
		case PATH_DEBUG_ID:
			sprintf(buf, "%s\\etc\\named.run", namedBase);
			break;
		case PATH_CONF_ID:
			sprintf(buf, "%s\\etc\\named.conf", namedBase);
			break;
		case PATH_PIDFILE_ID:
			sprintf(buf, "%s\\etc\\named.pid", namedBase);
			break;
		case PATH_TMPXFER_ID:
			sprintf(buf, "%s\\etc\\xfer.ddt.XXXXX", namedBase);
			break;
		case PATH_XFER_ID:
			sprintf(buf, "%s\\bin\\named-xfer.exe", namedBase);
			break;
		case PATH_NAMED_ID:
			sprintf(buf, "%s\\bin\\named.exe", namedBase);
			break;
		case PATH_HOSTS_ID:
			sprintf(buf, "%s\\Drivers\\etc\\HOSTS", systemDir);
			break;
		case PATH_NETWORKS_ID:
			sprintf(buf, "%s\\Drivers\\etc\\NETWORKS", systemDir);
			break;
		case PATH_PROTOCOL_ID:		
			sprintf(buf, "%s\\Drivers\\etc\\PROTOCOL", systemDir);
			break;
		case PATH_SERVICES_ID:		
			sprintf(buf, "%s\\Drivers\\etc\\SERVICES", systemDir);
			break;
		case PATH_RESCONF_ID:			
			sprintf(buf, "%s\\Drivers\\etc\\resolv.conf", systemDir);
			break;
		default:
			return(NULL);
			break;
	}
	return(buf);
}