#!/bin/sh
#
# Copyright (C) 2004, 2007, 2009, 2012  Internet Systems Consortium, Inc. ("ISC")
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
# REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
# OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.

# $Id: tests.sh,v 1.10 2012/02/02 03:26:55 marka Exp $

SYSTEMTESTTOP=..
. $SYSTEMTESTTOP/conf.sh

status=0

#
echo "I: checking that we detect a NS which refers to a CNAME"
if $CHECKZONE . cname.db > cname.out 2>&1
then
	echo "I:failed (status)"; status=`expr $status + 1`
else
	if grep "is a CNAME" cname.out > /dev/null
	then
		:
	else
		echo "I:failed (message)"; status=`expr $status + 1`
	fi
fi

#
echo "I: checking that we detect a NS which is below a DNAME"
if $CHECKZONE . dname.db > dname.out 2>&1
then
	echo "I:failed (status)"; status=`expr $status + 1`
else
	if grep "is below a DNAME" dname.out > /dev/null
	then
		:
	else
		echo "I:failed (message)"; status=`expr $status + 1`
	fi
fi

#
echo "I: checking that we detect a NS which has no address records (A/AAAA)"
if $CHECKZONE . noaddress.db > noaddress.out
then
	echo "I:failed (status)"; status=`expr $status + 1`
else
	if grep "has no address records" noaddress.out > /dev/null
	then
		:
	else
		echo "I:failed (message)"; status=`expr $status + 1`
	fi
fi

#
echo "I: checking that we detect a NS which has no records"
if $CHECKZONE . nxdomain.db > nxdomain.out
then
	echo "I:failed (status)"; status=`expr $status + 1`
else
	if grep "has no address records" noaddress.out > /dev/null
	then
		:
	else
		echo "I:failed (message)"; status=`expr $status + 1`
	fi
fi

#
echo "I: checking that we detect a NS which looks like a A record (fail)"
if $CHECKZONE -n fail . a.db > a.out 2>&1
then
	echo "I:failed (status)"; status=`expr $status + 1`
else
	if grep "appears to be an address" a.out > /dev/null
	then
		:
	else
		echo "I:failed (message)"; status=`expr $status + 1`
	fi
fi

#
echo "I: checking that we detect a NS which looks like a A record (warn=default)"
if $CHECKZONE . a.db > a.out 2>&1
then
	if grep "appears to be an address" a.out > /dev/null
	then
		:
	else
		echo "I:failed (message)"; status=`expr $status + 1`
	fi
else
	echo "I:failed (status)"; status=`expr $status + 1`
fi

#
echo "I: checking that we detect a NS which looks like a A record (ignore)"
if $CHECKZONE -n ignore . a.db > a.out 2>&1
then
	if grep "appears to be an address" a.out > /dev/null
	then
		echo "I:failed (message)"; status=`expr $status + 1`
	else
		:
	fi
else
	echo "I:failed (status)"; status=`expr $status + 1`
fi

#
echo "I: checking that we detect a NS which looks like a AAAA record (fail)"
if $CHECKZONE -n fail . aaaa.db > aaaa.out 2>&1
then
	echo "I:failed (status)"; status=`expr $status + 1`
else
	if grep "appears to be an address" aaaa.out > /dev/null
	then
		:
	else
		echo "I:failed (message)"; status=`expr $status + 1`
	fi
fi

#
echo "I: checking that we detect a NS which looks like a AAAA record (warn=default)"
if $CHECKZONE . aaaa.db > aaaa.out 2>&1
then
	if grep "appears to be an address" aaaa.out > /dev/null
	then
		:
	else
		echo "I:failed (message)"; status=`expr $status + 1`
	fi
else
	echo "I:failed (status)"; status=`expr $status + 1`
fi

#
echo "I: checking that we detect a NS which looks like a AAAA record (ignore)"
if $CHECKZONE -n ignore . aaaa.db > aaaa.out 2>&1
then
	if grep "appears to be an address" aaaa.out > /dev/null
	then
		echo "I:failed (message)"; status=`expr $status + 1`
	else
		:
	fi
else
	echo "I:failed (status)"; status=`expr $status + 1`
fi

#
echo "I: checking 'rdnc zonestatus' output"
ret=0 
for i in 0 1 2 3 4 5 6 7 8 9
do
	$RNDC -c ../common/rndc.conf -s 10.53.0.1 -p 9953 zonestatus master.example > rndc.out.master 2>&1
	grep "zone not loaded" rndc.out.master > /dev/null || break
	sleep 1
done
checkfor() {
	grep "$1" $2 > /dev/null || {
		ret=1;
		echo "I: missing '$1' from '$2'"
	}
}
checkfor "name: master.example" rndc.out.master
checkfor "type: master" rndc.out.master
checkfor "files: master.db, master.db.signed" rndc.out.master
checkfor "serial: " rndc.out.master
checkfor "nodes: " rndc.out.master
checkfor "last loaded: " rndc.out.master
checkfor "secure: yes" rndc.out.master
checkfor "inline signing: no" rndc.out.master
checkfor "key maintenance: automatic" rndc.out.master
checkfor "next key event: " rndc.out.master
checkfor "next resign node: " rndc.out.master
checkfor "next resign time: " rndc.out.master
checkfor "dynamic: yes" rndc.out.master
checkfor "frozen: no" rndc.out.master
for i in 0 1 2 3 4 5 6 7 8 9
do
	$RNDC -c ../common/rndc.conf -s 10.53.0.2 -p 9953 zonestatus master.example > rndc.out.slave 2>&1
	grep "zone not loaded" rndc.out.slave > /dev/null || break
	sleep 1
done
checkfor "name: master.example" rndc.out.slave
checkfor "type: slave" rndc.out.slave
checkfor "files: slave.db" rndc.out.slave
checkfor "serial: " rndc.out.slave
checkfor "nodes: " rndc.out.slave
checkfor "next refresh: " rndc.out.slave
checkfor "expires: " rndc.out.slave
checkfor "secure: yes" rndc.out.slave

if [ $ret != 0 ]; then echo "I:failed"; fi
status=`expr $status + $ret`

echo "I:exit status: $status"
exit $status
