/*
 * Copyright (C) 2010-2011  Internet Systems Consortium, Inc. ("ISC")
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/* $Id: fake6.c 1214 2011-06-30 11:03:54Z fdupont $ */

/*
 * PCP (port-control-protocol) fake testing server
 *
 * Francis_Dupont@isc.org, December 2010
 *
 */

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

/* PCP port number (== NAT-PMP port number) */
#ifndef PORT
#define PORT		5351
#endif

int
main(void)
{
	struct sockaddr_in6 sin6;
	time_t now;
#ifndef MAXSIZE
#define MAXSIZE		1024
#endif
	uint8_t buf[MAXSIZE];
	int s;
	ssize_t len;
	socklen_t l;
	uint16_t n16;
	uint32_t n32;

	memset(&sin6, 0, sizeof(sin6));
	sin6.sin6_family = AF_INET6;
#ifdef BSD
	sin6.sin6_len = sizeof(sin6);
#endif
	sin6.sin6_port = htons(PORT);
	s = socket(PF_INET6, SOCK_DGRAM, IPPROTO_UDP);
	if (s < 0)
		err(1, "socket");
	if (bind(s, (struct sockaddr *) &sin6, sizeof(sin6)) < 0)
		err(1, "bind");
	for (;;) {
		memset(buf, 0, sizeof(buf));
		memset(&sin6, 0, sizeof(sin6));
		l = sizeof(sin6);
		len = recvfrom(s, buf, sizeof(buf), 0,
			       (struct sockaddr *) &sin6, &l);
		if (len < 0)
			err(1, "recvfrom");
		if (len < 4) {
			err(1, "short packet");
			continue;
		}
		if (buf[1] & 128) {
			err(1, "response packet");
			continue;
		}
		buf[1] |= 128;
#ifndef STRIPSIZE
#define STRIPSIZE	1024
#endif
		if (len > STRIPSIZE) {
			err(1, "long packet");
			len = STRIPSIZE;
			buf[3] = 2;
		}
		else {
#ifdef ERROR
		buf[3] = ERROR;
#else
		buf[3] = 0;
#endif
		}
#ifdef LIFETIME
		n32 = htonl(LIFETIME);
		memcpy(buf + 4, &n32, 4);
#endif
#ifndef EPOCH
#define EPOCH		1262269440
#endif
		now = time(NULL);
		n32 = htonl(now - EPOCH);
		memcpy(buf + 8, &n32, 4);
#ifndef EXTPORT
#define EXTPORT		9876
#endif
		n16 = htons(EXTPORT);
		memcpy(buf + 34, &n16, 2);
#ifndef EXTADDR
#define EXTADDR		0x0a000001
#endif
		n32 = htonl(EXTADDR);
		memcpy(buf + 36, &n32, 4);
		(void) sendto(s, buf, (size_t) len, 0,
			      (struct sockaddr *) &sin6, l);
	}
	return 0;
}
