/* $Id: miniupnpdtypes.h,v 1.2 2008/01/27 22:24:39 nanard Exp $ */
/* MiniUPnP project
 * http://miniupnp.free.fr/ or http://miniupnp.tuxfamily.org/
 * (c) 2006-2007 Thomas Bernard
 * This software is subject to the conditions detailed
 * in the LICENCE file provided within the distribution */
#ifndef __MINIUPNPDTYPES_H__
#define __MINIUPNPDTYPES_H__

#include "config.h"
#include <netinet/in.h>
#include <sys/queue.h>

#include "pcp.h"

/* structure for storing lan addresses
 * with ascii representation and mask */
struct lan_addr_s {
	char str[16];	/* example: 192.168.0.1 */
	struct in_addr addr, mask;	/* ip/mask */
};

/* timeouts */
struct timeout {
	LIST_ENTRY(timeout) chain;
	struct timeval when;
	void (*action)(void *);
	void *arg;
};

#define TTYPE_SYSTEM	83
#define TTYPE_PCP	80
#define TTYPE_NATPMP	78
#define TTYPE_UPNP	85

/* transactions */
struct transaction {
	/* header */
	LIST_ENTRY(transaction) chain;		/* chain */
	void *parent;				/* back pointer */
	void (*handler)(struct transaction *);	/* response receive handler */
	int type;				/* type */
	/* common part */
	pcp_t pcp;				/* PCP library handler */
	pcp_response_t response;		/* PCP library response */
	int status;				/* PCP library result */
	struct timeout retrans;			/* retransmit timeout */
};
#endif
