/* $Id: upnpredirect.h,v 1.15 2009/02/14 11:01:14 nanard Exp $ */
/* MiniUPnP project
 * http://miniupnp.free.fr/ or http://miniupnp.tuxfamily.org/
 * (c) 2006 Thomas Bernard 
 * This software is subject to the conditions detailed
 * in the LICENCE file provided within the distribution */

#ifndef __UPNPREDIRECT_H__
#define __UPNPREDIRECT_H__

#include "config.h"

/* per redirection structure */
struct upnp_redirect {
	struct transaction t;
	struct upnphttp *h;
	uint32_t lifetime;
	struct timeout renew;
	struct timeout expire;
	int kind;
	char proto;
	unsigned short iport;
	unsigned short eport;
	char iaddr[INET_ADDRSTRLEN];
	char desc[];
};

/* upnp_*_redirect() 
 * calls OS/fw dependant implementation of the redirection.
 * protocol should be the string "TCP" or "UDP"
 * returns: 0 on success
 *          -1 failed to redirect
 * kind: -1 AddAnyPortMapping
 *        0 WANIPConnection:1#AddPortMapping
 *        1 WANIPConnection:2#AddPortMapping
 */
int
upnp_static_redirect(unsigned short eport,
		     const char * iaddr, unsigned short iport,
		     const char * protocol, const char * desc);

void
upnp_dynamic_redirect(struct upnphttp *h,
		      unsigned short *eport,
		      const char * iaddr, unsigned short iport,
		      const char * protocol, unsigned int life,
		      const char * desc, int kind);

/* upnp_get_redirect() */
struct upnp_redirect *
upnp_get_redirect(unsigned short eport, const char * protocol);

/* upnp_get_redirect_by_index */
struct upnp_redirect *
upnp_get_redirect_by_index(int index);

/* upnp_delete_redirect()
 * returns: 0 on success
 *          -1 on failure*/
int
upnp_delete_redirect(unsigned short eport, const char * protocol, int kind);

int
upnp_get_redirect_number();

void
UPnPAddHandler(struct transaction *t);

void
UPnPAddAnyHandler(struct transaction *t);

void
UPnPDelHandler(struct transaction *t);

void
UPnPRenewHandler(struct transaction *t);

/* AddPortMappingHandler(): handler for AddPortMapping result */
/* from upnpsoap.h */
void
AddPortMappingHandler(struct upnphttp *h, int v2);

void
AddAnyPortMappingHandler(struct upnphttp *h, unsigned short eport);

void
DelPortMappingHandler(struct upnphttp *h, int v2);

#endif
