// $Id: ASMacroMap.cc 1.11 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include "config.hh"
#include <iostream.h>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include "whois.hh"
#include "ASMacroMap.h"
#include "ASMap.h"

void ASMacroMap::dump() {
   Pix p, q;

   for (p = first(); p; next(p)) {
      cout << key(p) << " " << contents(p).evaluated << endl;

      for (q = contents(p).value.first(); q; contents(p).value.next(q) )
	 cout << "  AS" << contents(p).value(q) << endl;
   }
}

Pix char2pix_use_AS_map(char *word) {
   return AS_map.add_entry_already_allocated(word);
}

_SetOfPix& ASMacroMap::expand(Pix p, WhoisParser& db) {
   // Check the evaluated field to see if we've expanded it already.

   if (! contents(p).evaluated) {
      contents(p).evaluated = 1;

      char buf[100];

      sprintf(buf,"!i%s,1\n", key(p));
      db.ParseExpansion(buf, key(p), contents(p).value, char2pix_use_AS_map);
   }
   
   return contents(p).value;
}
	
void ASMacro2AS(Pix p, _SetOfPix &ASset ) {
   ASset |= ASMacro_map.expand(p);
}

void ASMacro2AS( _SetOfPix &ASMacroSet, _SetOfPix &ASset ) {
   for(Pix r = ASMacroSet.first(); r; ASMacroSet.next( r ) )
      ASMacro2AS((Pix) ASMacroSet( r ), ASset);
}

