// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _STNameNormalExpressionPtrAVLMap_h
#ifdef __GNUG__
#pragma interface
#endif
#define _STNameNormalExpressionPtrAVLMap_h 1

#include "config.hh"
#include "STName.NormalExpressionPtr.Map.h"

struct STNameNormalExpressionPtrAVLNode
{
  STNameNormalExpressionPtrAVLNode*      lt;
  STNameNormalExpressionPtrAVLNode*      rt;
  STName                 item;
  NormalExpressionPtr                 cont;
  char                stat;
                      STNameNormalExpressionPtrAVLNode(STName  h, NormalExpressionPtr  c, 
                                    STNameNormalExpressionPtrAVLNode* l=0, STNameNormalExpressionPtrAVLNode* r=0);
                      ~STNameNormalExpressionPtrAVLNode();
};

inline STNameNormalExpressionPtrAVLNode::STNameNormalExpressionPtrAVLNode(STName  h, NormalExpressionPtr  c, 
                                    STNameNormalExpressionPtrAVLNode* l, STNameNormalExpressionPtrAVLNode* r)
     :lt(l), rt(r), item(h), cont(c), stat(0) {}

inline STNameNormalExpressionPtrAVLNode::~STNameNormalExpressionPtrAVLNode() {}

typedef STNameNormalExpressionPtrAVLNode* STNameNormalExpressionPtrAVLNodePtr;


class STNameNormalExpressionPtrAVLMap : public STNameNormalExpressionPtrMap
{
protected:
  STNameNormalExpressionPtrAVLNode*   root;

  STNameNormalExpressionPtrAVLNode*   leftmost();
  STNameNormalExpressionPtrAVLNode*   rightmost();
  STNameNormalExpressionPtrAVLNode*   pred(STNameNormalExpressionPtrAVLNode* t);
  STNameNormalExpressionPtrAVLNode*   succ(STNameNormalExpressionPtrAVLNode* t);
  void            _kill(STNameNormalExpressionPtrAVLNode* t);
  void            _add(STNameNormalExpressionPtrAVLNode*& t);
  void            _del(STNameNormalExpressionPtrAVLNode* p, STNameNormalExpressionPtrAVLNode*& t);

public:
                STNameNormalExpressionPtrAVLMap(NormalExpressionPtr  dflt);
                STNameNormalExpressionPtrAVLMap(STNameNormalExpressionPtrAVLMap& a);
                ~STNameNormalExpressionPtrAVLMap();

  NormalExpressionPtr&          operator [] (STName  key);

  void          del(STName  key);

  Pix           first();
  void          next(Pix& i);
  STName&          key(Pix i);
  NormalExpressionPtr&          contents(Pix i);

  Pix           seek(STName  key);
  int           contains(STName  key);

  void          clear(); 

  Pix           last();
  void          prev(Pix& i);

  int           OK();
};

inline STNameNormalExpressionPtrAVLMap::~STNameNormalExpressionPtrAVLMap()
{
  _kill(root);
}

inline STNameNormalExpressionPtrAVLMap::STNameNormalExpressionPtrAVLMap(NormalExpressionPtr  dflt) :STNameNormalExpressionPtrMap(dflt)
{
  root = 0;
}

inline Pix STNameNormalExpressionPtrAVLMap::first()
{
  return Pix(leftmost());
}

inline Pix STNameNormalExpressionPtrAVLMap::last()
{
  return Pix(rightmost());
}

inline void STNameNormalExpressionPtrAVLMap::next(Pix& i)
{
  if (i != 0) i = Pix(succ((STNameNormalExpressionPtrAVLNode*)i));
}

inline void STNameNormalExpressionPtrAVLMap::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((STNameNormalExpressionPtrAVLNode*)i));
}

inline STName& STNameNormalExpressionPtrAVLMap::key(Pix i)
{
  if (i == 0) error("null Pix");
  return ((STNameNormalExpressionPtrAVLNode*)i)->item;
}

inline NormalExpressionPtr& STNameNormalExpressionPtrAVLMap::contents(Pix i)
{
  if (i == 0) error("null Pix");
  return ((STNameNormalExpressionPtrAVLNode*)i)->cont;
}

inline void STNameNormalExpressionPtrAVLMap::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int STNameNormalExpressionPtrAVLMap::contains(STName  key)
{
  return seek(key) != 0;
}

#endif
