// $Id: aut-num.cc 1.2 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#include "config.hh"
#include "aut-num.hh"
#include "dbase.hh"

void AutNum::print() {
    if (asno) 
	cout << AS_map.key(asno) << "\n";

   ASPolicy *p;
   Filter_Action *fap;
   InterASPolicy *ip;

   for (p = peers.head(); p; p = peers.next(p->peers)) {
      cout << "Peer " << AS_map.key(p->peeras) << "\n";

      cout << "   default:\n";

      for (fap = p->dflt.head(); fap; fap = p->dflt.next(fap->falist)) {
	 cout << "      Action " ;
	 fap->action->InOrderPrint();
	 cout << " filter " ;
	 fap->filter->InOrderPrint();
	 cout << "\n";
      }

      cout << "   as-in:\n";

      for (fap = p->in.head(); fap; fap = p->in.next(fap->falist)) {
	 cout << "      Action " ;
	 fap->action->InOrderPrint();
	 cout << " filter " ;
	 fap->filter->InOrderPrint();
	 cout << "\n";
      }

      cout << "   interas-in:\n";
      for (ip = p->interas.head(); ip; ip = p->interas.next(ip->interas)) {
	 cout << "      laddr " << Prefask_map(ip->laddress) 
	      <<      " raddr " << Prefask_map(ip->raddress) << "\n";
	 
	 for (fap = ip->in.head(); fap; fap = ip->in.next(fap->falist)) {
	    cout << "         Action " ;
	    fap->action->InOrderPrint();
	    cout << " filter " ;
	    fap->filter->InOrderPrint();
	    cout << "\n";
	 }
      }

      cout << "   as-out:\n";

      for (fap = p->out.head(); fap; fap = p->out.next(fap->falist)) {
	 cout << "      Action " ;
	 fap->action->InOrderPrint();
	 cout << " filter " ;
	 fap->filter->InOrderPrint();
	 cout << "\n";
      }

      cout << "   interas-out:\n";
      for (ip = p->interas.head(); ip; ip = p->interas.next(ip->interas)) {
	 cout << "      laddr " << Prefask_map(ip->laddress) 
	      <<      " raddr " << Prefask_map(ip->raddress) << "\n";
	 
	 for (fap = ip->out.head(); fap; fap = ip->out.next(fap->falist)) {
	    cout << "         Action " ;
	    fap->action->InOrderPrint();
	    cout << " filter " ;
	    fap->filter->InOrderPrint();
	    cout << *fap->filter;
	    cout << "\n";
	 }
      }
    }
}


void AutNum::print(ostream &os, ListHead<NonPolicyLines> &lh)
{
   NonPolicyLines *lines;
   for (lines = lh.head(); lines; lines = lh.next(lines->node))
      os << lines->line << endl;
}


void AutNum::printPolicyLine(ostream &os)
{
   printASIn(os);
   printASOut(os);
   printInterASIn(os);
   printInterASOut(os);
   printDefault(os);
}

void AutNum::printASIn(ostream &os)
{
   ASPolicy *p;
   Filter_Action *fap;

   for (p = peers.head(); p; p = peers.next(p->peers)) 
      p->printASIn(os);
}

void AutNum::printASOut(ostream &os)
{
   ASPolicy *p;
   Filter_Action *fap;
 
   for (p = peers.head(); p; p = peers.next(p->peers)) 
      p->printASOut(os);
}

void AutNum::printInterASIn(ostream &os)
{
   ASPolicy *p;
   Filter_Action *fap;
   InterASPolicy *ip;

   for (p = peers.head(); p; p = peers.next(p->peers)) 
      for (ip = p->interas.head(); ip; ip = p->interas.next(ip->interas)) 
	 {
	    for (fap = ip->in.head(); fap; fap = ip->in.next(fap->falist)) 
	       os << "interas-in:   " 
		  << AS_map.key(p->peeras) 
		  << " "
		  << Prefask_map(ip->laddress)
		  << " "
		  << Prefask_map(ip->raddress)
		  << " " 
		  << fap->action 
		  << fap->filter 
		  << endl;
	 }
}

void AutNum::printInterASOut(ostream &os)
{
   ASPolicy *p;
   Filter_Action *fap;
   InterASPolicy *ip;

   for (p = peers.head(); p; p = peers.next(p->peers)) 
      for (ip = p->interas.head(); ip; ip = p->interas.next(ip->interas)) 
	 {
	 for (fap = ip->out.head(); fap; fap = ip->out.next(fap->falist)) 
	    os << "interas-out:  " 
	       << AS_map.key(p->peeras) 
	       << " " 
	       << Prefask_map(ip->laddress)
	       << " "
	       << Prefask_map(ip->raddress)
	       << " "
	       << fap->action 
	       << fap->filter 
	       << endl;
	 }
}

void AutNum::printDefault(ostream &os)
{
   ASPolicy *p;
   Filter_Action *fap;

   for (p = peers.head(); p; p = peers.next(p->peers)) 
      p->printDefault(os);
}

