//  $Id: radix.hh 1.2 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)


#ifndef RADIX_H
#define RADIX_H

#include <cstdlib>
#include "config.hh"
#include "Route.hh"

#define MAXPREFIXLEN 32
#define MORE_SPECIFIC 2
#define TRUE 1
#define FALSE 0

// The following define whether the components of the aggregates also have
// to be printed or not
#define NO_COMPONENTS 0
#define COMPONENTS 1

// The following define the state of the nodes of the radix tree
#define EMPTY 0
#define FULL 1
#define AGGREGATE 3
#define COMPONENT 4

class addr {
public:
  unsigned int prefix;
  unsigned int length;
  Route rt; 
  addr *components;
  addr *next;
  
  addr() {
    prefix = 0;
    length = 0;
    rt.clear();
    components = NULL;
    next = NULL;
  }

  ~addr() {
    rt.clear();
  }
} ;


class radix_node {
public:
  radix_node *leftc;    // left child
  radix_node *rightc;   // right child
  radix_node *parent;   // parent
  unsigned int prefix;
  unsigned int length;          // prefix length
  Origin origin;                // route originator 
  int state;                    // describes the state of the node
  
  radix_node() {
    leftc = NULL;
    rightc = NULL;
    parent = NULL;
    prefix = 0;
    length = 0;
    origin.clear();
    state = 0;
  }
  
  ~radix_node() {
    origin.clear();
  }
};


extern radix_node *radix_create_node(radix_node *,unsigned int,unsigned int,Pix,int);
extern int radix_insert(unsigned int,unsigned int,Pix,radix_node *);
int wt_of_subtree(radix_node*);
extern void radix_delete_node(radix_node *);
extern void radix_delete_tree(radix_node *);
extern int radix_delete(unsigned int,unsigned int,radix_node *);
extern int  radix_search(unsigned int,unsigned int,radix_node *);
extern void radix_aggregate(radix_node *);
extern addr* radix_get_aggs(radix_node *);
extern addr* radix_get_nonaggs(radix_node*);
extern char* int2dd(char *,unsigned int);
#endif


