// $Id: ASMap.cc 1.12.1.2 Fri, 31 Oct 1997 15:04:19 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

#include "config.hh"
#include <iostream.h>
#include <cstdlib>

#include "whois.hh"
#include "ASMap.h"
#include "PrefaskMap.hh"
#include "aut-num.hh"
#include "net.hh"
#include "Route.hh"

void ASMap::dump() {
   Pix p, q, prefask_pix;

   for (p = first(); p; next(p)) {
		
      cout << key(p) << " " << contents(p).evaluated << endl;

      for(q = contents(p).value.first(); q; contents(p).value.next(q)) {
	 prefask_pix = (Pix) contents(p).value(q);
	 cout << "    " << Prefask_map(prefask_pix) << endl;
      }
   }
}

Pix char2pix_use_Prefask_map(char *word) {
   return Prefask_map.add_entry_already_allocated(word);
}

_SetOfPix& ASMap::expand(Pix p) {
   // Check the evaluated field to see if we've expanded it already

   if (! contents(p).evaluated) {
      contents(p).evaluated = 1;

      char buf[100];

      sprintf(buf,"!g%s\n", key(p));
      whois.ParseExpansion((char *) buf, key(p), contents(p).value, 
			   char2pix_use_Prefask_map);
   }

   return contents(p).value;
}

void AS2AdrPrfx(Pix p, _SetOfPix &PRFXset ) {
   PRFXset |= AS_map.expand(p);
}

void AS2AdrPrfx( _SetOfPix &ASSet, _SetOfPix &PRFXset ) {
   for(Pix r = ASSet.first(); r; ASSet.next( r ) ) 
      AS2AdrPrfx((Pix) ASSet( r ), PRFXset);
}

AutNum *ASMap::define(Pix asp) {
   if (contents(asp).definition)
      return (AutNum *) contents(asp).definition;

   char rc, buf[100];  
   AutNum *as = new AutNum;

   contents(asp).definition = (void *) as;

   sprintf(buf,"!man,%s\n", key(asp));

   if (! whois.ParseAutNum((char *) buf, *as)) // Object is not defined, 
                                         // perhaps key not found
      return (AutNum *) contents(asp).definition;

   // handle extended and original attribute handling
   handle_extended_and_original_attr(as);

   return (AutNum *) contents(asp).definition;
}

void ASMap::handle_extended_and_original_attr(AutNum *as)
{ 
   // handle extended and original attribute handling
   ASPolicy *p;
   InterASPolicy *ip;
   int ext_in, ext_out;

   for (p = as->peers.head(); p; p = as->peers.next(p->peers)) {
      // check to see if an extended-.*in attribute is used
      // if so set ext_in
      ext_in = !p->ext_in.is_empty();
      if (!ext_in)
	 for (ip = p->interas.head(); ip; ip = p->interas.next(ip->interas))
	    if (!ip->ext_in.is_empty()) {
	       ext_in = 1;
	       break;
	    }
      
      // check to see if an extended-.*ou attribute is used
      // if so set ext_out
      ext_out = !p->ext_out.is_empty();
      if (!ext_out)
	 for (ip = p->interas.head(); ip; ip = p->interas.next(ip->interas))
	    if (!ip->ext_out.is_empty()) {
	       ext_out = 1;
	       break;
	    }

      // if an extended attribute is used, 
      // replace the value of the original attribute with the extended one
      if (ext_in) {
	 p->in.clear();
	 p->in.splice(p->ext_in);
      }

      if (ext_out) {
	 p->out.clear();
	 p->out.splice(p->ext_out);
      }

      for (ip = p->interas.head(); ip; ip = p->interas.next(ip->interas)) {
	 if (ext_in) {
	    ip->in.clear();
	    ip->in.splice(ip->ext_in);
	 }

	 if (ext_out) {
	    ip->out.clear();
	    ip->out.splice(ip->ext_out);
	 }
      }
   }

   int max = 1;
   Filter_Action *fap;
   int pref, ind, i, j;
#define NUMBER_OF_PREFERENCES 100
   int prefs[NUMBER_OF_PREFERENCES];
   
   // rank interas-in preferences in (as, peer-as) groups
   // smallest becomes 0, next one becomes 1, etc
   for (p = as->peers.head(); p; p = as->peers.next(p->peers)) {
      ind = 0;
      for (ip = p->interas.head(); ip; ip = p->interas.next(ip->interas)) {
	 for (fap = ip->in.head(); fap; fap = ip->in.next(fap->falist)) {
	    pref = ((PrefNode *) fap->action->FindFirst(T_PrefNode))->pref();
	    if (pref >= 0) {
	       for (i = 0; i < ind && prefs[i] < pref; i++)
		  ;
	       if (i == ind || prefs[i] != pref) {
		  ind++;
		  ASSERT(ind <= NUMBER_OF_PREFERENCES);
		  for (j = ind - 1; j > i; j--)
		     prefs[j] = prefs[j-1];
		  prefs[i] = pref;
	       }
	    }
	 }
      }
      for (i = 0; i < ind; i++)
	 p->ipref_map[prefs[i]] = i;	       
      if (ind > max)
	 max = ind;
   }

   // below max is incremented, which is not desired
   // it is so so that the preferences come out the same 
   // between this and the older versions of RtConfig 
   max++;

   // rank as-in preferences
   ind = 0;
   for (p = as->peers.head(); p; p = as->peers.next(p->peers)) {
      for (fap = p->in.head(); fap; fap = p->in.next(fap->falist)) {
	 pref = ((PrefNode *) fap->action->FindFirst(T_PrefNode))->pref();
	 if (pref >= 0) {
	    for (i = 0; i < ind && prefs[i] < pref; i++)
	       ;
	    if (i == ind || prefs[i] != pref) {
	       ind++;
	       ASSERT(ind <= NUMBER_OF_PREFERENCES);
	       for (j = ind - 1; j > i; j--)
		  prefs[j] = prefs[j-1];
	       prefs[i] = pref;
	    }
	 }
      }
   }
   for (i = 0; i < ind; i++)
      as->pref_map[prefs[i]] = i * max;	       
}

Pix ASMap::add_entry(ipAddr &ipaddr) {
   Route route;

   route.nlri.pix = Prefask_map.add_entry(ipaddr);

   route.define_less_or_equal_specific();
   if (route.origin.size() > 0)
      return route.origin.head()->pix;

   return NULL;
}

// Added by wlee@isi.edu
void ASMap::clear(void) {
  for (Pix p = first(); p; next(p))
    {
      SymTab s = contents(p);
      if (s.definition) {
	delete (AutNum *)s.definition;
	s.definition = NULL;
      }
    }
  Map::clear();
}
