#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/unistd.h>
#include <linux/module.h>

#define peek_at(a,b,c) \
	(lseek(kmem, (off_t)a, SEEK_SET) > 0) && \
	(read(kmem, (char *)&b, sizeof(c)) == sizeof(c))

static int get_kernel_syms(struct kernel_sym *buffer)
{
	extern int syscall(int, ...);

	return syscall( __NR_get_kernel_syms, buffer);
}

int
main(int argc, char **argv)
{
	struct kernel_sym *ksymtab;
	struct kernel_sym *ksym;
	struct module module_struct;
	int mod_use_count;
	int nksyms;
	int kmem;

	if ((kmem = open("/dev/kmem", O_RDONLY)) < 0) {
		perror("/dev/kmem");
		exit(2);
	}

	/* get the size of the current kernel symbol table */
	if ((nksyms = get_kernel_syms(NULL)) <= 0)
		return 1;

	ksymtab = (struct kernel_sym *)malloc(nksyms * sizeof(struct kernel_sym));
	if (get_kernel_syms(ksymtab) != nksyms) {
		perror("Kernel symbol problem");
		return 1;
	}

	printf("module\tusage\n");

	for (ksym = ksymtab; nksyms > 0 ; --nksyms, ksym++) {
		if (ksym->name[0] != '#')
			continue;
		/* else */
		if (ksym->name[1] == '\0')
			break;
		/* else */
		peek_at(ksym->value, module_struct, struct module);
		peek_at(module_struct.addr, mod_use_count, int);
		printf("%s\t%d%s%s\n", ksym->name + 1,
			mod_use_count &~MOD_AUTOCLEAN,
			(module_struct.ref)?" (ref)": "",
			(mod_use_count &MOD_AUTOCLEAN)?"\tautoclean":""
			);
	}

	return 0;
}
