/*
 * Copyright (c) 2010-2011 Atheros Communications Inc.
 * Copyright (c) 2011-2012 Qualcomm Atheros Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef INITVALS_956X_H
#define INITVALS_956X_H

#define qca956x_1p0_mac_core ar955x_1p0_mac_core

#define qca956x_1p0_mac_postamble ar9331_1p1_mac_postamble

#define qca956x_1p0_soc_preamble ar955x_1p0_soc_preamble

#define qca956x_1p0_soc_postamble ar9300_2p2_soc_postamble

#define qca956x_1p0_common_wo_xlna_rx_gain_table ar9300Common_wo_xlna_rx_gain_table_2p2

#define qca956x_1p0_baseband_postamble_dfs_channel ar9300_2p2_baseband_postamble_dfs_channel

#define qca956x_1p0_common_wo_xlna_rx_gain_bounds ar955x_1p0_common_wo_xlna_rx_gain_bounds

#define qca956x_1p0_common_rx_gain_bounds ar955x_1p0_common_rx_gain_bounds

#define qca956x_1p0_modes_fast_clock ar9462_2p0_modes_fast_clock

static const u32 qca956x_1p0_baseband_core[][2] = {
	/* Addr      allmodes  */
	{0x00009800, 0xafe68e30},
	{0x00009804, 0xfd14e000},
	{0x00009808, 0x9c0a9f6b},
	{0x0000980c, 0x04900000},
	{0x00009814, 0x0280c00a},
	{0x00009818, 0x00000000},
	{0x0000981c, 0x00020028},
	{0x00009834, 0x6400a190},
	{0x00009838, 0x0108ecff},
	{0x0000983c, 0x14000600},
	{0x00009880, 0x201fff00},
	{0x00009884, 0x00001042},
	{0x000098a4, 0x00200400},
	{0x000098b0, 0x32840cbf},
	{0x000098bc, 0x00000002},
	{0x000098d0, 0x004b6a8e},
	{0x000098d4, 0x00000820},
	{0x000098dc, 0x00000000},
	{0x000098f0, 0x00000000},
	{0x000098f4, 0x00000000},
	{0x00009c04, 0xff55ff55},
	{0x00009c08, 0x0320ff55},
	{0x00009c0c, 0x00000000},
	{0x00009c10, 0x00000000},
	{0x00009c14, 0x00046384},
	{0x00009c18, 0x05b6b440},
	{0x00009c1c, 0x00b6b440},
	{0x00009d00, 0xc080a333},
	{0x00009d04, 0x40206c10},
	{0x00009d08, 0x009c4060},
	{0x00009d0c, 0x9883800a},
	{0x00009d10, 0x01834061},
	{0x00009d14, 0x00c0040b},
	{0x00009d18, 0x00000000},
	{0x00009e08, 0x0038230c},
	{0x00009e24, 0x990bb514},
	{0x00009e28, 0x0c6f0000},
	{0x00009e30, 0x06336f77},
	{0x00009e34, 0x6af6532f},
	{0x00009e38, 0x0cc80c00},
	{0x00009e40, 0x0d261820},
	{0x00009e4c, 0x00001004},
	{0x00009e50, 0x00ff03f1},
	{0x00009fc0, 0x813e4789},
	{0x00009fc4, 0x0001efb5},
	{0x00009fcc, 0x40000014},
	{0x00009fd0, 0x02993b93},
	{0x0000a20c, 0x00000000},
	{0x0000a218, 0x00000000},
	{0x0000a21c, 0x00000000},
	{0x0000a228, 0x10002310},
	{0x0000a23c, 0x00000000},
	{0x0000a244, 0x0c000000},
	{0x0000a248, 0x00000140},
	{0x0000a2a0, 0x00000007},
	{0x0000a2c0, 0x00000007},
	{0x0000a2c8, 0x00000000},
	{0x0000a2d4, 0x00000000},
	{0x0000a2ec, 0x00000000},
	{0x0000a2f0, 0x00000000},
	{0x0000a2f4, 0x00000000},
	{0x0000a2f8, 0x00000000},
	{0x0000a344, 0x00000000},
	{0x0000a34c, 0x00000000},
	{0x0000a350, 0x0000a000},
	{0x0000a360, 0x00000000},
	{0x0000a36c, 0x00000000},
	{0x0000a384, 0x00000001},
	{0x0000a388, 0x00000444},
	{0x0000a38c, 0x00000000},
	{0x0000a390, 0x210d0401},
	{0x0000a394, 0xab9a7144},
	{0x0000a398, 0x00000201},
	{0x0000a39c, 0x42424848},
	{0x0000a3a0, 0x3c466478},
	{0x0000a3a4, 0x3a363600},
	{0x0000a3a8, 0x0000003a},
	{0x0000a3ac, 0x00000000},
	{0x0000a3b0, 0x009011fe},
	{0x0000a3b4, 0x00000034},
	{0x0000a3b8, 0x00b3ec0a},
	{0x0000a3bc, 0x00000036},
	{0x0000a3c0, 0x20202020},
	{0x0000a3c4, 0x22222220},
	{0x0000a3c8, 0x20200020},
	{0x0000a3cc, 0x20202020},
	{0x0000a3d0, 0x20202020},
	{0x0000a3d4, 0x20202020},
	{0x0000a3d8, 0x20202020},
	{0x0000a3dc, 0x20202020},
	{0x0000a3e0, 0x20202020},
	{0x0000a3e4, 0x20202020},
	{0x0000a3e8, 0x20202020},
	{0x0000a3ec, 0x20202020},
	{0x0000a3f0, 0x00000000},
	{0x0000a3f4, 0x00000000},
	{0x0000a3f8, 0x0c9bd380},
	{0x0000a3fc, 0x000f0f01},
	{0x0000a400, 0x8fa91f01},
	{0x0000a404, 0x00000000},
	{0x0000a408, 0x0e79e5c6},
	{0x0000a40c, 0x00820820},
	{0x0000a414, 0x1ce739ce},
	{0x0000a418, 0x2d0019ce},
	{0x0000a41c, 0x1ce739ce},
	{0x0000a420, 0x000001ce},
	{0x0000a424, 0x1ce739ce},
	{0x0000a428, 0x000001ce},
	{0x0000a42c, 0x1ce739ce},
	{0x0000a430, 0x1ce739ce},
	{0x0000a434, 0x00000000},
	{0x0000a438, 0x00001801},
	{0x0000a43c, 0x00100000},
	{0x0000a444, 0x00000000},
	{0x0000a448, 0x05000080},
	{0x0000a44c, 0x00000001},
	{0x0000a450, 0x00010000},
	{0x0000a454, 0x05000000},
	{0x0000a458, 0x00000000},
	{0x0000a644, 0xbfad9fee},
	{0x0000a648, 0x0048660d},
	{0x0000a64c, 0x00003c37},
	{0x0000a670, 0x03020100},
	{0x0000a674, 0x21200504},
	{0x0000a678, 0x61602322},
	{0x0000a67c, 0x65646362},
	{0x0000a680, 0x6b6a6968},
	{0x0000a684, 0xe2706d6c},
	{0x0000a688, 0x000000e3},
	{0x0000a690, 0x00000838},
	{0x0000a7cc, 0x00000000},
	{0x0000a7d0, 0x00000000},
	{0x0000a7d4, 0x00000004},
	{0x0000a7dc, 0x00000000},
	{0x0000a8d0, 0x004b6a8e},
	{0x0000a8d4, 0x00000820},
	{0x0000a8dc, 0x00000000},
	{0x0000a8f0, 0x00000000},
	{0x0000a8f4, 0x00000000},
	{0x0000b2d0, 0x00000080},
	{0x0000b2d4, 0x00000000},
	{0x0000b2ec, 0x00000000},
	{0x0000b2f0, 0x00000000},
	{0x0000b2f4, 0x00000000},
	{0x0000b2f8, 0x00000000},
	{0x0000b408, 0x0e79e5c0},
	{0x0000b40c, 0x00820820},
	{0x0000b420, 0x00000000},
	{0x0000b8d0, 0x004b6a8e},
	{0x0000b8d4, 0x00000820},
	{0x0000b8dc, 0x00000000},
	{0x0000b8f0, 0x00000000},
	{0x0000b8f4, 0x00000000},
	{0x0000c2d0, 0x00000080},
	{0x0000c2d4, 0x00000000},
	{0x0000c2ec, 0x00000000},
	{0x0000c2f0, 0x00000000},
	{0x0000c2f4, 0x00000000},
	{0x0000c2f8, 0x00000000},
	{0x0000c408, 0x0e79e5c0},
	{0x0000c40c, 0x00820820},
	{0x0000c420, 0x00000000},
};

static const u32 qca956x_1p0_baseband_postamble[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00009810, 0xd00a8005, 0xd00a8005, 0xd00a8011, 0xd00a8011},
	{0x00009820, 0x206a022e, 0x206a022e, 0x206a01ae, 0x206a01ae},
	{0x00009824, 0x5ac640d0, 0x5ac640d0, 0x5ac621f1, 0x5ac621f1},
	{0x00009828, 0x06903081, 0x06903081, 0x07d43881, 0x07d43881},
	{0x0000982c, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4},
	{0x00009830, 0x0000059c, 0x0000059c, 0x0000119c, 0x0000119c},
	{0x00009c00, 0x000000c4, 0x000000c4, 0x000000c4, 0x000000c4},
	{0x00009e00, 0x0372111a, 0x0372111a, 0x037216a0, 0x037216a0},
	{0x00009e04, 0x001c2020, 0x001c2020, 0x001c2020, 0x001c2020},
	{0x00009e0c, 0x6c4000e2, 0x6d4000e2, 0x6d4000de, 0x6c4000de},
	{0x00009e10, 0x7ec88d2e, 0x7ec88d2e, 0x7ec84d2e, 0x7ec86d2e},
	{0x00009e14, 0x37b95d5e, 0x37b9605e, 0x337d605e, 0x337d5d5e},
	{0x00009e18, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00009e1c, 0x0001cf9c, 0x0001cf9c, 0x00021f9c, 0x00021f9c},
	{0x00009e20, 0x000003b5, 0x000003b5, 0x000003a6, 0x000003a6},
	{0x00009e2c, 0x0000001c, 0x0000001c, 0x00000021, 0x00000021},
	{0x00009e3c, 0xcfa10820, 0xcfa10820, 0xcf946220, 0xcf946220},
	{0x00009e44, 0xfe321e27, 0xfe321e27, 0xfe291e27, 0xfe291e27},
	{0x00009e48, 0x5030201a, 0x5030201a, 0x50302012, 0x50302012},
	{0x00009fc8, 0x0003f000, 0x0003f000, 0x0001a000, 0x0001a000},
	{0x0000a204, 0x005c0ec0, 0x005c0ec4, 0x045c0cc4, 0x045c0cc0},
	{0x0000a208, 0x00000104, 0x00000104, 0x00000004, 0x00000004},
	{0x0000a22c, 0x07e26a2f, 0x07e26a2f, 0x01026a2f, 0x01026a2f},
	{0x0000a230, 0x0000400a, 0x00004014, 0x00004016, 0x0000400b},
	{0x0000a234, 0x00000fff, 0x10000fff, 0x10000fff, 0x00000fff},
	{0x0000a238, 0xffb01018, 0xffb01018, 0xffb01018, 0xffb01018},
	{0x0000a250, 0x00000000, 0x00000000, 0x00000210, 0x00000108},
	{0x0000a254, 0x000007d0, 0x00000fa0, 0x00001130, 0x00000898},
	{0x0000a258, 0x02020002, 0x02020002, 0x02020002, 0x02020002},
	{0x0000a25c, 0x01000e0e, 0x01000e0e, 0x01010e0e, 0x01010e0e},
	{0x0000a260, 0x0a021501, 0x0a021501, 0x3a021501, 0x3a021501},
	{0x0000a264, 0x00000e0e, 0x00000e0e, 0x01000e0e, 0x01000e0e},
	{0x0000a280, 0x00000007, 0x00000007, 0x0000000b, 0x0000000b},
	{0x0000a284, 0x00000000, 0x00000000, 0x00000010, 0x00000010},
	{0x0000a288, 0x00000110, 0x00000110, 0x00000110, 0x00000110},
	{0x0000a28c, 0x00022222, 0x00022222, 0x00022222, 0x00022222},
	{0x0000a2c4, 0x00058d18, 0x00058d18, 0x00058d18, 0x00058d18},
	{0x0000a2cc, 0x18c50033, 0x18c43433, 0x18c41033, 0x18c44c33},
	{0x0000a2d0, 0x00041982, 0x00041982, 0x00041982, 0x00041982},
	{0x0000a2d8, 0x7999a83b, 0x7999a83b, 0x7999a83b, 0x7999a83b},
	{0x0000a358, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a830, 0x0000019c, 0x0000019c, 0x0000019c, 0x0000019c},
	{0x0000ae04, 0x001c0000, 0x001c0000, 0x001c0000, 0x001c0000},
	{0x0000ae18, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000ae1c, 0x0000019c, 0x0000019c, 0x0000019c, 0x0000019c},
	{0x0000ae20, 0x000001b5, 0x000001b5, 0x000001a6, 0x000001a6},
	{0x0000b284, 0x00000000, 0x00000000, 0x00000010, 0x00000010},
	{0x0000b830, 0x0000019c, 0x0000019c, 0x0000019c, 0x0000019c},
	{0x0000be04, 0x001c0000, 0x001c0000, 0x001c0000, 0x001c0000},
	{0x0000be18, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000be1c, 0x0000019c, 0x0000019c, 0x0000019c, 0x0000019c},
	{0x0000be20, 0x000001b5, 0x000001b5, 0x000001a6, 0x000001a6},
	{0x0000c284, 0x00000000, 0x00000000, 0x00000010, 0x00000010},
};

static const u32 qca956x_1p0_radio_core[][2] = {
	/* Addr      allmodes  */
	{0x00016000, 0x36db6db6},
	{0x00016004, 0x6db6db40},
	{0x00016008, 0x73f00000},
	{0x0001600c, 0x00000000},
	{0x00016040, 0x3f80fff8},
	{0x0001604c, 0x000f0278},
	{0x00016050, 0x8036db6c},
	{0x00016054, 0x6db60000},
	{0x00016080, 0x00080000},
	{0x00016084, 0x0e48048c},
	{0x00016088, 0x14214514},
	{0x0001608c, 0x119f080a},
	{0x00016090, 0x24926490},
	{0x00016094, 0x00000000},
	{0x000160a0, 0xc2108ffe},
	{0x000160a4, 0x812fc370},
	{0x000160a8, 0x423c8000},
	{0x000160b4, 0x92480000},
	{0x000160c0, 0x006db6d8},
	{0x000160c4, 0x24b6db6c},
	{0x000160c8, 0x6db6db6c},
	{0x000160cc, 0x6db6fb7c},
	{0x000160d0, 0x6db6da44},
	{0x00016100, 0x07ff8001},
	{0x00016108, 0x00080010},
	{0x00016144, 0x01884080},
	{0x00016148, 0x00008058},
	{0x00016288, 0x001c6000},
	{0x0001628c, 0x50000000},
	{0x000162c0, 0x4b962100},
	{0x000162c4, 0x00000480},
	{0x000162c8, 0x04000144},
	{0x00016380, 0x00000000},
	{0x00016384, 0x00000000},
	{0x00016388, 0x00800700},
	{0x0001638c, 0x00800700},
	{0x00016390, 0x00800700},
	{0x00016394, 0x00000000},
	{0x00016398, 0x00000000},
	{0x0001639c, 0x00000000},
	{0x000163a0, 0x00000001},
	{0x000163a4, 0x00000001},
	{0x000163a8, 0x00000000},
	{0x000163ac, 0x00000000},
	{0x000163b0, 0x00000000},
	{0x000163b4, 0x00000000},
	{0x000163b8, 0x00000000},
	{0x000163bc, 0x00000000},
	{0x000163c0, 0x000000a0},
	{0x000163c4, 0x000c0000},
	{0x000163c8, 0x14021402},
	{0x000163cc, 0x00001402},
	{0x000163d0, 0x00000000},
	{0x000163d4, 0x00000000},
	{0x00016400, 0x36db6db6},
	{0x00016404, 0x6db6db40},
	{0x00016408, 0x73f00000},
	{0x0001640c, 0x00000000},
	{0x00016440, 0x3f80fff8},
	{0x0001644c, 0x000f0278},
	{0x00016450, 0x8036db6c},
	{0x00016454, 0x6db60000},
	{0x00016500, 0x07ff8001},
	{0x00016508, 0x00080010},
	{0x00016544, 0x01884080},
	{0x00016548, 0x00008058},
	{0x00016780, 0x00000000},
	{0x00016784, 0x00000000},
	{0x00016788, 0x00800700},
	{0x0001678c, 0x00800700},
	{0x00016790, 0x00800700},
	{0x00016794, 0x00000000},
	{0x00016798, 0x00000000},
	{0x0001679c, 0x00000000},
	{0x000167a0, 0x00000001},
	{0x000167a4, 0x00000001},
	{0x000167a8, 0x00000000},
	{0x000167ac, 0x00000000},
	{0x000167b0, 0x00000000},
	{0x000167b4, 0x00000000},
	{0x000167b8, 0x00000000},
	{0x000167bc, 0x00000000},
	{0x000167c0, 0x000000a0},
	{0x000167c4, 0x000c0000},
	{0x000167c8, 0x14021402},
	{0x000167cc, 0x00001402},
	{0x000167d0, 0x00000000},
	{0x000167d4, 0x00000000},
	{0x00016800, 0x36db6db6},
	{0x00016804, 0x6db6db40},
	{0x00016808, 0x73f00000},
	{0x0001680c, 0x00000000},
	{0x00016840, 0x3f80fff8},
	{0x0001684c, 0x000f0278},
	{0x00016850, 0x8036db6c},
	{0x00016854, 0x6db60000},
	{0x00016900, 0x07ff8001},
	{0x00016908, 0x00080010},
	{0x00016944, 0x01884080},
	{0x00016948, 0x00008058},
	{0x00016b80, 0x00000000},
	{0x00016b84, 0x00000000},
	{0x00016b88, 0x00800700},
	{0x00016b8c, 0x00800700},
	{0x00016b90, 0x00800700},
	{0x00016b94, 0x00000000},
	{0x00016b98, 0x00000000},
	{0x00016b9c, 0x00000000},
	{0x00016ba0, 0x00000001},
	{0x00016ba4, 0x00000001},
	{0x00016ba8, 0x00000000},
	{0x00016bac, 0x00000000},
	{0x00016bb0, 0x00000000},
	{0x00016bb4, 0x00000000},
	{0x00016bb8, 0x00000000},
	{0x00016bbc, 0x00000000},
	{0x00016bc0, 0x000000a0},
	{0x00016bc4, 0x000c0000},
	{0x00016bc8, 0x14021402},
	{0x00016bcc, 0x00001402},
	{0x00016bd0, 0x00000000},
	{0x00016bd4, 0x00000000},
};

static const u32 qca956x_1p0_radio_postamble[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00016098, 0xd2dd5554, 0xd2dd5554, 0xc4128f5c, 0xc4128f5c},
	{0x0001609c, 0x0a566f3a, 0x0a566f3a, 0x0fd08f25, 0x0fd08f25},
	{0x000160ac, 0xa4647c00, 0xa4647c00, 0x24646800, 0x24646800},
	{0x000160b0, 0x01885f52, 0x01885f52, 0x00fe7f46, 0x00fe7f46},
	{0x00016104, 0xb7a00000, 0xb7a00000, 0xfff80001, 0xfff80001},
	{0x0001610c, 0xc0000000, 0xc0000000, 0x00000000, 0x00000000},
	{0x00016140, 0x10804008, 0x10804008, 0x50804000, 0x50804000},
	{0x00016504, 0xb7a00000, 0xb7a00000, 0xfff80001, 0xfff80001},
	{0x0001650c, 0xc0000000, 0xc0000000, 0x00000000, 0x00000000},
	{0x00016540, 0x10804008, 0x10804008, 0x50804000, 0x50804000},
	{0x00016904, 0xb7a00000, 0xb7a00000, 0xfff80001, 0xfff80001},
	{0x0001690c, 0xc0000000, 0xc0000000, 0x00000000, 0x00000000},
	{0x00016940, 0x10804008, 0x10804008, 0x50804000, 0x50804000},
};

static const u32 qca956x_1p0_baseband_core_txfir_coeff_japan_2484[][2] = {
	/* Addr      allmodes  */
	{0x0000a38c, 0x00000000},
	{0x0000a390, 0x6f7f0301},
	{0x0000a394, 0xca9228ee},
};

static const u32 qca956x_1p0_modes_no_xpa_tx_gain_table[][3] = {
	/* Addr      5G          2G        */
	{0x0000a2dc, 0xffa9ac94, 0xffa9ac94},
	{0x0000a2e0, 0xff323118, 0xff323118},
	{0x0000a2e4, 0xff3ffe00, 0xff3ffe00},
	{0x0000a2e8, 0xffc00000, 0xffc00000},
	{0x0000a39c, 0x42424242, 0x42424242},
	{0x0000a3a4, 0x3a3e3e00, 0x3a3e3e00},
	{0x0000a3b0, 0x00a01404, 0x00a01404},
	{0x0000a3b4, 0x00000034, 0x00000034},
	{0x0000a3b8, 0x00800408, 0x00800408},
	{0x0000a3bc, 0x00000036, 0x00000036},
	{0x0000a410, 0x000050dc, 0x000050dc},
	{0x0000a500, 0x09000040, 0x09000040},
	{0x0000a504, 0x0b000041, 0x0b000041},
	{0x0000a508, 0x0d000042, 0x0d000042},
	{0x0000a50c, 0x11000044, 0x11000044},
	{0x0000a510, 0x15000046, 0x15000046},
	{0x0000a514, 0x1d000440, 0x1d000440},
	{0x0000a518, 0x1f000441, 0x1f000441},
	{0x0000a51c, 0x23000443, 0x23000443},
	{0x0000a520, 0x25000444, 0x25000444},
	{0x0000a524, 0x280004e0, 0x280004e0},
	{0x0000a528, 0x2c0004e2, 0x2c0004e2},
	{0x0000a52c, 0x2e0004e3, 0x2e0004e3},
	{0x0000a530, 0x300004e4, 0x300004e4},
	{0x0000a534, 0x340004e6, 0x340004e6},
	{0x0000a538, 0x37000ce0, 0x37000ce0},
	{0x0000a53c, 0x3b000ce2, 0x3b000ce2},
	{0x0000a540, 0x3d000ce3, 0x3d000ce3},
	{0x0000a544, 0x3f000ce4, 0x3f000ce4},
	{0x0000a548, 0x45001ee0, 0x45001ee0},
	{0x0000a54c, 0x49001ee2, 0x49001ee2},
	{0x0000a550, 0x4d001ee4, 0x4d001ee4},
	{0x0000a554, 0x51001ee6, 0x51001ee6},
	{0x0000a558, 0x55001eea, 0x55001eea},
	{0x0000a55c, 0x59001eec, 0x59001eec},
	{0x0000a560, 0x5d001ef0, 0x5d001ef0},
	{0x0000a564, 0x5f001ef1, 0x5f001ef1},
	{0x0000a568, 0x60001ef2, 0x60001ef2},
	{0x0000a56c, 0x61001ef3, 0x61001ef3},
	{0x0000a570, 0x62001ef4, 0x62001ef4},
	{0x0000a574, 0x63001ef5, 0x63001ef5},
	{0x0000a578, 0x64001ffc, 0x64001ffc},
	{0x0000a57c, 0x64001ffc, 0x64001ffc},
	{0x0000a600, 0x00000000, 0x00000000},
	{0x0000a604, 0x00000000, 0x00000000},
	{0x0000a608, 0x00000000, 0x00000000},
	{0x0000a60c, 0x00000000, 0x00000000},
	{0x0000a610, 0x00804000, 0x00804000},
	{0x0000a614, 0x00804201, 0x00804201},
	{0x0000a618, 0x00804201, 0x00804201},
	{0x0000a61c, 0x00804201, 0x00804201},
	{0x0000a620, 0x00804201, 0x00804201},
	{0x0000a624, 0x00804201, 0x00804201},
	{0x0000a628, 0x00804201, 0x00804201},
	{0x0000a62c, 0x02808a02, 0x02808a02},
	{0x0000a630, 0x0340cd03, 0x0340cd03},
	{0x0000a634, 0x0340cd03, 0x0340cd03},
	{0x0000a638, 0x0340cd03, 0x0340cd03},
	{0x0000a63c, 0x05011404, 0x05011404},
	{0x0000b2dc, 0xffa9ac94, 0xffa9ac94},
	{0x0000b2e0, 0xff323118, 0xff323118},
	{0x0000b2e4, 0xff3ffe00, 0xff3ffe00},
	{0x0000b2e8, 0xffc00000, 0xffc00000},
	{0x0000c2dc, 0xffa9ac94, 0xffa9ac94},
	{0x0000c2e0, 0xff323118, 0xff323118},
	{0x0000c2e4, 0xff3ffe00, 0xff3ffe00},
	{0x0000c2e8, 0xffc00000, 0xffc00000},
	{0x00016044, 0x049242db, 0x049242db},
	{0x00016048, 0x64925a70, 0x64925a70},
	{0x00016148, 0x00008050, 0x00008050},
	{0x00016280, 0x41110005, 0x41110005},
	{0x00016284, 0x453a6000, 0x453a6000},
	{0x00016444, 0x049242db, 0x049242db},
	{0x00016448, 0x6c925a70, 0x6c925a70},
	{0x00016548, 0x00008050, 0x00008050},
	{0x00016844, 0x049242db, 0x049242db},
	{0x00016848, 0x6c925a70, 0x6c925a70},
	{0x00016948, 0x00008050, 0x00008050},
};

static const u32 qca956x_1p0_modes_xpa_tx_gain_table[][3] = {
	/* Addr      5G          2G        */
	{0x0000a2dc, 0xcc69ac94, 0xcc69ac94},
	{0x0000a2e0, 0xf0b23118, 0xf0b23118},
	{0x0000a2e4, 0xffffc000, 0xffffc000},
	{0x0000a2e8, 0xc0000000, 0xc0000000},
	{0x0000a410, 0x000050d2, 0x000050d2},
	{0x0000a500, 0x0a000040, 0x0a000040},
	{0x0000a504, 0x0c000041, 0x0c000041},
	{0x0000a508, 0x0e000042, 0x0e000042},
	{0x0000a50c, 0x12000044, 0x12000044},
	{0x0000a510, 0x16000046, 0x16000046},
	{0x0000a514, 0x1d000440, 0x1d000440},
	{0x0000a518, 0x1f000441, 0x1f000441},
	{0x0000a51c, 0x23000443, 0x23000443},
	{0x0000a520, 0x25000444, 0x25000444},
	{0x0000a524, 0x29000a40, 0x29000a40},
	{0x0000a528, 0x2d000a42, 0x2d000a42},
	{0x0000a52c, 0x2f000a43, 0x2f000a43},
	{0x0000a530, 0x31000a44, 0x31000a44},
	{0x0000a534, 0x35000a46, 0x35000a46},
	{0x0000a538, 0x38000ce0, 0x38000ce0},
	{0x0000a53c, 0x3c000ce2, 0x3c000ce2},
	{0x0000a540, 0x3e000ce3, 0x3e000ce3},
	{0x0000a544, 0x40000ce4, 0x40000ce4},
	{0x0000a548, 0x46001ee0, 0x46001ee0},
	{0x0000a54c, 0x4a001ee2, 0x4a001ee2},
	{0x0000a550, 0x4e001ee4, 0x4e001ee4},
	{0x0000a554, 0x52001ee6, 0x52001ee6},
	{0x0000a558, 0x56001eea, 0x56001eea},
	{0x0000a55c, 0x5a001eec, 0x5a001eec},
	{0x0000a560, 0x5e001ef0, 0x5e001ef0},
	{0x0000a564, 0x60001ef1, 0x60001ef1},
	{0x0000a568, 0x61001ef2, 0x61001ef2},
	{0x0000a56c, 0x62001ef3, 0x62001ef3},
	{0x0000a570, 0x63001ef4, 0x63001ef4},
	{0x0000a574, 0x64001ef5, 0x64001ef5},
	{0x0000a578, 0x65001ffc, 0x65001ffc},
	{0x0000a57c, 0x65001ffc, 0x65001ffc},
	{0x0000a600, 0x00000000, 0x00000000},
	{0x0000a604, 0x00000000, 0x00000000},
	{0x0000a608, 0x00000000, 0x00000000},
	{0x0000a60c, 0x00000000, 0x00000000},
	{0x0000a610, 0x00000000, 0x00000000},
	{0x0000a614, 0x00000000, 0x00000000},
	{0x0000a618, 0x00000000, 0x00000000},
	{0x0000a61c, 0x00804201, 0x00804201},
	{0x0000a620, 0x00804201, 0x00804201},
	{0x0000a624, 0x00804201, 0x00804201},
	{0x0000a628, 0x00804201, 0x00804201},
	{0x0000a62c, 0x02808a02, 0x02808a02},
	{0x0000a630, 0x0340cd03, 0x0340cd03},
	{0x0000a634, 0x0340cd03, 0x0340cd03},
	{0x0000a638, 0x0340cd03, 0x0340cd03},
	{0x0000a63c, 0x05011404, 0x05011404},
	{0x0000b2dc, 0xcc69ac94, 0xcc69ac94},
	{0x0000b2e0, 0xf0b23118, 0xf0b23118},
	{0x0000b2e4, 0xffffc000, 0xffffc000},
	{0x0000b2e8, 0xc0000000, 0xc0000000},
	{0x0000c2dc, 0xcc69ac94, 0xcc69ac94},
	{0x0000c2e0, 0xf0b23118, 0xf0b23118},
	{0x0000c2e4, 0xffffc000, 0xffffc000},
	{0x0000c2e8, 0xc0000000, 0xc0000000},
	{0x00016044, 0x012492db, 0x012492db},
	{0x00016048, 0x6c927a70, 0x6c927a70},
	{0x00016050, 0x8036d36c, 0x8036d36c},
	{0x00016280, 0x41110005, 0x41110005},
	{0x00016284, 0x453a7e00, 0x453a7e00},
	{0x00016444, 0x012492db, 0x012492db},
	{0x00016448, 0x6c927a70, 0x6c927a70},
	{0x00016450, 0x8036d36c, 0x8036d36c},
	{0x00016844, 0x012492db, 0x012492db},
	{0x00016848, 0x6c927a70, 0x6c927a70},
	{0x00016850, 0x8036d36c, 0x8036d36c},
};

static const u32 qca956x_1p0_modes_no_xpa_low_ob_db_tx_gain_table[][3] = {
	/* Addr      5G          2G        */
	{0x0000a2dc, 0xffa9ac94, 0xffa9ac94},
	{0x0000a2e0, 0xff323118, 0xff323118},
	{0x0000a2e4, 0xff3ffe00, 0xff3ffe00},
	{0x0000a2e8, 0xffc00000, 0xffc00000},
	{0x0000a39c, 0x42424242, 0x42424242},
	{0x0000a3a4, 0x3a3e3e00, 0x3a3e3e00},
	{0x0000a3b0, 0x00a01404, 0x00a01404},
	{0x0000a3b4, 0x00000034, 0x00000034},
	{0x0000a3b8, 0x00800408, 0x00800408},
	{0x0000a3bc, 0x00000036, 0x00000036},
	{0x0000a410, 0x000050dc, 0x000050dc},
	{0x0000a414, 0x16b739ce, 0x16b739ce},
	{0x0000a418, 0x2d00198b, 0x2d00198b},
	{0x0000a41c, 0x16b5adce, 0x16b5adce},
	{0x0000a420, 0x0000014a, 0x0000014a},
	{0x0000a424, 0x14a525cc, 0x14a525cc},
	{0x0000a428, 0x0000012a, 0x0000012a},
	{0x0000a42c, 0x14a5294a, 0x14a5294a},
	{0x0000a430, 0x1294a929, 0x1294a929},
	{0x0000a500, 0x09000040, 0x09000040},
	{0x0000a504, 0x0b000041, 0x0b000041},
	{0x0000a508, 0x0d000042, 0x0d000042},
	{0x0000a50c, 0x11000044, 0x11000044},
	{0x0000a510, 0x15000046, 0x15000046},
	{0x0000a514, 0x1d000440, 0x1d000440},
	{0x0000a518, 0x1f000441, 0x1f000441},
	{0x0000a51c, 0x23000443, 0x23000443},
	{0x0000a520, 0x25000444, 0x25000444},
	{0x0000a524, 0x280004e0, 0x280004e0},
	{0x0000a528, 0x2c0004e2, 0x2c0004e2},
	{0x0000a52c, 0x2e0004e3, 0x2e0004e3},
	{0x0000a530, 0x300004e4, 0x300004e4},
	{0x0000a534, 0x340004e6, 0x340004e6},
	{0x0000a538, 0x37000ce0, 0x37000ce0},
	{0x0000a53c, 0x3b000ce2, 0x3b000ce2},
	{0x0000a540, 0x3d000ce3, 0x3d000ce3},
	{0x0000a544, 0x3f000ce4, 0x3f000ce4},
	{0x0000a548, 0x45001ee0, 0x45001ee0},
	{0x0000a54c, 0x49001ee2, 0x49001ee2},
	{0x0000a550, 0x4d001ee4, 0x4d001ee4},
	{0x0000a554, 0x51001ee6, 0x51001ee6},
	{0x0000a558, 0x55001eea, 0x55001eea},
	{0x0000a55c, 0x59001eec, 0x59001eec},
	{0x0000a560, 0x5d001ef0, 0x5d001ef0},
	{0x0000a564, 0x5f001ef1, 0x5f001ef1},
	{0x0000a568, 0x60001ef2, 0x60001ef2},
	{0x0000a56c, 0x61001ef3, 0x61001ef3},
	{0x0000a570, 0x62001ef4, 0x62001ef4},
	{0x0000a574, 0x63001ef5, 0x63001ef5},
	{0x0000a578, 0x64001ffc, 0x64001ffc},
	{0x0000a57c, 0x64001ffc, 0x64001ffc},
	{0x0000a600, 0x00000000, 0x00000000},
	{0x0000a604, 0x00000000, 0x00000000},
	{0x0000a608, 0x00000000, 0x00000000},
	{0x0000a60c, 0x00000000, 0x00000000},
	{0x0000a610, 0x00804000, 0x00804000},
	{0x0000a614, 0x00804201, 0x00804201},
	{0x0000a618, 0x00804201, 0x00804201},
	{0x0000a61c, 0x00804201, 0x00804201},
	{0x0000a620, 0x00804201, 0x00804201},
	{0x0000a624, 0x00804201, 0x00804201},
	{0x0000a628, 0x00804201, 0x00804201},
	{0x0000a62c, 0x02808a02, 0x02808a02},
	{0x0000a630, 0x0340cd03, 0x0340cd03},
	{0x0000a634, 0x0340cd03, 0x0340cd03},
	{0x0000a638, 0x0340cd03, 0x0340cd03},
	{0x0000a63c, 0x05011404, 0x05011404},
	{0x0000b2dc, 0xffa9ac94, 0xffa9ac94},
	{0x0000b2e0, 0xff323118, 0xff323118},
	{0x0000b2e4, 0xff3ffe00, 0xff3ffe00},
	{0x0000b2e8, 0xffc00000, 0xffc00000},
	{0x0000c2dc, 0xffa9ac94, 0xffa9ac94},
	{0x0000c2e0, 0xff323118, 0xff323118},
	{0x0000c2e4, 0xff3ffe00, 0xff3ffe00},
	{0x0000c2e8, 0xffc00000, 0xffc00000},
	{0x00016044, 0x046e42db, 0x046e42db},
	{0x00016048, 0x64925a70, 0x64925a70},
	{0x00016148, 0x00008050, 0x00008050},
	{0x00016280, 0x41110005, 0x41110005},
	{0x00016284, 0x453a6000, 0x453a6000},
	{0x00016444, 0x046e42db, 0x046e42db},
	{0x00016448, 0x6c925a70, 0x6c925a70},
	{0x00016548, 0x00008050, 0x00008050},
	{0x00016844, 0x046e42db, 0x046e42db},
	{0x00016848, 0x6c925a70, 0x6c925a70},
	{0x00016948, 0x00008050, 0x00008050},
};

static const u32 qca956x_1p0_modes_no_xpa_green_tx_gain_table[][3] = {
	/* Addr      5G          2G        */
	{0x000098bc, 0x00000001, 0x00000001},
	{0x0000a2dc, 0xd3555284, 0xd3555284},
	{0x0000a2e0, 0x1c666318, 0x1c666318},
	{0x0000a2e4, 0xe07bbc00, 0xe07bbc00},
	{0x0000a2e8, 0xff800000, 0xff800000},
	{0x0000a3a4, 0x3a3e3e00, 0x3a3e3e00},
	{0x0000a410, 0x000050dc, 0x000050dc},
	{0x0000a500, 0x02000040, 0x02000040},
	{0x0000a504, 0x04000041, 0x04000041},
	{0x0000a508, 0x06000042, 0x06000042},
	{0x0000a50c, 0x0a000044, 0x0a000044},
	{0x0000a510, 0x0c000045, 0x0c000045},
	{0x0000a514, 0x13000440, 0x13000440},
	{0x0000a518, 0x15000441, 0x15000441},
	{0x0000a51c, 0x19000443, 0x19000443},
	{0x0000a520, 0x1b000444, 0x1b000444},
	{0x0000a524, 0x1e0004e0, 0x1e0004e0},
	{0x0000a528, 0x220004e2, 0x220004e2},
	{0x0000a52c, 0x240004e3, 0x240004e3},
	{0x0000a530, 0x260004e4, 0x260004e4},
	{0x0000a534, 0x2a0004e6, 0x2a0004e6},
	{0x0000a538, 0x32000ce0, 0x32000ce0},
	{0x0000a53c, 0x36000ce2, 0x36000ce2},
	{0x0000a540, 0x3a000ce4, 0x3a000ce4},
	{0x0000a544, 0x3e000ce6, 0x3e000ce6},
	{0x0000a548, 0x45001ee0, 0x45001ee0},
	{0x0000a54c, 0x49001ee2, 0x49001ee2},
	{0x0000a550, 0x4d001ee4, 0x4d001ee4},
	{0x0000a554, 0x51001ee6, 0x51001ee6},
	{0x0000a558, 0x55001eea, 0x55001eea},
	{0x0000a55c, 0x59001eec, 0x59001eec},
	{0x0000a560, 0x5d001ef0, 0x5d001ef0},
	{0x0000a564, 0x5f001ef1, 0x5f001ef1},
	{0x0000a568, 0x60001ef2, 0x60001ef2},
	{0x0000a56c, 0x61001ef3, 0x61001ef3},
	{0x0000a570, 0x62001ef4, 0x62001ef4},
	{0x0000a574, 0x63001ff5, 0x63001ff5},
	{0x0000a578, 0x64001ffc, 0x64001ffc},
	{0x0000a57c, 0x64001ffc, 0x64001ffc},
	{0x0000a600, 0x00000000, 0x00000000},
	{0x0000a604, 0x00000000, 0x00000000},
	{0x0000a608, 0x00000000, 0x00000000},
	{0x0000a60c, 0x00000000, 0x00000000},
	{0x0000a610, 0x00804000, 0x00804000},
	{0x0000a614, 0x00804201, 0x00804201},
	{0x0000a618, 0x00804201, 0x00804201},
	{0x0000a61c, 0x00804201, 0x00804201},
	{0x0000a620, 0x00804201, 0x00804201},
	{0x0000a624, 0x00804201, 0x00804201},
	{0x0000a628, 0x00804201, 0x00804201},
	{0x0000a62c, 0x02808a02, 0x02808a02},
	{0x0000a630, 0x0340cd03, 0x0340cd03},
	{0x0000a634, 0x0340cd03, 0x0340cd03},
	{0x0000a638, 0x0340cd03, 0x0340cd03},
	{0x0000a63c, 0x05011404, 0x05011404},
	{0x0000b2dc, 0xd3555284, 0xd3555284},
	{0x0000b2e0, 0x1c666318, 0x1c666318},
	{0x0000b2e4, 0xe07bbc00, 0xe07bbc00},
	{0x0000b2e8, 0xff800000, 0xff800000},
	{0x0000c2dc, 0xd3555284, 0xd3555284},
	{0x0000c2e0, 0x1c666318, 0x1c666318},
	{0x0000c2e4, 0xe07bbc00, 0xe07bbc00},
	{0x0000c2e8, 0xff800000, 0xff800000},
	{0x00016044, 0x849242db, 0x849242db},
	{0x00016048, 0x64925a70, 0x64925a70},
	{0x00016280, 0x41110005, 0x41110005},
	{0x00016284, 0x453a6000, 0x453a6000},
	{0x00016444, 0x849242db, 0x849242db},
	{0x00016448, 0x6c925a70, 0x6c925a70},
	{0x00016844, 0x849242db, 0x849242db},
	{0x00016848, 0x6c925a70, 0x6c925a70},
	{0x0000a7f0, 0x800002cc, 0x800002cc},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000018, 0x00000018},
	{0x0000a7f4, 0x00000028, 0x00000028},
	{0x0000a7f4, 0x00000028, 0x00000028},
	{0x0000a7f4, 0x00000028, 0x00000028},
	{0x0000a7f4, 0x00000028, 0x00000028},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
	{0x0000a7f4, 0x00000048, 0x00000048},
};

static const u32 qca956x_1p0_common_rx_gain_table[][2] = {
	/* Addr      allmodes  */
	{0x0000a000, 0x00010000},
	{0x0000a004, 0x00030002},
	{0x0000a008, 0x00050004},
	{0x0000a00c, 0x00810080},
	{0x0000a010, 0x00830082},
	{0x0000a014, 0x01810180},
	{0x0000a018, 0x01830182},
	{0x0000a01c, 0x01850184},
	{0x0000a020, 0x01890188},
	{0x0000a024, 0x018b018a},
	{0x0000a028, 0x018d018c},
	{0x0000a02c, 0x01910190},
	{0x0000a030, 0x01930192},
	{0x0000a034, 0x01950194},
	{0x0000a038, 0x038a0196},
	{0x0000a03c, 0x038c038b},
	{0x0000a040, 0x0390038d},
	{0x0000a044, 0x03920391},
	{0x0000a048, 0x03940393},
	{0x0000a04c, 0x03960395},
	{0x0000a050, 0x00000000},
	{0x0000a054, 0x00000000},
	{0x0000a058, 0x00000000},
	{0x0000a05c, 0x00000000},
	{0x0000a060, 0x00000000},
	{0x0000a064, 0x00000000},
	{0x0000a068, 0x00000000},
	{0x0000a06c, 0x00000000},
	{0x0000a070, 0x00000000},
	{0x0000a074, 0x00000000},
	{0x0000a078, 0x00000000},
	{0x0000a07c, 0x00000000},
	{0x0000a080, 0x22222222},
	{0x0000a084, 0x1d1d1d1d},
	{0x0000a088, 0x1d1d1d1d},
	{0x0000a08c, 0x1d1d1d1d},
	{0x0000a090, 0x17171717},
	{0x0000a094, 0x11111717},
	{0x0000a098, 0x00030311},
	{0x0000a09c, 0x00000000},
	{0x0000a0a0, 0x00000000},
	{0x0000a0a4, 0x00000000},
	{0x0000a0a8, 0x00000000},
	{0x0000a0ac, 0x00000000},
	{0x0000a0b0, 0x00000000},
	{0x0000a0b4, 0x00000000},
	{0x0000a0b8, 0x00000000},
	{0x0000a0bc, 0x00000000},
	{0x0000a0c0, 0x001f0000},
	{0x0000a0c4, 0x01000101},
	{0x0000a0c8, 0x011e011f},
	{0x0000a0cc, 0x011c011d},
	{0x0000a0d0, 0x02030204},
	{0x0000a0d4, 0x02010202},
	{0x0000a0d8, 0x021f0200},
	{0x0000a0dc, 0x0302021e},
	{0x0000a0e0, 0x03000301},
	{0x0000a0e4, 0x031e031f},
	{0x0000a0e8, 0x0402031d},
	{0x0000a0ec, 0x04000401},
	{0x0000a0f0, 0x041e041f},
	{0x0000a0f4, 0x0502041d},
	{0x0000a0f8, 0x05000501},
	{0x0000a0fc, 0x051e051f},
	{0x0000a100, 0x06010602},
	{0x0000a104, 0x061f0600},
	{0x0000a108, 0x061d061e},
	{0x0000a10c, 0x07020703},
	{0x0000a110, 0x07000701},
	{0x0000a114, 0x00000000},
	{0x0000a118, 0x00000000},
	{0x0000a11c, 0x00000000},
	{0x0000a120, 0x00000000},
	{0x0000a124, 0x00000000},
	{0x0000a128, 0x00000000},
	{0x0000a12c, 0x00000000},
	{0x0000a130, 0x00000000},
	{0x0000a134, 0x00000000},
	{0x0000a138, 0x00000000},
	{0x0000a13c, 0x00000000},
	{0x0000a140, 0x001f0000},
	{0x0000a144, 0x01000101},
	{0x0000a148, 0x011e011f},
	{0x0000a14c, 0x011c011d},
	{0x0000a150, 0x02030204},
	{0x0000a154, 0x02010202},
	{0x0000a158, 0x021f0200},
	{0x0000a15c, 0x0302021e},
	{0x0000a160, 0x03000301},
	{0x0000a164, 0x031e031f},
	{0x0000a168, 0x0402031d},
	{0x0000a16c, 0x04000401},
	{0x0000a170, 0x041e041f},
	{0x0000a174, 0x0502041d},
	{0x0000a178, 0x05000501},
	{0x0000a17c, 0x051e051f},
	{0x0000a180, 0x06010602},
	{0x0000a184, 0x061f0600},
	{0x0000a188, 0x061d061e},
	{0x0000a18c, 0x07020703},
	{0x0000a190, 0x07000701},
	{0x0000a194, 0x00000000},
	{0x0000a198, 0x00000000},
	{0x0000a19c, 0x00000000},
	{0x0000a1a0, 0x00000000},
	{0x0000a1a4, 0x00000000},
	{0x0000a1a8, 0x00000000},
	{0x0000a1ac, 0x00000000},
	{0x0000a1b0, 0x00000000},
	{0x0000a1b4, 0x00000000},
	{0x0000a1b8, 0x00000000},
	{0x0000a1bc, 0x00000000},
	{0x0000a1c0, 0x00000000},
	{0x0000a1c4, 0x00000000},
	{0x0000a1c8, 0x00000000},
	{0x0000a1cc, 0x00000000},
	{0x0000a1d0, 0x00000000},
	{0x0000a1d4, 0x00000000},
	{0x0000a1d8, 0x00000000},
	{0x0000a1dc, 0x00000000},
	{0x0000a1e0, 0x00000000},
	{0x0000a1e4, 0x00000000},
	{0x0000a1e8, 0x00000000},
	{0x0000a1ec, 0x00000000},
	{0x0000a1f0, 0x00000396},
	{0x0000a1f4, 0x00000396},
	{0x0000a1f8, 0x00000396},
	{0x0000a1fc, 0x00000196},
	{0x0000b000, 0x00010000},
	{0x0000b004, 0x00030002},
	{0x0000b008, 0x00050004},
	{0x0000b00c, 0x00810080},
	{0x0000b010, 0x00830082},
	{0x0000b014, 0x01810180},
	{0x0000b018, 0x01830182},
	{0x0000b01c, 0x01850184},
	{0x0000b020, 0x02810280},
	{0x0000b024, 0x02830282},
	{0x0000b028, 0x02850284},
	{0x0000b02c, 0x02890288},
	{0x0000b030, 0x028b028a},
	{0x0000b034, 0x0388028c},
	{0x0000b038, 0x038a0389},
	{0x0000b03c, 0x038c038b},
	{0x0000b040, 0x0390038d},
	{0x0000b044, 0x03920391},
	{0x0000b048, 0x03940393},
	{0x0000b04c, 0x03960395},
	{0x0000b050, 0x00000000},
	{0x0000b054, 0x00000000},
	{0x0000b058, 0x00000000},
	{0x0000b05c, 0x00000000},
	{0x0000b060, 0x00000000},
	{0x0000b064, 0x00000000},
	{0x0000b068, 0x00000000},
	{0x0000b06c, 0x00000000},
	{0x0000b070, 0x00000000},
	{0x0000b074, 0x00000000},
	{0x0000b078, 0x00000000},
	{0x0000b07c, 0x00000000},
	{0x0000b080, 0x23232323},
	{0x0000b084, 0x21232323},
	{0x0000b088, 0x19191c1e},
	{0x0000b08c, 0x12141417},
	{0x0000b090, 0x07070e0e},
	{0x0000b094, 0x03030305},
	{0x0000b098, 0x00000003},
	{0x0000b09c, 0x00000000},
	{0x0000b0a0, 0x00000000},
	{0x0000b0a4, 0x00000000},
	{0x0000b0a8, 0x00000000},
	{0x0000b0ac, 0x00000000},
	{0x0000b0b0, 0x00000000},
	{0x0000b0b4, 0x00000000},
	{0x0000b0b8, 0x00000000},
	{0x0000b0bc, 0x00000000},
	{0x0000b0c0, 0x003f0020},
	{0x0000b0c4, 0x00400041},
	{0x0000b0c8, 0x0140005f},
	{0x0000b0cc, 0x0160015f},
	{0x0000b0d0, 0x017e017f},
	{0x0000b0d4, 0x02410242},
	{0x0000b0d8, 0x025f0240},
	{0x0000b0dc, 0x027f0260},
	{0x0000b0e0, 0x0341027e},
	{0x0000b0e4, 0x035f0340},
	{0x0000b0e8, 0x037f0360},
	{0x0000b0ec, 0x04400441},
	{0x0000b0f0, 0x0460045f},
	{0x0000b0f4, 0x0541047f},
	{0x0000b0f8, 0x055f0540},
	{0x0000b0fc, 0x057f0560},
	{0x0000b100, 0x06400641},
	{0x0000b104, 0x0660065f},
	{0x0000b108, 0x067e067f},
	{0x0000b10c, 0x07410742},
	{0x0000b110, 0x075f0740},
	{0x0000b114, 0x077f0760},
	{0x0000b118, 0x07800781},
	{0x0000b11c, 0x07a0079f},
	{0x0000b120, 0x07c107bf},
	{0x0000b124, 0x000007c0},
	{0x0000b128, 0x00000000},
	{0x0000b12c, 0x00000000},
	{0x0000b130, 0x00000000},
	{0x0000b134, 0x00000000},
	{0x0000b138, 0x00000000},
	{0x0000b13c, 0x00000000},
	{0x0000b140, 0x003f0020},
	{0x0000b144, 0x00400041},
	{0x0000b148, 0x0140005f},
	{0x0000b14c, 0x0160015f},
	{0x0000b150, 0x017e017f},
	{0x0000b154, 0x02410242},
	{0x0000b158, 0x025f0240},
	{0x0000b15c, 0x027f0260},
	{0x0000b160, 0x0341027e},
	{0x0000b164, 0x035f0340},
	{0x0000b168, 0x037f0360},
	{0x0000b16c, 0x04400441},
	{0x0000b170, 0x0460045f},
	{0x0000b174, 0x0541047f},
	{0x0000b178, 0x055f0540},
	{0x0000b17c, 0x057f0560},
	{0x0000b180, 0x06400641},
	{0x0000b184, 0x0660065f},
	{0x0000b188, 0x067e067f},
	{0x0000b18c, 0x07410742},
	{0x0000b190, 0x075f0740},
	{0x0000b194, 0x077f0760},
	{0x0000b198, 0x07800781},
	{0x0000b19c, 0x07a0079f},
	{0x0000b1a0, 0x07c107bf},
	{0x0000b1a4, 0x000007c0},
	{0x0000b1a8, 0x00000000},
	{0x0000b1ac, 0x00000000},
	{0x0000b1b0, 0x00000000},
	{0x0000b1b4, 0x00000000},
	{0x0000b1b8, 0x00000000},
	{0x0000b1bc, 0x00000000},
	{0x0000b1c0, 0x00000000},
	{0x0000b1c4, 0x00000000},
	{0x0000b1c8, 0x00000000},
	{0x0000b1cc, 0x00000000},
	{0x0000b1d0, 0x00000000},
	{0x0000b1d4, 0x00000000},
	{0x0000b1d8, 0x00000000},
	{0x0000b1dc, 0x00000000},
	{0x0000b1e0, 0x00000000},
	{0x0000b1e4, 0x00000000},
	{0x0000b1e8, 0x00000000},
	{0x0000b1ec, 0x00000000},
	{0x0000b1f0, 0x00000396},
	{0x0000b1f4, 0x00000396},
	{0x0000b1f8, 0x00000396},
	{0x0000b1fc, 0x00000196},
};

static const u32 qca956x_1p0_xlna_only[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00009820, 0x206a022e, 0x206a022e, 0x206a01ae, 0x206a01ae},
	{0x00009824, 0x5ac640d0, 0x5ac640d0, 0x5ac621f1, 0x5ac621f1},
	{0x00009828, 0x06903081, 0x06903081, 0x07d43881, 0x07d43881},
	{0x00009e00, 0x0372111a, 0x0372111a, 0x037216a0, 0x03721720},
	{0x00009e0c, 0x6c4000e2, 0x6d4000e2, 0x6d4000de, 0x6c4000da},
	{0x00009e10, 0x7ec88d2e, 0x7ec88d2e, 0x7ec86d2e, 0x7ec8ad2e},
	{0x00009e14, 0x37b95d5e, 0x37b9605e, 0x317a6062, 0x317a5ae2},
	{0x00009e18, 0x00000000, 0x00000000, 0x03c00000, 0x03c00000},
	{0x00009e20, 0x000003b5, 0x000003b5, 0x000003b2, 0x000003b2},
	{0x00009fc0, 0x813e4788, 0x813e4788, 0x813e4789, 0x813e4789},
	{0x0000ae18, 0x00000000, 0x00000000, 0x03c00000, 0x03c00000},
	{0x0000ae20, 0x000001b5, 0x000001b5, 0x000001b2, 0x000001b2},
	{0x0000be18, 0x00000000, 0x00000000, 0x03c00000, 0x03c00000},
	{0x0000be20, 0x000001b5, 0x000001b5, 0x000001b2, 0x000001b2},
};

#endif /* INITVALS_956X_H */
