/*
 * dextab.h - Contains definition of dynamically expandable tables 
 *
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
#ifndef __LINUX_DEXTAB_H
#define __LINUX_DEXTAB_H

#include <asm/byteorder.h>

/* Dynamically expandable table structure */

struct dex_table {
	void **			addr;
	__u16			size;
	__u16			reserved;
	__u16			max_size;
	__u16			count;
};
typedef struct dex_table dextab_t;

#define DEXTAB_NOFREE_ENTRY	0
#define DEXTAB_FREE_ENTRY	1

#define dextab_add_entry( tbl, entry_size) 	dextab_add_insert_entry(tbl, entry_size, NULL)
#define dextab_insert_entry( tbl, entry)	dextab_add_insert_entry(tbl, 0, entry)

#define dextab_remove_index( tbl, entry_index) 	dextab_remove_delete_index(tbl, entry_index, DEXTAB_FREE_ENTRY)
#define dextab_delete_index( tbl, entry_index)  dextab_remove_delete_index(tbl, entry_index, DEXTAB_NOFREE_ENTRY)
#define dextab_remove_entry( tbl, entry)	dextab_remove_delete_index(tbl, dextab_entry_index(tbl, entry), DEXTAB_FREE_ENTRY)
#define dextab_delete_entry( tbl, entry)	dextab_remove_delete_index(tbl, dextab_entry_index(tbl, entry), DEXTAB_NOFREE_ENTRY)


/* Dynamically expandable table interface */

extern void	dextab_init( dextab_t *tbl, int reserved, int max_size);

extern int	dextab_add_insert_entry( dextab_t *tbl, int entry_size, void *entry);
extern void	dextab_remove_delete_index( dextab_t *tbl, int entry_index, int flag);

extern int	dextab_entry_index( dextab_t *tbl, void *entry);
extern inline int	dextab_count_entries( dextab_t *tbl);

extern void 	dextab_destruct( dextab_t *tbl);

extern void	dextab_test(void);


#endif __LINUX_DEXTAB_H
