/*
 * Copyright (c) 2003 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 *
 * This file houses the Linked List definitions.
 */
#ifndef ISCSI_LISTS_H
#define ISCSI_LISTS_H

#define ADD_ENTRY_TO_LIST(e, head, tail)			\
	if (!head && !tail) {					\
		head = tail = e;				\
		e->next = e->prev = NULL;			\
	} else {						\
		tail->next = e;					\
		e->prev = tail;					\
		tail = e;					\
	}

#define REMOVE_ENTRY_FROM_LIST(e, head, tail)			\
	if (!e->prev && !e->next)				\
		head = tail = NULL;				\
	else {							\
		if (!e->prev) {					\
			e->next->prev = NULL;			\
			head = e->next;				\
			if (!head->next)			\
				tail = head;			\
		} else if (!e->next) {				\
			e->prev->next = NULL;			\
			tail = e->prev;				\
		} else {					\
			e->next->prev = e->prev;		\
			e->prev->next = e->next;		\
		}						\
		e->next = e->prev = NULL;			\
	}

#endif /* ISCSI_LISTS_H */
