/*
 * Copyright (c) 2003, 2004, 2005 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 *
 * This file houses task management functions used by the iSCSI Initiator.
 *
 * Nicholas A. Bellinger <nab@kernel.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#define ISCSI_INITIATOR_TMR_C 
                
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/spinlock.h>
#include <linux/smp_lock.h>
#include <iscsi_linux_os.h>
#include <iscsi_protocol.h>
#include <iscsi_debug.h>
#include <iscsi_initiator_debug_opcodes.h>
#include <iscsi_initiator_core.h>
#include <iscsi_initiator_erl0.h>
#include <iscsi_initiator_erl1.h>
#include <iscsi_initiator_linux.h>
#include <iscsi_initiator_scsi.h>
#include <iscsi_initiator_util.h>
#include <iscsi_initiator_crc.h>

#undef ISCSI_INITIATOR_TMR_C

//#warning FIXME: Map SCSI Task Management Commands

extern int iscsi_tmr_abort_task (iscsi_cmd_t *cmd)
{
	return(0);
}

extern int iscsi_tmr_abort_task_set (iscsi_cmd_t *cmd)
{
	return(0);
}

extern int iscsi_tmr_clear_aca (iscsi_cmd_t *cmd)
{
	return(0);
}

extern int iscsi_tmr_clear_task_set (iscsi_cmd_t *cmd)
{
	return(0);
}

extern int iscsi_tmr_logical_unit_reset (iscsi_cmd_t *cmd)
{
	return(0);
}

extern int iscsi_tmr_target_warm_reset (iscsi_cmd_t *cmd)
{
	return(0);
}

extern int iscsi_tmr_target_cold_reset (iscsi_cmd_t *cmd)
{
	return(0);
}
