/*
 * Copyright (c) 2003-2004 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 *
 * This file houses the LINUX dependant definitions
 * for the iSCSI Initiator driver.
 */

#ifndef ISCSI_INITIATOR_LINUX_H
#define ISCSI_INITIATOR_LINUX_H

#define SCSI_LUN(sc)	(sc)->device->lun

extern int iscsi_check_for_active_network_device (void *);
extern void iscsi_complete_command(struct scsi_cmnd *);
extern void iscsi_set_result_from_action_and_complete (struct scsi_cmnd *, u8);
extern void iscsi_get_network_interface_from_socket (void *);
extern void *iscsi_OS_get_SCSI_lu (void *, int *);
extern int iscsi_OS_get_SCSI_HOST_ID (void *ch);
extern int iscsi_OS_get_SCSI_lun(void *);
extern int iscsi_OS_check_lu_online (void *);
extern void *iscsi_OS_get_SAM_lu (int, void *);
extern void linux_scsi_forget_host(struct Scsi_Host *);
extern void iscsi_scsi_block_devices (iscsi_channel_t *);
extern void iscsi_scsi_unblock_devices (iscsi_channel_t *);
extern void iscsi_scsi_offline_devices (iscsi_channel_t *);
extern void iscsi_unmap_scatterlists (void *);
extern int iscsi_map_scatterlists(void *, void *);
extern void iscsi_OS_set_SCSI_lun_failure(void *);
extern void iscsi_OS_set_SCSI_status(void *, int);
extern void iscsi_set_SCSI_tag_attr(struct scsi_cmnd *, struct iscsi_init_scsi_cmnd *);
extern int iscsi_OS_init_iscsi_channel (void *, u32);
extern void iscsi_OS_free_scsi_host (void *);

#endif /* ISCSI_INITIATOR_LINUX_H */
