/*
 * Copyright (c) 2003-2004 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 * 
 * This file houses the iSCSI Initiator specific iSCSI Channel definations.
 */

#ifndef ISCSI_INITIATOR_CHANNEL_H
#define ISCSI_INITIATOR_CHANNEL_H

extern void iscsi_init_channels (void);
extern void iscsi_add_chan_conn_to_channel (iscsi_channel_t *, iscsi_channel_conn_t *);
extern void iscsi_del_chan_conn_from_channel (iscsi_channel_t *, iscsi_channel_conn_t *);
extern iscsi_channel_conn_t *iscsi_add_conn_to_channel_for_reinstatement (iscsi_conn_t *);
extern iscsi_channel_conn_t *iscsi_get_cid_from_channel (iscsi_channel_t *, u16);
extern iscsi_channel_conn_t *iscsi_get_conn_from_channel (iscsi_channel_t *);
extern void iscsi_dump_channel_params (iscsi_channel_t *);
extern int iscsi_check_active_iSCSI_LUNs (iscsi_channel_t *, int);
extern void iscsi_release_logical_units (iscsi_channel_t *);
extern void iscsi_free_all_channel_resources (void);
extern void iscsi_activate_channel (iscsi_conn_t *, iscsi_login_holder_t *);
extern int iscsi_force_channel_offline (iscsi_channel_t *);
extern int iscsi_free_channel (iscsi_channel_t *);
extern int iscsi_init_channel (iscsi_channel_t *, u32, int);
extern int iscsi_stop_channel (iscsi_channel_t *, int);
extern iscsi_channel_t *iscsi_get_channel_from_id (int, int);
extern void iscsi_put_channel (iscsi_channel_t *);
extern iscsi_session_t *__iscsi_get_session_from_channel_id (iscsi_channel_t *);
extern iscsi_session_t *iscsi_get_session_from_channel_id (iscsi_channel_t *);
extern iscsi_channel_lun_t *iscsi_get_lun_from_channel (int, iscsi_channel_t *);
extern int iscsi_queue_scsi_cmnd_to_channel (struct scsi_cmnd *, iscsi_channel_t *c);
extern void iscsi_move_scsi_cmnd_to_channel (struct scsi_cmnd *, int);
extern void iscsi_move_conn_scsi_cmnd_to_channel (iscsi_conn_t *, iscsi_channel_t *);
extern void iscsi_move_sess_scsi_cmnd_to_channel (iscsi_session_t *, iscsi_channel_t *);
extern void iscsi_set_scsi_cmnd_results_for_channel (iscsi_channel_t *, u8);
extern void iscsi_set_conn_scsi_cmnd_results (iscsi_conn_t *, u8);
extern void iscsi_stop_channel_reinstatement_process (iscsi_channel_t *, int);
extern int iscsi_check_channel_status_for_login (iscsi_channel_t *);
extern int iscsi_set_channel_status (iscsi_channel_t *, int, int);
extern iscsi_channel_req_t *iscsi_allocate_ch_req (int, void *, int, iscsi_channel_req_t *);
extern void ISCSI_ADD_CH_req (iscsi_channel_req_t *, iscsi_channel_t *);
extern void ISCSI_ADD_CH_scan (iscsi_channel_req_t *, iscsi_channel_t *);
extern void iscsi_complete_ch_req (iscsi_channel_req_t *, iscsi_channel_t *);
extern void iscsi_complete_ch_scan (iscsi_channel_req_t *, iscsi_channel_t *);
extern void iscsi_channel_start_threads (iscsi_channel_t *);
extern void iscsi_channel_stop_threads (iscsi_channel_t *);

#endif /* ISCSI_INITIATOR_CHANNEL_H */
