#
# Copyright (c) 2010 Canonical
#
# Written by Gustavo Niemeyer <gustavo@niemeyer.net>
#
# This file is part of the Xpresser GUI automation library.
#
# Xpresser is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3,
# as published by the Free Software Foundation.
#
# Xpresser is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
""" Test Find functionality of XPresser"""

from mago import TestCase
from xpresser.image import Image
from xpresser.opencvfinder import OpenCVFinder

desktop = Image(filename="data/desktop.png")
button1 =  Image(filename="data/button01.png")

class TestXPOpenCVFinder(TestCase):
    """ Test Class"""
    launcher = "gedit"
    window_name = 'frm*gedit'

    def test_xpfindall(self):
        """Test the find_all method of xpresser

        Count the number of occurences of the reference image in the 
        main image.
        Should be 4
        """

        finder = OpenCVFinder()
        m = finder.find_all(desktop, button1)
        self.assertEqual(len(m), 4)


