package org.herac.tuxguitar.app.action.listener.cache.controller;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.app.action.impl.file.TGWriteFileAction;
import org.herac.tuxguitar.app.document.TGDocument;
import org.herac.tuxguitar.app.document.TGDocumentListManager;
import org.herac.tuxguitar.app.helper.TGFileHistory;
import org.herac.tuxguitar.app.transport.TGTransport;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.editor.undo.TGUndoableManager;
import org.herac.tuxguitar.util.TGContext;

public class TGUpdateSavedSongController extends TGUpdateItemsController {

	public TGUpdateSavedSongController() {
		super();
	}

	@Override
	public void update(TGContext context, TGActionContext actionContext) {
		// ------------------------------------------------------ //		
		TGUndoableManager.getInstance(context).discardAllEdits();
		
		TGDocument tgDocument = TGDocumentListManager.getInstance(context).findCurrentDocument();
		tgDocument.setUnwanted(false);
		if (Boolean.TRUE.equals(actionContext.getAttribute(TGWriteFileAction.ATTRIBUTE_NATIVE_FILE_FORMAT) )) {
			tgDocument.setUnsaved(false);
		}
		
		TGFileHistory tgFileHistory = TGFileHistory.getInstance(context);
		tgFileHistory.reset(null);
		
		TGTransport.getInstance(context).getCache().reset();
		TGWindow.getInstance(context).loadTitle();
		// ------------------------------------------------------ //
		
		this.findUpdateBuffer(context, actionContext).requestUpdateSavedSong();
		
		super.update(context, actionContext);
	}
}
