#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 446
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 238
#define ALIAS_COUNT 0
#define TOKEN_COUNT 107
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 45
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 96

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_module = 2,
  anon_sym_version = 3,
  anon_sym_is = 4,
  anon_sym_end = 5,
  anon_sym_import = 6,
  anon_sym_LBRACK = 7,
  anon_sym_RBRACK = 8,
  anon_sym_COLON = 9,
  anon_sym_AT = 10,
  anon_sym_EQ = 11,
  anon_sym_assert = 12,
  sym_controlled_language_tag = 13,
  anon_sym_LPAREN = 14,
  anon_sym_RPAREN = 15,
  anon_sym_SLASH_EQ = 16,
  anon_sym_u2260 = 17,
  sym_less_than = 18,
  sym_greater_than = 19,
  anon_sym_LT_EQ = 20,
  anon_sym_u2264 = 21,
  anon_sym_GT_EQ = 22,
  anon_sym_u2265 = 23,
  anon_sym_not = 24,
  anon_sym_u00ac = 25,
  anon_sym_and = 26,
  anon_sym_u2227 = 27,
  anon_sym_or = 28,
  anon_sym_u2228 = 29,
  anon_sym_xor = 30,
  anon_sym_u22bb = 31,
  anon_sym_implies = 32,
  anon_sym_EQ_EQ_GT = 33,
  anon_sym_u21d2 = 34,
  anon_sym_iff = 35,
  anon_sym_LT_EQ_EQ_GT = 36,
  anon_sym_u21d4 = 37,
  anon_sym_COMMA = 38,
  anon_sym_forall = 39,
  anon_sym_u2200 = 40,
  anon_sym_exists = 41,
  anon_sym_u2203 = 42,
  anon_sym_in = 43,
  anon_sym_u2208 = 44,
  anon_sym_DOT = 45,
  anon_sym_u2205 = 46,
  sym_reserved_self = 47,
  anon_sym_def = 48,
  anon_sym_COLON_EQ = 49,
  anon_sym_u2254 = 50,
  anon_sym_LBRACE = 51,
  anon_sym_RBRACE = 52,
  sym_optional = 53,
  anon_sym_PIPE = 54,
  anon_sym_boolean = 55,
  anon_sym_unsigned = 56,
  anon_sym_integer = 57,
  anon_sym_decimal = 58,
  anon_sym_double = 59,
  anon_sym_string = 60,
  anon_sym_iri = 61,
  anon_sym_binary = 62,
  sym_quoted_string = 63,
  sym_language_tag = 64,
  anon_sym_LT = 65,
  aux_sym_iri_token1 = 66,
  anon_sym_GT = 67,
  anon_sym_POUND_LBRACK = 68,
  sym_hex_byte = 69,
  sym_double = 70,
  sym_decimal = 71,
  sym_integer = 72,
  sym_unsigned = 73,
  anon_sym_true = 74,
  anon_sym_u22a4 = 75,
  anon_sym_false = 76,
  anon_sym_u22a5 = 77,
  anon_sym_datatype = 78,
  sym_opaque = 79,
  anon_sym_entity = 80,
  anon_sym_enum = 81,
  anon_sym_of = 82,
  anon_sym_event = 83,
  anon_sym_source = 84,
  anon_sym_property = 85,
  anon_sym_structure = 86,
  anon_sym_union = 87,
  anon_sym_rdf = 88,
  anon_sym_type = 89,
  anon_sym_class = 90,
  anon_sym_PLUS = 91,
  sym_wildcard = 92,
  anon_sym_identity = 93,
  anon_sym_ref = 94,
  sym_unknown_type = 95,
  anon_sym_ordered = 96,
  anon_sym_unordered = 97,
  anon_sym_unique = 98,
  anon_sym_nonunique = 99,
  anon_sym_DOT_DOT = 100,
  anon_sym_u2192 = 101,
  anon_sym_DASH_GT = 102,
  anon_sym_u2190 = 103,
  anon_sym_LT_DASH = 104,
  anon_sym_as = 105,
  sym_line_comment = 106,
  sym_module = 107,
  sym__module_locations = 108,
  sym_module_body = 109,
  sym_import_statement = 110,
  sym__import = 111,
  sym_member_import = 112,
  sym_module_import = 113,
  sym_qualified_identifier = 114,
  sym_identifier_reference = 115,
  sym_annotation = 116,
  sym_annotation_property = 117,
  sym_constraint = 118,
  sym_informal_constraint = 119,
  sym_formal_constraint = 120,
  sym_constraint_sentence = 121,
  sym_simple_sentence = 122,
  sym_atomic_sentence = 123,
  sym_actual_arguments = 124,
  sym_equation = 125,
  sym_inequation = 126,
  sym_not_equal = 127,
  sym_less_than_or_equal = 128,
  sym_greater_than_or_equal = 129,
  sym_boolean_sentence = 130,
  sym_unary_boolean_sentence = 131,
  sym_binary_boolean_sentence = 132,
  sym_negation = 133,
  sym__logical_connective = 134,
  sym_conjunction = 135,
  sym_disjunction = 136,
  sym_exclusive_disjunction = 137,
  sym_implication = 138,
  sym_biconditional = 139,
  sym_quantified_sentence = 140,
  sym_quantified_variable_binding = 141,
  sym_universal = 142,
  sym_existential = 143,
  sym_quantified_variable = 144,
  sym_term = 145,
  sym_functional_term = 146,
  sym_function_composition = 147,
  sym_predicate_value = 148,
  sym_sequence_of_predicate_values = 149,
  sym_constraint_environment = 150,
  sym_environment_def = 151,
  sym_constraint_environment_end = 152,
  sym_function_def = 153,
  sym_function_body = 154,
  sym__by_definition = 155,
  sym_function_signature = 156,
  sym_function_parameter = 157,
  sym__function_type = 158,
  sym_function_cardinality_expression = 159,
  sym_function_type_reference = 160,
  sym_constant_def = 161,
  sym_sequence_builder = 162,
  sym_named_variable_set = 163,
  sym_mapping_variable = 164,
  sym_sequence_builder_body = 165,
  sym_value = 166,
  sym_sequence_of_values = 167,
  sym__sequence_value_constraints = 168,
  sym_value_constructor = 169,
  sym_mapping_value = 170,
  sym_builtin_simple_type = 171,
  sym_simple_value = 172,
  sym_string = 173,
  sym_iri = 174,
  sym_binary = 175,
  sym_boolean = 176,
  sym_boolean_truth = 177,
  sym_boolean_falsity = 178,
  sym_definition = 179,
  sym_data_type_def = 180,
  sym__data_type_base = 181,
  sym_annotation_only_body = 182,
  sym_entity_def = 183,
  sym_entity_body = 184,
  sym_enum_def = 185,
  sym_enum_body = 186,
  sym_event_def = 187,
  sym_property_def = 188,
  sym_structure_def = 189,
  sym_structured_body = 190,
  sym_union_def = 191,
  sym_union_body = 192,
  sym_rdf_def = 193,
  sym_rdf_types = 194,
  sym_type_class_def = 195,
  sym_type_variable = 196,
  sym__type_variable_restriction = 197,
  sym_type_class_reference = 198,
  sym_type_class_arguments = 199,
  sym_type_class_body = 200,
  sym_method_def = 201,
  sym_entity_identity = 202,
  sym_member = 203,
  sym_member_def = 204,
  sym_property_ref = 205,
  sym__type_expression_to = 206,
  sym_type_reference = 207,
  sym_mapping_type = 208,
  sym_cardinality_expression = 209,
  sym__cardinality_inner = 210,
  sym_sequence_ordering = 211,
  sym_sequence_uniqueness = 212,
  sym_cardinality_range = 213,
  sym__has_type = 214,
  sym__type_restriction = 215,
  sym_value_variant = 216,
  sym_type_variant = 217,
  aux_sym_module_body_repeat1 = 218,
  aux_sym_module_body_repeat2 = 219,
  aux_sym_module_body_repeat3 = 220,
  aux_sym_import_statement_repeat1 = 221,
  aux_sym_actual_arguments_repeat1 = 222,
  aux_sym_function_composition_repeat1 = 223,
  aux_sym_sequence_of_predicate_values_repeat1 = 224,
  aux_sym_constraint_environment_repeat1 = 225,
  aux_sym_function_signature_repeat1 = 226,
  aux_sym_named_variable_set_repeat1 = 227,
  aux_sym_sequence_of_values_repeat1 = 228,
  aux_sym_binary_repeat1 = 229,
  aux_sym_entity_body_repeat1 = 230,
  aux_sym_enum_body_repeat1 = 231,
  aux_sym_union_body_repeat1 = 232,
  aux_sym_rdf_types_repeat1 = 233,
  aux_sym_type_class_def_repeat1 = 234,
  aux_sym__type_variable_restriction_repeat1 = 235,
  aux_sym_type_class_arguments_repeat1 = 236,
  aux_sym_type_class_body_repeat1 = 237,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_module] = "module",
  [anon_sym_version] = "version",
  [anon_sym_is] = "is",
  [anon_sym_end] = "end",
  [anon_sym_import] = "import",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_EQ] = "=",
  [anon_sym_assert] = "assert",
  [sym_controlled_language_tag] = "controlled_language_tag",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_u2260] = "\u2260",
  [sym_less_than] = "less_than",
  [sym_greater_than] = "greater_than",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_u2264] = "\u2264",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_u2265] = "\u2265",
  [anon_sym_not] = "not",
  [anon_sym_u00ac] = "\u00ac",
  [anon_sym_and] = "and",
  [anon_sym_u2227] = "\u2227",
  [anon_sym_or] = "or",
  [anon_sym_u2228] = "\u2228",
  [anon_sym_xor] = "xor",
  [anon_sym_u22bb] = "\u22bb",
  [anon_sym_implies] = "implies",
  [anon_sym_EQ_EQ_GT] = "==>",
  [anon_sym_u21d2] = "\u21d2",
  [anon_sym_iff] = "iff",
  [anon_sym_LT_EQ_EQ_GT] = "<==>",
  [anon_sym_u21d4] = "\u21d4",
  [anon_sym_COMMA] = ",",
  [anon_sym_forall] = "forall",
  [anon_sym_u2200] = "\u2200",
  [anon_sym_exists] = "exists",
  [anon_sym_u2203] = "\u2203",
  [anon_sym_in] = "in",
  [anon_sym_u2208] = "\u2208",
  [anon_sym_DOT] = ".",
  [anon_sym_u2205] = "\u2205",
  [sym_reserved_self] = "reserved_self",
  [anon_sym_def] = "def",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_u2254] = "\u2254",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym_optional] = "optional",
  [anon_sym_PIPE] = "|",
  [anon_sym_boolean] = "boolean",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_integer] = "integer",
  [anon_sym_decimal] = "decimal",
  [anon_sym_double] = "double",
  [anon_sym_string] = "string",
  [anon_sym_iri] = "iri",
  [anon_sym_binary] = "binary",
  [sym_quoted_string] = "quoted_string",
  [sym_language_tag] = "language_tag",
  [anon_sym_LT] = "<",
  [aux_sym_iri_token1] = "iri_token1",
  [anon_sym_GT] = ">",
  [anon_sym_POUND_LBRACK] = "#[",
  [sym_hex_byte] = "hex_byte",
  [sym_double] = "double",
  [sym_decimal] = "decimal",
  [sym_integer] = "integer",
  [sym_unsigned] = "unsigned",
  [anon_sym_true] = "true",
  [anon_sym_u22a4] = "\u22a4",
  [anon_sym_false] = "false",
  [anon_sym_u22a5] = "\u22a5",
  [anon_sym_datatype] = "datatype",
  [sym_opaque] = "opaque",
  [anon_sym_entity] = "entity",
  [anon_sym_enum] = "enum",
  [anon_sym_of] = "of",
  [anon_sym_event] = "event",
  [anon_sym_source] = "source",
  [anon_sym_property] = "property",
  [anon_sym_structure] = "structure",
  [anon_sym_union] = "union",
  [anon_sym_rdf] = "rdf",
  [anon_sym_type] = "type",
  [anon_sym_class] = "class",
  [anon_sym_PLUS] = "+",
  [sym_wildcard] = "wildcard",
  [anon_sym_identity] = "identity",
  [anon_sym_ref] = "ref",
  [sym_unknown_type] = "unknown_type",
  [anon_sym_ordered] = "ordered",
  [anon_sym_unordered] = "unordered",
  [anon_sym_unique] = "unique",
  [anon_sym_nonunique] = "nonunique",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_u2192] = "\u2192",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_u2190] = "\u2190",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_as] = "as",
  [sym_line_comment] = "line_comment",
  [sym_module] = "module",
  [sym__module_locations] = "_module_locations",
  [sym_module_body] = "module_body",
  [sym_import_statement] = "import_statement",
  [sym__import] = "_import",
  [sym_member_import] = "member_import",
  [sym_module_import] = "module_import",
  [sym_qualified_identifier] = "qualified_identifier",
  [sym_identifier_reference] = "identifier_reference",
  [sym_annotation] = "annotation",
  [sym_annotation_property] = "annotation_property",
  [sym_constraint] = "constraint",
  [sym_informal_constraint] = "informal_constraint",
  [sym_formal_constraint] = "formal_constraint",
  [sym_constraint_sentence] = "constraint_sentence",
  [sym_simple_sentence] = "simple_sentence",
  [sym_atomic_sentence] = "atomic_sentence",
  [sym_actual_arguments] = "actual_arguments",
  [sym_equation] = "equation",
  [sym_inequation] = "inequation",
  [sym_not_equal] = "not_equal",
  [sym_less_than_or_equal] = "less_than_or_equal",
  [sym_greater_than_or_equal] = "greater_than_or_equal",
  [sym_boolean_sentence] = "boolean_sentence",
  [sym_unary_boolean_sentence] = "unary_boolean_sentence",
  [sym_binary_boolean_sentence] = "binary_boolean_sentence",
  [sym_negation] = "negation",
  [sym__logical_connective] = "_logical_connective",
  [sym_conjunction] = "conjunction",
  [sym_disjunction] = "disjunction",
  [sym_exclusive_disjunction] = "exclusive_disjunction",
  [sym_implication] = "implication",
  [sym_biconditional] = "biconditional",
  [sym_quantified_sentence] = "quantified_sentence",
  [sym_quantified_variable_binding] = "quantified_variable_binding",
  [sym_universal] = "universal",
  [sym_existential] = "existential",
  [sym_quantified_variable] = "quantified_variable",
  [sym_term] = "term",
  [sym_functional_term] = "functional_term",
  [sym_function_composition] = "function_composition",
  [sym_predicate_value] = "predicate_value",
  [sym_sequence_of_predicate_values] = "sequence_of_predicate_values",
  [sym_constraint_environment] = "constraint_environment",
  [sym_environment_def] = "environment_def",
  [sym_constraint_environment_end] = "constraint_environment_end",
  [sym_function_def] = "function_def",
  [sym_function_body] = "function_body",
  [sym__by_definition] = "_by_definition",
  [sym_function_signature] = "function_signature",
  [sym_function_parameter] = "function_parameter",
  [sym__function_type] = "_function_type",
  [sym_function_cardinality_expression] = "function_cardinality_expression",
  [sym_function_type_reference] = "function_type_reference",
  [sym_constant_def] = "constant_def",
  [sym_sequence_builder] = "sequence_builder",
  [sym_named_variable_set] = "named_variable_set",
  [sym_mapping_variable] = "mapping_variable",
  [sym_sequence_builder_body] = "sequence_builder_body",
  [sym_value] = "value",
  [sym_sequence_of_values] = "sequence_of_values",
  [sym__sequence_value_constraints] = "_sequence_value_constraints",
  [sym_value_constructor] = "value_constructor",
  [sym_mapping_value] = "mapping_value",
  [sym_builtin_simple_type] = "builtin_simple_type",
  [sym_simple_value] = "simple_value",
  [sym_string] = "string",
  [sym_iri] = "iri",
  [sym_binary] = "binary",
  [sym_boolean] = "boolean",
  [sym_boolean_truth] = "boolean_truth",
  [sym_boolean_falsity] = "boolean_falsity",
  [sym_definition] = "definition",
  [sym_data_type_def] = "data_type_def",
  [sym__data_type_base] = "_data_type_base",
  [sym_annotation_only_body] = "annotation_only_body",
  [sym_entity_def] = "entity_def",
  [sym_entity_body] = "entity_body",
  [sym_enum_def] = "enum_def",
  [sym_enum_body] = "enum_body",
  [sym_event_def] = "event_def",
  [sym_property_def] = "property_def",
  [sym_structure_def] = "structure_def",
  [sym_structured_body] = "structured_body",
  [sym_union_def] = "union_def",
  [sym_union_body] = "union_body",
  [sym_rdf_def] = "rdf_def",
  [sym_rdf_types] = "rdf_types",
  [sym_type_class_def] = "type_class_def",
  [sym_type_variable] = "type_variable",
  [sym__type_variable_restriction] = "_type_variable_restriction",
  [sym_type_class_reference] = "type_class_reference",
  [sym_type_class_arguments] = "type_class_arguments",
  [sym_type_class_body] = "type_class_body",
  [sym_method_def] = "method_def",
  [sym_entity_identity] = "entity_identity",
  [sym_member] = "member",
  [sym_member_def] = "member_def",
  [sym_property_ref] = "property_ref",
  [sym__type_expression_to] = "_type_expression_to",
  [sym_type_reference] = "type_reference",
  [sym_mapping_type] = "mapping_type",
  [sym_cardinality_expression] = "cardinality_expression",
  [sym__cardinality_inner] = "_cardinality_inner",
  [sym_sequence_ordering] = "sequence_ordering",
  [sym_sequence_uniqueness] = "sequence_uniqueness",
  [sym_cardinality_range] = "cardinality_range",
  [sym__has_type] = "_has_type",
  [sym__type_restriction] = "_type_restriction",
  [sym_value_variant] = "value_variant",
  [sym_type_variant] = "type_variant",
  [aux_sym_module_body_repeat1] = "module_body_repeat1",
  [aux_sym_module_body_repeat2] = "module_body_repeat2",
  [aux_sym_module_body_repeat3] = "module_body_repeat3",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym_actual_arguments_repeat1] = "actual_arguments_repeat1",
  [aux_sym_function_composition_repeat1] = "function_composition_repeat1",
  [aux_sym_sequence_of_predicate_values_repeat1] = "sequence_of_predicate_values_repeat1",
  [aux_sym_constraint_environment_repeat1] = "constraint_environment_repeat1",
  [aux_sym_function_signature_repeat1] = "function_signature_repeat1",
  [aux_sym_named_variable_set_repeat1] = "named_variable_set_repeat1",
  [aux_sym_sequence_of_values_repeat1] = "sequence_of_values_repeat1",
  [aux_sym_binary_repeat1] = "binary_repeat1",
  [aux_sym_entity_body_repeat1] = "entity_body_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_union_body_repeat1] = "union_body_repeat1",
  [aux_sym_rdf_types_repeat1] = "rdf_types_repeat1",
  [aux_sym_type_class_def_repeat1] = "type_class_def_repeat1",
  [aux_sym__type_variable_restriction_repeat1] = "_type_variable_restriction_repeat1",
  [aux_sym_type_class_arguments_repeat1] = "type_class_arguments_repeat1",
  [aux_sym_type_class_body_repeat1] = "type_class_body_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_version] = anon_sym_version,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_assert] = anon_sym_assert,
  [sym_controlled_language_tag] = sym_controlled_language_tag,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_u2260] = anon_sym_u2260,
  [sym_less_than] = sym_less_than,
  [sym_greater_than] = sym_greater_than,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_u2264] = anon_sym_u2264,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_u2265] = anon_sym_u2265,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_u00ac] = anon_sym_u00ac,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_u2227] = anon_sym_u2227,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_u2228] = anon_sym_u2228,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_u22bb] = anon_sym_u22bb,
  [anon_sym_implies] = anon_sym_implies,
  [anon_sym_EQ_EQ_GT] = anon_sym_EQ_EQ_GT,
  [anon_sym_u21d2] = anon_sym_u21d2,
  [anon_sym_iff] = anon_sym_iff,
  [anon_sym_LT_EQ_EQ_GT] = anon_sym_LT_EQ_EQ_GT,
  [anon_sym_u21d4] = anon_sym_u21d4,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_forall] = anon_sym_forall,
  [anon_sym_u2200] = anon_sym_u2200,
  [anon_sym_exists] = anon_sym_exists,
  [anon_sym_u2203] = anon_sym_u2203,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_u2208] = anon_sym_u2208,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_u2205] = anon_sym_u2205,
  [sym_reserved_self] = sym_reserved_self,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_u2254] = anon_sym_u2254,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym_optional] = sym_optional,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_integer] = anon_sym_integer,
  [anon_sym_decimal] = anon_sym_decimal,
  [anon_sym_double] = anon_sym_double,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_iri] = anon_sym_iri,
  [anon_sym_binary] = anon_sym_binary,
  [sym_quoted_string] = sym_quoted_string,
  [sym_language_tag] = sym_language_tag,
  [anon_sym_LT] = anon_sym_LT,
  [aux_sym_iri_token1] = aux_sym_iri_token1,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_POUND_LBRACK] = anon_sym_POUND_LBRACK,
  [sym_hex_byte] = sym_hex_byte,
  [sym_double] = sym_double,
  [sym_decimal] = sym_decimal,
  [sym_integer] = sym_integer,
  [sym_unsigned] = sym_unsigned,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_u22a4] = anon_sym_u22a4,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_u22a5] = anon_sym_u22a5,
  [anon_sym_datatype] = anon_sym_datatype,
  [sym_opaque] = sym_opaque,
  [anon_sym_entity] = anon_sym_entity,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_event] = anon_sym_event,
  [anon_sym_source] = anon_sym_source,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_structure] = anon_sym_structure,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_rdf] = anon_sym_rdf,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [sym_wildcard] = sym_wildcard,
  [anon_sym_identity] = anon_sym_identity,
  [anon_sym_ref] = anon_sym_ref,
  [sym_unknown_type] = sym_unknown_type,
  [anon_sym_ordered] = anon_sym_ordered,
  [anon_sym_unordered] = anon_sym_unordered,
  [anon_sym_unique] = anon_sym_unique,
  [anon_sym_nonunique] = anon_sym_nonunique,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_u2192] = anon_sym_u2192,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_u2190] = anon_sym_u2190,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_as] = anon_sym_as,
  [sym_line_comment] = sym_line_comment,
  [sym_module] = sym_module,
  [sym__module_locations] = sym__module_locations,
  [sym_module_body] = sym_module_body,
  [sym_import_statement] = sym_import_statement,
  [sym__import] = sym__import,
  [sym_member_import] = sym_member_import,
  [sym_module_import] = sym_module_import,
  [sym_qualified_identifier] = sym_qualified_identifier,
  [sym_identifier_reference] = sym_identifier_reference,
  [sym_annotation] = sym_annotation,
  [sym_annotation_property] = sym_annotation_property,
  [sym_constraint] = sym_constraint,
  [sym_informal_constraint] = sym_informal_constraint,
  [sym_formal_constraint] = sym_formal_constraint,
  [sym_constraint_sentence] = sym_constraint_sentence,
  [sym_simple_sentence] = sym_simple_sentence,
  [sym_atomic_sentence] = sym_atomic_sentence,
  [sym_actual_arguments] = sym_actual_arguments,
  [sym_equation] = sym_equation,
  [sym_inequation] = sym_inequation,
  [sym_not_equal] = sym_not_equal,
  [sym_less_than_or_equal] = sym_less_than_or_equal,
  [sym_greater_than_or_equal] = sym_greater_than_or_equal,
  [sym_boolean_sentence] = sym_boolean_sentence,
  [sym_unary_boolean_sentence] = sym_unary_boolean_sentence,
  [sym_binary_boolean_sentence] = sym_binary_boolean_sentence,
  [sym_negation] = sym_negation,
  [sym__logical_connective] = sym__logical_connective,
  [sym_conjunction] = sym_conjunction,
  [sym_disjunction] = sym_disjunction,
  [sym_exclusive_disjunction] = sym_exclusive_disjunction,
  [sym_implication] = sym_implication,
  [sym_biconditional] = sym_biconditional,
  [sym_quantified_sentence] = sym_quantified_sentence,
  [sym_quantified_variable_binding] = sym_quantified_variable_binding,
  [sym_universal] = sym_universal,
  [sym_existential] = sym_existential,
  [sym_quantified_variable] = sym_quantified_variable,
  [sym_term] = sym_term,
  [sym_functional_term] = sym_functional_term,
  [sym_function_composition] = sym_function_composition,
  [sym_predicate_value] = sym_predicate_value,
  [sym_sequence_of_predicate_values] = sym_sequence_of_predicate_values,
  [sym_constraint_environment] = sym_constraint_environment,
  [sym_environment_def] = sym_environment_def,
  [sym_constraint_environment_end] = sym_constraint_environment_end,
  [sym_function_def] = sym_function_def,
  [sym_function_body] = sym_function_body,
  [sym__by_definition] = sym__by_definition,
  [sym_function_signature] = sym_function_signature,
  [sym_function_parameter] = sym_function_parameter,
  [sym__function_type] = sym__function_type,
  [sym_function_cardinality_expression] = sym_function_cardinality_expression,
  [sym_function_type_reference] = sym_function_type_reference,
  [sym_constant_def] = sym_constant_def,
  [sym_sequence_builder] = sym_sequence_builder,
  [sym_named_variable_set] = sym_named_variable_set,
  [sym_mapping_variable] = sym_mapping_variable,
  [sym_sequence_builder_body] = sym_sequence_builder_body,
  [sym_value] = sym_value,
  [sym_sequence_of_values] = sym_sequence_of_values,
  [sym__sequence_value_constraints] = sym__sequence_value_constraints,
  [sym_value_constructor] = sym_value_constructor,
  [sym_mapping_value] = sym_mapping_value,
  [sym_builtin_simple_type] = sym_builtin_simple_type,
  [sym_simple_value] = sym_simple_value,
  [sym_string] = sym_string,
  [sym_iri] = sym_iri,
  [sym_binary] = sym_binary,
  [sym_boolean] = sym_boolean,
  [sym_boolean_truth] = sym_boolean_truth,
  [sym_boolean_falsity] = sym_boolean_falsity,
  [sym_definition] = sym_definition,
  [sym_data_type_def] = sym_data_type_def,
  [sym__data_type_base] = sym__data_type_base,
  [sym_annotation_only_body] = sym_annotation_only_body,
  [sym_entity_def] = sym_entity_def,
  [sym_entity_body] = sym_entity_body,
  [sym_enum_def] = sym_enum_def,
  [sym_enum_body] = sym_enum_body,
  [sym_event_def] = sym_event_def,
  [sym_property_def] = sym_property_def,
  [sym_structure_def] = sym_structure_def,
  [sym_structured_body] = sym_structured_body,
  [sym_union_def] = sym_union_def,
  [sym_union_body] = sym_union_body,
  [sym_rdf_def] = sym_rdf_def,
  [sym_rdf_types] = sym_rdf_types,
  [sym_type_class_def] = sym_type_class_def,
  [sym_type_variable] = sym_type_variable,
  [sym__type_variable_restriction] = sym__type_variable_restriction,
  [sym_type_class_reference] = sym_type_class_reference,
  [sym_type_class_arguments] = sym_type_class_arguments,
  [sym_type_class_body] = sym_type_class_body,
  [sym_method_def] = sym_method_def,
  [sym_entity_identity] = sym_entity_identity,
  [sym_member] = sym_member,
  [sym_member_def] = sym_member_def,
  [sym_property_ref] = sym_property_ref,
  [sym__type_expression_to] = sym__type_expression_to,
  [sym_type_reference] = sym_type_reference,
  [sym_mapping_type] = sym_mapping_type,
  [sym_cardinality_expression] = sym_cardinality_expression,
  [sym__cardinality_inner] = sym__cardinality_inner,
  [sym_sequence_ordering] = sym_sequence_ordering,
  [sym_sequence_uniqueness] = sym_sequence_uniqueness,
  [sym_cardinality_range] = sym_cardinality_range,
  [sym__has_type] = sym__has_type,
  [sym__type_restriction] = sym__type_restriction,
  [sym_value_variant] = sym_value_variant,
  [sym_type_variant] = sym_type_variant,
  [aux_sym_module_body_repeat1] = aux_sym_module_body_repeat1,
  [aux_sym_module_body_repeat2] = aux_sym_module_body_repeat2,
  [aux_sym_module_body_repeat3] = aux_sym_module_body_repeat3,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym_actual_arguments_repeat1] = aux_sym_actual_arguments_repeat1,
  [aux_sym_function_composition_repeat1] = aux_sym_function_composition_repeat1,
  [aux_sym_sequence_of_predicate_values_repeat1] = aux_sym_sequence_of_predicate_values_repeat1,
  [aux_sym_constraint_environment_repeat1] = aux_sym_constraint_environment_repeat1,
  [aux_sym_function_signature_repeat1] = aux_sym_function_signature_repeat1,
  [aux_sym_named_variable_set_repeat1] = aux_sym_named_variable_set_repeat1,
  [aux_sym_sequence_of_values_repeat1] = aux_sym_sequence_of_values_repeat1,
  [aux_sym_binary_repeat1] = aux_sym_binary_repeat1,
  [aux_sym_entity_body_repeat1] = aux_sym_entity_body_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_union_body_repeat1] = aux_sym_union_body_repeat1,
  [aux_sym_rdf_types_repeat1] = aux_sym_rdf_types_repeat1,
  [aux_sym_type_class_def_repeat1] = aux_sym_type_class_def_repeat1,
  [aux_sym__type_variable_restriction_repeat1] = aux_sym__type_variable_restriction_repeat1,
  [aux_sym_type_class_arguments_repeat1] = aux_sym_type_class_arguments_repeat1,
  [aux_sym_type_class_body_repeat1] = aux_sym_type_class_body_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_version] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [sym_controlled_language_tag] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2260] = {
    .visible = true,
    .named = false,
  },
  [sym_less_than] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2264] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2265] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u00ac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2227] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2228] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22bb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21d2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iff] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21d4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2200] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2203] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2208] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2205] = {
    .visible = true,
    .named = false,
  },
  [sym_reserved_self] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2254] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_optional] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_integer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_decimal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [sym_quoted_string] = {
    .visible = true,
    .named = true,
  },
  [sym_language_tag] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_iri_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_hex_byte] = {
    .visible = true,
    .named = true,
  },
  [sym_double] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_unsigned] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22a4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22a5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_datatype] = {
    .visible = true,
    .named = false,
  },
  [sym_opaque] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_entity] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_source] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_structure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rdf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_identity] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref] = {
    .visible = true,
    .named = false,
  },
  [sym_unknown_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ordered] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unordered] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonunique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2192] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2190] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module_locations] = {
    .visible = false,
    .named = true,
  },
  [sym_module_body] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import] = {
    .visible = false,
    .named = true,
  },
  [sym_member_import] = {
    .visible = true,
    .named = true,
  },
  [sym_module_import] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_property] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_informal_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_atomic_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_actual_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_equation] = {
    .visible = true,
    .named = true,
  },
  [sym_inequation] = {
    .visible = true,
    .named = true,
  },
  [sym_not_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_less_than_or_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than_or_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_boolean_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_boolean_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_negation] = {
    .visible = true,
    .named = true,
  },
  [sym__logical_connective] = {
    .visible = false,
    .named = true,
  },
  [sym_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_exclusive_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_implication] = {
    .visible = true,
    .named = true,
  },
  [sym_biconditional] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified_variable_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_universal] = {
    .visible = true,
    .named = true,
  },
  [sym_existential] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_functional_term] = {
    .visible = true,
    .named = true,
  },
  [sym_function_composition] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate_value] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_of_predicate_values] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_environment] = {
    .visible = true,
    .named = true,
  },
  [sym_environment_def] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym__by_definition] = {
    .visible = false,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__function_type] = {
    .visible = false,
    .named = true,
  },
  [sym_function_cardinality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_def] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_builder] = {
    .visible = true,
    .named = true,
  },
  [sym_named_variable_set] = {
    .visible = true,
    .named = true,
  },
  [sym_mapping_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_builder_body] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_of_values] = {
    .visible = true,
    .named = true,
  },
  [sym__sequence_value_constraints] = {
    .visible = false,
    .named = true,
  },
  [sym_value_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_mapping_value] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_simple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_value] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_iri] = {
    .visible = true,
    .named = true,
  },
  [sym_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_truth] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_falsity] = {
    .visible = true,
    .named = true,
  },
  [sym_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_data_type_def] = {
    .visible = true,
    .named = true,
  },
  [sym__data_type_base] = {
    .visible = false,
    .named = true,
  },
  [sym_annotation_only_body] = {
    .visible = true,
    .named = true,
  },
  [sym_entity_def] = {
    .visible = true,
    .named = true,
  },
  [sym_entity_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_def] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_event_def] = {
    .visible = true,
    .named = true,
  },
  [sym_property_def] = {
    .visible = true,
    .named = true,
  },
  [sym_structure_def] = {
    .visible = true,
    .named = true,
  },
  [sym_structured_body] = {
    .visible = true,
    .named = true,
  },
  [sym_union_def] = {
    .visible = true,
    .named = true,
  },
  [sym_union_body] = {
    .visible = true,
    .named = true,
  },
  [sym_rdf_def] = {
    .visible = true,
    .named = true,
  },
  [sym_rdf_types] = {
    .visible = true,
    .named = true,
  },
  [sym_type_class_def] = {
    .visible = true,
    .named = true,
  },
  [sym_type_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__type_variable_restriction] = {
    .visible = false,
    .named = true,
  },
  [sym_type_class_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_type_class_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_type_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_method_def] = {
    .visible = true,
    .named = true,
  },
  [sym_entity_identity] = {
    .visible = true,
    .named = true,
  },
  [sym_member] = {
    .visible = true,
    .named = true,
  },
  [sym_member_def] = {
    .visible = true,
    .named = true,
  },
  [sym_property_ref] = {
    .visible = true,
    .named = true,
  },
  [sym__type_expression_to] = {
    .visible = false,
    .named = true,
  },
  [sym_type_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_mapping_type] = {
    .visible = true,
    .named = true,
  },
  [sym_cardinality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__cardinality_inner] = {
    .visible = false,
    .named = true,
  },
  [sym_sequence_ordering] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_uniqueness] = {
    .visible = true,
    .named = true,
  },
  [sym_cardinality_range] = {
    .visible = true,
    .named = true,
  },
  [sym__has_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_restriction] = {
    .visible = false,
    .named = true,
  },
  [sym_value_variant] = {
    .visible = true,
    .named = true,
  },
  [sym_type_variant] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_actual_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_composition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_of_predicate_values_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constraint_environment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_signature_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_variable_set_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_of_values_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_binary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_entity_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_rdf_types_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_class_def_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_variable_restriction_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_class_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_argument = 1,
  field_arguments = 2,
  field_base = 3,
  field_binding = 4,
  field_body = 5,
  field_byte = 6,
  field_cardinality = 7,
  field_domain = 8,
  field_element = 9,
  field_empty = 10,
  field_environment = 11,
  field_function = 12,
  field_identity = 13,
  field_language = 14,
  field_lhs = 15,
  field_max = 16,
  field_member = 17,
  field_method = 18,
  field_min = 19,
  field_module = 20,
  field_name = 21,
  field_opaque = 22,
  field_operator = 23,
  field_optional = 24,
  field_ordering = 25,
  field_parameter = 26,
  field_predicate = 27,
  field_property = 28,
  field_quantifier = 29,
  field_range = 30,
  field_relation = 31,
  field_rename = 32,
  field_rhs = 33,
  field_signature = 34,
  field_source = 35,
  field_subject = 36,
  field_target = 37,
  field_type = 38,
  field_types = 39,
  field_uniqueness = 40,
  field_value = 41,
  field_variable = 42,
  field_version_info = 43,
  field_version_uri = 44,
  field_wildcard = 45,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_base] = "base",
  [field_binding] = "binding",
  [field_body] = "body",
  [field_byte] = "byte",
  [field_cardinality] = "cardinality",
  [field_domain] = "domain",
  [field_element] = "element",
  [field_empty] = "empty",
  [field_environment] = "environment",
  [field_function] = "function",
  [field_identity] = "identity",
  [field_language] = "language",
  [field_lhs] = "lhs",
  [field_max] = "max",
  [field_member] = "member",
  [field_method] = "method",
  [field_min] = "min",
  [field_module] = "module",
  [field_name] = "name",
  [field_opaque] = "opaque",
  [field_operator] = "operator",
  [field_optional] = "optional",
  [field_ordering] = "ordering",
  [field_parameter] = "parameter",
  [field_predicate] = "predicate",
  [field_property] = "property",
  [field_quantifier] = "quantifier",
  [field_range] = "range",
  [field_relation] = "relation",
  [field_rename] = "rename",
  [field_rhs] = "rhs",
  [field_signature] = "signature",
  [field_source] = "source",
  [field_subject] = "subject",
  [field_target] = "target",
  [field_type] = "type",
  [field_types] = "types",
  [field_uniqueness] = "uniqueness",
  [field_value] = "value",
  [field_variable] = "variable",
  [field_version_info] = "version_info",
  [field_version_uri] = "version_uri",
  [field_wildcard] = "wildcard",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 5},
  [4] = {.index = 8, .length = 1},
  [5] = {.index = 9, .length = 1},
  [6] = {.index = 10, .length = 1},
  [7] = {.index = 11, .length = 2},
  [8] = {.index = 13, .length = 2},
  [9] = {.index = 15, .length = 3},
  [10] = {.index = 18, .length = 3},
  [11] = {.index = 21, .length = 2},
  [12] = {.index = 23, .length = 1},
  [13] = {.index = 24, .length = 2},
  [14] = {.index = 26, .length = 1},
  [15] = {.index = 27, .length = 2},
  [16] = {.index = 29, .length = 2},
  [17] = {.index = 31, .length = 4},
  [18] = {.index = 35, .length = 1},
  [19] = {.index = 36, .length = 1},
  [20] = {.index = 37, .length = 3},
  [21] = {.index = 40, .length = 1},
  [22] = {.index = 41, .length = 1},
  [23] = {.index = 42, .length = 1},
  [24] = {.index = 43, .length = 1},
  [25] = {.index = 44, .length = 2},
  [26] = {.index = 46, .length = 1},
  [27] = {.index = 47, .length = 2},
  [28] = {.index = 49, .length = 1},
  [29] = {.index = 50, .length = 2},
  [30] = {.index = 52, .length = 1},
  [31] = {.index = 53, .length = 1},
  [32] = {.index = 54, .length = 2},
  [33] = {.index = 56, .length = 3},
  [34] = {.index = 59, .length = 3},
  [35] = {.index = 62, .length = 1},
  [36] = {.index = 63, .length = 2},
  [37] = {.index = 65, .length = 3},
  [38] = {.index = 68, .length = 1},
  [39] = {.index = 69, .length = 2},
  [40] = {.index = 71, .length = 1},
  [41] = {.index = 72, .length = 1},
  [42] = {.index = 73, .length = 2},
  [43] = {.index = 75, .length = 2},
  [44] = {.index = 77, .length = 2},
  [45] = {.index = 79, .length = 1},
  [46] = {.index = 80, .length = 2},
  [47] = {.index = 82, .length = 1},
  [48] = {.index = 83, .length = 1},
  [49] = {.index = 84, .length = 1},
  [50] = {.index = 85, .length = 2},
  [51] = {.index = 87, .length = 2},
  [52] = {.index = 89, .length = 2},
  [53] = {.index = 91, .length = 2},
  [54] = {.index = 93, .length = 2},
  [55] = {.index = 95, .length = 3},
  [56] = {.index = 98, .length = 2},
  [57] = {.index = 100, .length = 2},
  [58] = {.index = 102, .length = 1},
  [59] = {.index = 103, .length = 3},
  [60] = {.index = 106, .length = 2},
  [61] = {.index = 108, .length = 4},
  [62] = {.index = 112, .length = 1},
  [63] = {.index = 113, .length = 2},
  [64] = {.index = 115, .length = 2},
  [65] = {.index = 117, .length = 2},
  [66] = {.index = 119, .length = 1},
  [67] = {.index = 120, .length = 2},
  [68] = {.index = 122, .length = 3},
  [69] = {.index = 125, .length = 2},
  [70] = {.index = 127, .length = 2},
  [71] = {.index = 129, .length = 3},
  [72] = {.index = 132, .length = 1},
  [73] = {.index = 133, .length = 2},
  [74] = {.index = 135, .length = 2},
  [75] = {.index = 137, .length = 1},
  [76] = {.index = 138, .length = 2},
  [77] = {.index = 140, .length = 1},
  [78] = {.index = 141, .length = 3},
  [79] = {.index = 144, .length = 3},
  [80] = {.index = 147, .length = 3},
  [81] = {.index = 150, .length = 2},
  [82] = {.index = 152, .length = 1},
  [83] = {.index = 153, .length = 2},
  [84] = {.index = 155, .length = 1},
  [85] = {.index = 156, .length = 2},
  [86] = {.index = 158, .length = 2},
  [87] = {.index = 160, .length = 4},
  [88] = {.index = 164, .length = 1},
  [89] = {.index = 165, .length = 2},
  [90] = {.index = 167, .length = 3},
  [91] = {.index = 170, .length = 1},
  [92] = {.index = 171, .length = 1},
  [93] = {.index = 172, .length = 2},
  [94] = {.index = 174, .length = 1},
  [95] = {.index = 175, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 2},
    {field_name, 1},
  [2] =
    {field_base, 0},
  [3] =
    {field_base, 2, .inherited = true},
    {field_body, 3},
    {field_name, 1},
    {field_version_info, 2, .inherited = true},
    {field_version_uri, 2, .inherited = true},
  [8] =
    {field_name, 0},
  [9] =
    {field_name, 1},
  [10] =
    {field_member, 1},
  [11] =
    {field_base, 0},
    {field_version_uri, 2},
  [13] =
    {field_name, 0},
    {field_version_uri, 1},
  [15] =
    {field_cardinality, 1, .inherited = true},
    {field_name, 0},
    {field_target, 1, .inherited = true},
  [18] =
    {field_base, 0},
    {field_version_info, 2},
    {field_version_uri, 3},
  [21] =
    {field_member, 2},
    {field_module, 0},
  [23] =
    {field_empty, 0},
  [24] =
    {field_name, 1},
    {field_value, 3},
  [26] =
    {field_value, 1},
  [27] =
    {field_base, 3},
    {field_name, 1},
  [29] =
    {field_name, 1},
    {field_source, 3},
  [31] =
    {field_body, 2},
    {field_cardinality, 1, .inherited = true},
    {field_name, 0},
    {field_target, 1, .inherited = true},
  [35] =
    {field_target, 1},
  [36] =
    {field_type, 1},
  [37] =
    {field_body, 3},
    {field_name, 1},
    {field_types, 2},
  [40] =
    {field_variable, 0},
  [41] =
    {field_element, 0},
  [42] =
    {field_language, 1},
  [43] =
    {field_byte, 0},
  [44] =
    {field_name, 1, .inherited = true},
    {field_subject, 0},
  [46] =
    {field_body, 1},
  [47] =
    {field_operator, 0},
    {field_rhs, 1},
  [49] =
    {field_source, 0},
  [50] =
    {field_binding, 1},
    {field_quantifier, 0},
  [52] =
    {field_predicate, 0},
  [53] =
    {field_function, 0},
  [54] =
    {field_language, 2},
    {field_value, 1},
  [56] =
    {field_base, 4},
    {field_name, 1},
    {field_opaque, 3},
  [59] =
    {field_base, 3},
    {field_body, 4},
    {field_name, 1},
  [62] =
    {field_identity, 1},
  [63] =
    {field_body, 1},
    {field_name, 0},
  [65] =
    {field_body, 4},
    {field_name, 1},
    {field_source, 3},
  [68] =
    {field_min, 0},
  [69] =
    {field_cardinality, 1},
    {field_target, 2},
  [71] =
    {field_property, 1},
  [72] =
    {field_type, 0},
  [73] =
    {field_cardinality, 0},
    {field_name, 1},
  [75] =
    {field_name, 1},
    {field_variable, 3, .inherited = true},
  [77] =
    {field_variable, 0, .inherited = true},
    {field_variable, 1, .inherited = true},
  [79] =
    {field_element, 1, .inherited = true},
  [80] =
    {field_element, 0, .inherited = true},
    {field_element, 1, .inherited = true},
  [82] =
    {field_ordering, 1},
  [83] =
    {field_uniqueness, 1},
  [84] =
    {field_byte, 1, .inherited = true},
  [85] =
    {field_byte, 0, .inherited = true},
    {field_byte, 1, .inherited = true},
  [87] =
    {field_ordering, 0, .inherited = true},
    {field_uniqueness, 0, .inherited = true},
  [89] =
    {field_domain, 0},
    {field_range, 2},
  [91] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [93] =
    {field_cardinality, 0, .inherited = true},
    {field_target, 0, .inherited = true},
  [95] =
    {field_lhs, 0},
    {field_operator, 1},
    {field_rhs, 2},
  [98] =
    {field_binding, 0},
    {field_body, 2},
  [100] =
    {field_lhs, 0},
    {field_rhs, 2},
  [102] =
    {field_argument, 0},
  [103] =
    {field_lhs, 0},
    {field_relation, 1},
    {field_rhs, 2},
  [106] =
    {field_body, 2},
    {field_environment, 1},
  [108] =
    {field_base, 4},
    {field_body, 5},
    {field_name, 1},
    {field_opaque, 3},
  [112] =
    {field_identity, 2},
  [113] =
    {field_min, 0},
    {field_range, 1},
  [115] =
    {field_min, 1, .inherited = true},
    {field_range, 1, .inherited = true},
  [117] =
    {field_name, 0},
    {field_rename, 2},
  [119] =
    {field_type, 2, .inherited = true},
  [120] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [122] =
    {field_body, 5},
    {field_name, 1},
    {field_variable, 3, .inherited = true},
  [125] =
    {field_ordering, 1},
    {field_uniqueness, 2},
  [127] =
    {field_name, 0},
    {field_value, 2},
  [129] =
    {field_element, 2, .inherited = true},
    {field_ordering, 0, .inherited = true},
    {field_uniqueness, 0, .inherited = true},
  [132] =
    {field_parameter, 0},
  [133] =
    {field_body, 1},
    {field_signature, 0},
  [135] =
    {field_name, 0},
    {field_source, 2},
  [137] =
    {field_argument, 1, .inherited = true},
  [138] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [140] =
    {field_max, 1},
  [141] =
    {field_min, 2, .inherited = true},
    {field_ordering, 1},
    {field_range, 2, .inherited = true},
  [144] =
    {field_min, 2, .inherited = true},
    {field_range, 2, .inherited = true},
    {field_uniqueness, 1},
  [147] =
    {field_body, 3},
    {field_name, 0},
    {field_rename, 2},
  [150] =
    {field_arguments, 1},
    {field_name, 0},
  [152] =
    {field_method, 0},
  [153] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [155] =
    {field_optional, 0},
  [156] =
    {field_body, 3},
    {field_variable, 1},
  [158] =
    {field_domain, 1},
    {field_range, 3},
  [160] =
    {field_min, 3, .inherited = true},
    {field_ordering, 1},
    {field_range, 3, .inherited = true},
    {field_uniqueness, 2},
  [164] =
    {field_method, 1, .inherited = true},
  [165] =
    {field_method, 0, .inherited = true},
    {field_method, 1, .inherited = true},
  [167] =
    {field_cardinality, 3, .inherited = true},
    {field_parameter, 1, .inherited = true},
    {field_target, 3, .inherited = true},
  [170] =
    {field_wildcard, 1},
  [171] =
    {field_variable, 1, .inherited = true},
  [172] =
    {field_name, 1},
    {field_signature, 2},
  [174] =
    {field_method, 2, .inherited = true},
  [175] =
    {field_body, 3},
    {field_name, 1},
    {field_signature, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 21,
  [23] = 23,
  [24] = 24,
  [25] = 23,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 32,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 40,
  [47] = 47,
  [48] = 43,
  [49] = 39,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 56,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 11,
  [89] = 89,
  [90] = 13,
  [91] = 10,
  [92] = 15,
  [93] = 93,
  [94] = 16,
  [95] = 14,
  [96] = 18,
  [97] = 19,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 20,
  [102] = 27,
  [103] = 12,
  [104] = 17,
  [105] = 44,
  [106] = 106,
  [107] = 31,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 37,
  [112] = 112,
  [113] = 38,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 116,
  [119] = 119,
  [120] = 65,
  [121] = 121,
  [122] = 59,
  [123] = 55,
  [124] = 124,
  [125] = 52,
  [126] = 62,
  [127] = 127,
  [128] = 61,
  [129] = 58,
  [130] = 130,
  [131] = 68,
  [132] = 132,
  [133] = 112,
  [134] = 64,
  [135] = 135,
  [136] = 60,
  [137] = 63,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 57,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 197,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 229,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 68,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 322,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 334,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 417,
  [428] = 402,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 393,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 414,
  [440] = 440,
  [441] = 440,
  [442] = 422,
  [443] = 443,
  [444] = 397,
  [445] = 445,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'A', 'Z'}, {'a', 'z'}, {0xb5, 0xb5}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x1ba}, {0x1bc, 0x1bf}, {0x1c4, 0x1c4},
  {0x1c6, 0x1c7}, {0x1c9, 0x1ca}, {0x1cc, 0x1f1}, {0x1f3, 0x293}, {0x295, 0x2af}, {0x370, 0x373}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x560, 0x588}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, {0x1e00, 0x1f15},
  {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d},
  {0x1f80, 0x1f87}, {0x1f90, 0x1f97}, {0x1fa0, 0x1fa7}, {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fbb}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcb},
  {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffb}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2119, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x212d}, {0x212f, 0x2134}, {0x2139, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2183, 0x2184}, {0x2c00, 0x2c7b}, {0x2c7e, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3},
  {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0xa640, 0xa66d}, {0xa680, 0xa69b}, {0xa722, 0xa76f}, {0xa771, 0xa787}, {0xa78b, 0xa78e},
  {0xa790, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f5, 0xa7f6}, {0xa7fa, 0xa7fa}, {0xab30, 0xab5a}, {0xab60, 0xab68},
  {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0x10400, 0x1044f}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xb5, 0xb5}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x1ba},
  {0x1bc, 0x1bf}, {0x1c4, 0x1c4}, {0x1c6, 0x1c7}, {0x1c9, 0x1ca}, {0x1cc, 0x1f1}, {0x1f3, 0x293}, {0x295, 0x2af}, {0x370, 0x373},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5},
  {0x3f7, 0x481}, {0x48a, 0x52f}, {0x531, 0x556}, {0x560, 0x588}, {0x660, 0x669}, {0x6f0, 0x6f9}, {0x7c0, 0x7c9}, {0x966, 0x96f},
  {0x9e6, 0x9ef}, {0xa66, 0xa6f}, {0xae6, 0xaef}, {0xb66, 0xb6f}, {0xbe6, 0xbef}, {0xc66, 0xc6f}, {0xce6, 0xcef}, {0xd66, 0xd6f},
  {0xde6, 0xdef}, {0xe50, 0xe59}, {0xed0, 0xed9}, {0xf20, 0xf29}, {0x1040, 0x1049}, {0x1090, 0x1099}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7},
  {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x17e0, 0x17e9}, {0x1810, 0x1819}, {0x1946, 0x194f},
  {0x19d0, 0x19d9}, {0x1a80, 0x1a89}, {0x1a90, 0x1a99}, {0x1b50, 0x1b59}, {0x1bb0, 0x1bb9}, {0x1c40, 0x1c49}, {0x1c50, 0x1c59}, {0x1c80, 0x1c88},
  {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45},
  {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1f87}, {0x1f90, 0x1f97},
  {0x1fa0, 0x1fa7}, {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fbb}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcb}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb},
  {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffb}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2119, 0x211d},
  {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x212d}, {0x212f, 0x2134}, {0x2139, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2183, 0x2184}, {0x2c00, 0x2c7b}, {0x2c7e, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27},
  {0x2d2d, 0x2d2d}, {0xa620, 0xa629}, {0xa640, 0xa66d}, {0xa680, 0xa69b}, {0xa722, 0xa76f}, {0xa771, 0xa787}, {0xa78b, 0xa78e}, {0xa790, 0xa7ca},
  {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f5, 0xa7f6}, {0xa7fa, 0xa7fa}, {0xa8d0, 0xa8d9}, {0xa900, 0xa909}, {0xa9d0, 0xa9d9},
  {0xa9f0, 0xa9f9}, {0xaa50, 0xaa59}, {0xab30, 0xab5a}, {0xab60, 0xab68}, {0xab70, 0xabbf}, {0xabf0, 0xabf9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17},
  {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0x10400, 0x1044f}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10570, 0x1057a},
  {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(66);
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '+', 156,
        ',', 107,
        '-', 12,
        '.', 112,
        '/', 19,
        '0', 150,
        ':', 71,
        ';', 172,
        '<', 92,
        '=', 76,
        '>', 94,
        '?', 118,
        '@', 73,
        '[', 67,
        '\\', 13,
        ']', 68,
        '_', 157,
        '{', 116,
        '|', 119,
        '}', 117,
        0xac, 99,
        0x2190, 161,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2200, 108,
        0x2203, 109,
        0x2205, 113,
        0x2208, 110,
        0x2227, 100,
        0x2228, 101,
        0x2254, 115,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22a4, 153,
        0x22a5, 154,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(149);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '-', 12,
        '.', 111,
        '0', 147,
        ':', 71,
        ';', 172,
        '<', 136,
        '=', 75,
        '>', 140,
        '?', 118,
        '@', 72,
        '[', 67,
        ']', 68,
        '_', 157,
        '{', 116,
        '|', 119,
        '}', 117,
        0xac, 99,
        0x2192, 159,
        0x2200, 108,
        0x2203, 109,
        0x2205, 113,
        0x2208, 110,
        0x2254, 115,
        0x22a4, 153,
        0x22a5, 154,
        '+', 13,
        '\\', 13,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '-', 12,
        '0', 147,
        ':', 20,
        ';', 172,
        '<', 136,
        '=', 75,
        '?', 118,
        '@', 72,
        '[', 67,
        ']', 68,
        '_', 157,
        '{', 116,
        '|', 119,
        '}', 117,
        0xac, 99,
        0x2192, 159,
        0x2200, 108,
        0x2203, 109,
        0x2205, 113,
        0x2208, 110,
        0x2254, 115,
        0x22a4, 153,
        0x22a5, 154,
        '+', 13,
        '\\', 13,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '-', 12,
        '0', 147,
        ';', 172,
        '<', 136,
        '@', 61,
        '[', 67,
        ']', 68,
        '{', 116,
        0x2192, 159,
        0x2205, 113,
        0x22a4, 153,
        0x22a5, 154,
        '+', 13,
        '\\', 13,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '-', 12,
        '0', 147,
        ';', 172,
        '<', 136,
        '[', 67,
        ']', 68,
        '{', 116,
        0x2192, 159,
        0x2205, 113,
        0x22a4, 153,
        0x22a5, 154,
        '+', 13,
        '\\', 13,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(120);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead > 0x08 &&
          (lookahead < 0x0b || 0x1f < lookahead) &&
          lookahead != 0x7f) ADVANCE(5);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '(', 88,
        ')', 89,
        '+', 155,
        ',', 107,
        '-', 21,
        '.', 111,
        '/', 19,
        '0', 151,
        ':', 71,
        ';', 172,
        '<', 93,
        '=', 76,
        '>', 94,
        '@', 72,
        ']', 68,
        '{', 116,
        '}', 117,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2227, 100,
        0x2228, 101,
        0x2254, 115,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(152);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '(', 88,
        ')', 89,
        '+', 155,
        ',', 107,
        '-', 21,
        '/', 19,
        '0', 151,
        ':', 20,
        ';', 172,
        '<', 93,
        '=', 76,
        '>', 94,
        '@', 72,
        ']', 68,
        '{', 116,
        '}', 117,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2227, 100,
        0x2228, 101,
        0x2254, 115,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(152);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '(', 88,
        ')', 89,
        ',', 107,
        '-', 21,
        '.', 11,
        '/', 19,
        ';', 172,
        '<', 93,
        '=', 76,
        '>', 94,
        '@', 72,
        '}', 117,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2227, 100,
        0x2228, 101,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '(', 88,
        ')', 89,
        ',', 107,
        '-', 21,
        '.', 11,
        '/', 19,
        ';', 172,
        '<', 93,
        '=', 76,
        '>', 94,
        '@', 74,
        '}', 117,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2227, 100,
        0x2228, 101,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 10:
      if (lookahead == '-') ADVANCE(162);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(158);
      END_STATE();
    case 12:
      if (lookahead == '0') ADVANCE(147);
      if (lookahead == '>') ADVANCE(160);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 13:
      if (lookahead == '0') ADVANCE(147);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 14:
      if (lookahead == '0') ADVANCE(144);
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '\\') ADVANCE(15);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(145);
      END_STATE();
    case 15:
      if (lookahead == '0') ADVANCE(144);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(145);
      END_STATE();
    case 16:
      if (lookahead == ';') ADVANCE(172);
      if (lookahead == '<') ADVANCE(10);
      if (lookahead == '@') ADVANCE(73);
      if (lookahead == 0x2190) ADVANCE(161);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 17:
      if (lookahead == ';') ADVANCE(172);
      if (lookahead == '<') ADVANCE(10);
      if (lookahead == '@') ADVANCE(72);
      if (lookahead == 0x2190) ADVANCE(161);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 18:
      if (lookahead == ';') ADVANCE(172);
      if (lookahead == ']') ADVANCE(68);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(18);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(90);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 21:
      if (lookahead == '>') ADVANCE(160);
      END_STATE();
    case 22:
      if (lookahead == '>') ADVANCE(103);
      END_STATE();
    case 23:
      if (lookahead == '>') ADVANCE(105);
      END_STATE();
    case 24:
      if (lookahead == 'U') ADVANCE(52);
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 25:
      if (lookahead == '[') ADVANCE(141);
      END_STATE();
    case 26:
      if (lookahead == '_') ADVANCE(26);
      if (set_contains(sym_identifier_character_set_2, 151, lookahead)) ADVANCE(70);
      END_STATE();
    case 27:
      ADVANCE_MAP(
        'u', 28,
        '"', 5,
        '/', 5,
        '\\', 5,
        'a', 5,
        'b', 5,
        'e', 5,
        'f', 5,
        'n', 5,
        'r', 5,
        't', 5,
        'v', 5,
      );
      END_STATE();
    case 28:
      if (lookahead == '{') ADVANCE(45);
      END_STATE();
    case 29:
      if (lookahead == '}') ADVANCE(5);
      END_STATE();
    case 30:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 31:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(30);
      END_STATE();
    case 32:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 33:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(32);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(54);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(55);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(56);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(57);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(58);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(35);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(142);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(138);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 53:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(64);
      END_STATE();
    case 54:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(133);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 55:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(121);
      END_STATE();
    case 56:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(121);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 57:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(134);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 58:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(135);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 59:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(79);
      END_STATE();
    case 60:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 61:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 62:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 63:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 64:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 65:
      if (eof) ADVANCE(66);
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '+', 156,
        ',', 107,
        '-', 12,
        '.', 11,
        '/', 19,
        '0', 150,
        ':', 20,
        ';', 172,
        '<', 92,
        '=', 76,
        '>', 94,
        '?', 118,
        '@', 72,
        '[', 67,
        '\\', 13,
        ']', 68,
        '_', 157,
        '{', 116,
        '|', 119,
        '}', 117,
        0xac, 99,
        0x2190, 161,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2200, 108,
        0x2203, 109,
        0x2205, 113,
        0x2208, 110,
        0x2227, 100,
        0x2228, 101,
        0x2254, 115,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22a4, 153,
        0x22a5, 154,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(149);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      if (set_contains(sym_identifier_character_set_2, 151, lookahead)) ADVANCE(70);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(26);
      if (set_contains(sym_identifier_character_set_2, 151, lookahead)) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_AT);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(59);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_AT);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(22);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (lookahead == '-') ADVANCE(53);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (lookahead == '-') ADVANCE(53);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(78);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(77);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(80);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(81);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(85);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_u2260);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_less_than);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_less_than);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_greater_than);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '=') ADVANCE(23);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_u2264);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_u2265);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_u00ac);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_u2227);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_u2228);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_u22bb);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_GT);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_u21d2);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LT_EQ_EQ_GT);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_u21d4);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_u2200);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_u2203);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_u2208);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(158);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_u2205);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_u2254);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_optional);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_quoted_string);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_language_tag);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(128);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(123);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(124);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(125);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(37);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(38);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(39);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(40);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(132);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(130);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(131);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_iri_token1);
      if (lookahead == ';') ADVANCE(139);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead > ' ' &&
          lookahead != '"' &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(138);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_iri_token1);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead > ' ' &&
          lookahead != '"' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_iri_token1);
      if (lookahead == '\\') ADVANCE(163);
      if ((!eof && lookahead <= '\t') ||
          (0x0b <= lookahead && lookahead <= ' ') ||
          lookahead == '"' ||
          lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '^' ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(172);
      if (lookahead > ' ') ADVANCE(139);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_POUND_LBRACK);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_hex_byte);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_hex_byte);
      if (lookahead == '.') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_double);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_double);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(145);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_decimal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(34);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(142);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(142);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_unsigned);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_unsigned);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(152);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_u22a4);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_u22a5);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '0') ADVANCE(147);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_wildcard);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_u2192);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_u2190);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == 'U') ADVANCE(171);
      if (lookahead == 'u') ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(139);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(169);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'i', 7,
        'm', 8,
        'n', 9,
        'o', 10,
        'p', 11,
        'r', 12,
        's', 13,
        't', 14,
        'u', 15,
        'v', 16,
        'x', 17,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(18);
      if (lookahead == 's') ADVANCE(19);
      END_STATE();
    case 2:
      if (lookahead == 'i') ADVANCE(20);
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'l') ADVANCE(22);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(23);
      if (lookahead == 'e') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead == 'v') ADVANCE(27);
      if (lookahead == 'x') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 7:
      if (lookahead == 'd') ADVANCE(31);
      if (lookahead == 'f') ADVANCE(32);
      if (lookahead == 'm') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 'r') ADVANCE(35);
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == 'f') ADVANCE(39);
      if (lookahead == 'p') ADVANCE(40);
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 12:
      if (lookahead == 'd') ADVANCE(43);
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 'o') ADVANCE(46);
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(48);
      if (lookahead == 'y') ADVANCE(49);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(50);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 17:
      if (lookahead == 'o') ADVANCE(52);
      END_STATE();
    case 18:
      if (lookahead == 'd') ADVANCE(53);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(54);
      END_STATE();
    case 20:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 21:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(57);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 24:
      if (lookahead == 'c') ADVANCE(59);
      if (lookahead == 'f') ADVANCE(60);
      END_STATE();
    case 25:
      if (lookahead == 'u') ADVANCE(61);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(62);
      if (lookahead == 't') ADVANCE(63);
      if (lookahead == 'u') ADVANCE(64);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 28:
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(67);
      END_STATE();
    case 30:
      if (lookahead == 'r') ADVANCE(68);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 32:
      if (lookahead == 'f') ADVANCE(70);
      END_STATE();
    case 33:
      if (lookahead == 'p') ADVANCE(71);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 't') ADVANCE(72);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(73);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 37:
      if (lookahead == 'd') ADVANCE(74);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(75);
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 40:
      if (lookahead == 'a') ADVANCE(77);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'd') ADVANCE(78);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(80);
      END_STATE();
    case 44:
      if (lookahead == 'f') ADVANCE(81);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(82);
      END_STATE();
    case 46:
      if (lookahead == 'u') ADVANCE(83);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(84);
      END_STATE();
    case 48:
      if (lookahead == 'u') ADVANCE(85);
      END_STATE();
    case 49:
      if (lookahead == 'p') ADVANCE(86);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 'k') ADVANCE(88);
      if (lookahead == 'o') ADVANCE(89);
      if (lookahead == 's') ADVANCE(90);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(91);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(92);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(94);
      END_STATE();
    case 56:
      if (lookahead == 'l') ADVANCE(95);
      END_STATE();
    case 57:
      if (lookahead == 's') ADVANCE(96);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(97);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 61:
      if (lookahead == 'b') ADVANCE(99);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(100);
      END_STATE();
    case 64:
      if (lookahead == 'm') ADVANCE(101);
      END_STATE();
    case 65:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 66:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 67:
      if (lookahead == 's') ADVANCE(104);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(105);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_iff);
      END_STATE();
    case 71:
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'o') ADVANCE(108);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_iri);
      END_STATE();
    case 74:
      if (lookahead == 'u') ADVANCE(110);
      END_STATE();
    case 75:
      if (lookahead == 'u') ADVANCE(111);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 77:
      if (lookahead == 'q') ADVANCE(112);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 79:
      if (lookahead == 'p') ADVANCE(114);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_rdf);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_ref);
      END_STATE();
    case 82:
      if (lookahead == 'f') ADVANCE(115);
      END_STATE();
    case 83:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 84:
      if (lookahead == 'i') ADVANCE(117);
      if (lookahead == 'u') ADVANCE(118);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(121);
      if (lookahead == 'q') ADVANCE(122);
      END_STATE();
    case 88:
      if (lookahead == 'n') ADVANCE(123);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 90:
      if (lookahead == 'i') ADVANCE(125);
      END_STATE();
    case 91:
      if (lookahead == 's') ADVANCE(126);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_xor);
      END_STATE();
    case 93:
      if (lookahead == 'r') ADVANCE(127);
      END_STATE();
    case 94:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(129);
      END_STATE();
    case 96:
      if (lookahead == 's') ADVANCE(130);
      END_STATE();
    case 97:
      if (lookahead == 't') ADVANCE(131);
      END_STATE();
    case 98:
      if (lookahead == 'm') ADVANCE(132);
      END_STATE();
    case 99:
      if (lookahead == 'l') ADVANCE(133);
      END_STATE();
    case 100:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(135);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(136);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 105:
      if (lookahead == 'l') ADVANCE(138);
      END_STATE();
    case 106:
      if (lookahead == 't') ADVANCE(139);
      END_STATE();
    case 107:
      if (lookahead == 'i') ADVANCE(140);
      END_STATE();
    case 108:
      if (lookahead == 'r') ADVANCE(141);
      END_STATE();
    case 109:
      if (lookahead == 'g') ADVANCE(142);
      END_STATE();
    case 110:
      if (lookahead == 'l') ADVANCE(143);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(146);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_reserved_self);
      END_STATE();
    case 116:
      if (lookahead == 'c') ADVANCE(148);
      END_STATE();
    case 117:
      if (lookahead == 'n') ADVANCE(149);
      END_STATE();
    case 118:
      if (lookahead == 'c') ADVANCE(150);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 121:
      if (lookahead == 'n') ADVANCE(151);
      END_STATE();
    case 122:
      if (lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 123:
      if (lookahead == 'o') ADVANCE(153);
      END_STATE();
    case 124:
      if (lookahead == 'd') ADVANCE(154);
      END_STATE();
    case 125:
      if (lookahead == 'g') ADVANCE(155);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(156);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 128:
      if (lookahead == 'y') ADVANCE(158);
      END_STATE();
    case 129:
      if (lookahead == 'a') ADVANCE(159);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 131:
      if (lookahead == 'y') ADVANCE(160);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(161);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 134:
      if (lookahead == 'y') ADVANCE(163);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_event);
      END_STATE();
    case 136:
      if (lookahead == 's') ADVANCE(164);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(165);
      END_STATE();
    case 139:
      if (lookahead == 'i') ADVANCE(166);
      END_STATE();
    case 140:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 141:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(169);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(170);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(171);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(172);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 148:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 149:
      if (lookahead == 'g') ADVANCE(176);
      END_STATE();
    case 150:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 152:
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 153:
      if (lookahead == 'w') ADVANCE(179);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 155:
      if (lookahead == 'n') ADVANCE(181);
      END_STATE();
    case 156:
      if (lookahead == 'o') ADVANCE(182);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_binary);
      END_STATE();
    case 159:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 160:
      if (lookahead == 'p') ADVANCE(184);
      END_STATE();
    case 161:
      if (lookahead == 'l') ADVANCE(185);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_entity);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_exists);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_forall);
      END_STATE();
    case 166:
      if (lookahead == 't') ADVANCE(186);
      END_STATE();
    case 167:
      if (lookahead == 's') ADVANCE(187);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 169:
      if (lookahead == 'r') ADVANCE(188);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 171:
      if (lookahead == 'q') ADVANCE(189);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_opaque);
      END_STATE();
    case 173:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 174:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_source);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 177:
      if (lookahead == 'u') ADVANCE(192);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_unique);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(193);
      END_STATE();
    case 180:
      if (lookahead == 'r') ADVANCE(194);
      END_STATE();
    case 181:
      if (lookahead == 'e') ADVANCE(195);
      END_STATE();
    case 182:
      if (lookahead == 'n') ADVANCE(196);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 184:
      if (lookahead == 'e') ADVANCE(197);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_decimal);
      END_STATE();
    case 186:
      if (lookahead == 'y') ADVANCE(198);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_implies);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_integer);
      END_STATE();
    case 189:
      if (lookahead == 'u') ADVANCE(199);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_ordered);
      END_STATE();
    case 191:
      if (lookahead == 'y') ADVANCE(200);
      END_STATE();
    case 192:
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_unknown_type);
      END_STATE();
    case 194:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 195:
      if (lookahead == 'd') ADVANCE(203);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_version);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_datatype);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_identity);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 201:
      if (lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 202:
      if (lookahead == 'd') ADVANCE(206);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_nonunique);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_structure);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_unordered);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 1},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 1},
  [8] = {.lex_state = 1},
  [9] = {.lex_state = 1},
  [10] = {.lex_state = 6},
  [11] = {.lex_state = 6},
  [12] = {.lex_state = 6},
  [13] = {.lex_state = 9},
  [14] = {.lex_state = 6},
  [15] = {.lex_state = 6},
  [16] = {.lex_state = 6},
  [17] = {.lex_state = 6},
  [18] = {.lex_state = 6},
  [19] = {.lex_state = 6},
  [20] = {.lex_state = 6},
  [21] = {.lex_state = 1},
  [22] = {.lex_state = 1},
  [23] = {.lex_state = 1},
  [24] = {.lex_state = 1},
  [25] = {.lex_state = 1},
  [26] = {.lex_state = 1},
  [27] = {.lex_state = 6},
  [28] = {.lex_state = 1},
  [29] = {.lex_state = 1},
  [30] = {.lex_state = 1},
  [31] = {.lex_state = 6},
  [32] = {.lex_state = 1},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 1},
  [36] = {.lex_state = 1},
  [37] = {.lex_state = 6},
  [38] = {.lex_state = 6},
  [39] = {.lex_state = 1},
  [40] = {.lex_state = 1},
  [41] = {.lex_state = 1},
  [42] = {.lex_state = 1},
  [43] = {.lex_state = 1},
  [44] = {.lex_state = 6},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 6},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 6},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 6},
  [58] = {.lex_state = 6},
  [59] = {.lex_state = 6},
  [60] = {.lex_state = 6},
  [61] = {.lex_state = 6},
  [62] = {.lex_state = 6},
  [63] = {.lex_state = 6},
  [64] = {.lex_state = 6},
  [65] = {.lex_state = 6},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 1},
  [68] = {.lex_state = 6},
  [69] = {.lex_state = 6},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 1},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 6},
  [78] = {.lex_state = 6},
  [79] = {.lex_state = 6},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 1},
  [82] = {.lex_state = 1},
  [83] = {.lex_state = 1},
  [84] = {.lex_state = 1},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 6},
  [90] = {.lex_state = 3},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 1},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 1},
  [99] = {.lex_state = 1},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 1},
  [103] = {.lex_state = 1},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 6},
  [109] = {.lex_state = 6},
  [110] = {.lex_state = 6},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 6},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 1},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 1},
  [118] = {.lex_state = 1},
  [119] = {.lex_state = 6},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 6},
  [122] = {.lex_state = 1},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 6},
  [125] = {.lex_state = 1},
  [126] = {.lex_state = 1},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 1},
  [129] = {.lex_state = 1},
  [130] = {.lex_state = 6},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 1},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 6},
  [136] = {.lex_state = 1},
  [137] = {.lex_state = 1},
  [138] = {.lex_state = 6},
  [139] = {.lex_state = 1},
  [140] = {.lex_state = 6},
  [141] = {.lex_state = 6},
  [142] = {.lex_state = 6},
  [143] = {.lex_state = 1},
  [144] = {.lex_state = 1},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 16},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 1},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 1},
  [165] = {.lex_state = 1},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 1},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 6},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 1},
  [186] = {.lex_state = 6},
  [187] = {.lex_state = 1},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 6},
  [244] = {.lex_state = 6},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 1},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 1},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 1},
  [266] = {.lex_state = 1},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 1},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 1},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 6},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 6},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 6},
  [282] = {.lex_state = 1},
  [283] = {.lex_state = 6},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 6},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 1},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 1},
  [292] = {.lex_state = 1},
  [293] = {.lex_state = 6},
  [294] = {.lex_state = 1},
  [295] = {.lex_state = 6},
  [296] = {.lex_state = 1},
  [297] = {.lex_state = 1},
  [298] = {.lex_state = 6},
  [299] = {.lex_state = 1},
  [300] = {.lex_state = 1},
  [301] = {.lex_state = 1},
  [302] = {.lex_state = 1},
  [303] = {.lex_state = 1},
  [304] = {.lex_state = 6},
  [305] = {.lex_state = 6},
  [306] = {.lex_state = 1},
  [307] = {.lex_state = 1},
  [308] = {.lex_state = 1},
  [309] = {.lex_state = 1},
  [310] = {.lex_state = 1},
  [311] = {.lex_state = 1},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 6},
  [315] = {.lex_state = 1},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 1},
  [319] = {.lex_state = 1},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 1},
  [322] = {.lex_state = 18},
  [323] = {.lex_state = 16},
  [324] = {.lex_state = 1},
  [325] = {.lex_state = 1},
  [326] = {.lex_state = 1},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 1},
  [329] = {.lex_state = 1},
  [330] = {.lex_state = 18},
  [331] = {.lex_state = 18},
  [332] = {.lex_state = 1},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 18},
  [335] = {.lex_state = 1},
  [336] = {.lex_state = 6},
  [337] = {.lex_state = 1},
  [338] = {.lex_state = 9},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 1},
  [341] = {.lex_state = 1},
  [342] = {.lex_state = 6},
  [343] = {.lex_state = 1},
  [344] = {.lex_state = 1},
  [345] = {.lex_state = 18},
  [346] = {.lex_state = 1},
  [347] = {.lex_state = 1},
  [348] = {.lex_state = 6},
  [349] = {.lex_state = 18},
  [350] = {.lex_state = 1},
  [351] = {.lex_state = 1},
  [352] = {.lex_state = 1},
  [353] = {.lex_state = 1},
  [354] = {.lex_state = 1},
  [355] = {.lex_state = 1},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 6},
  [358] = {.lex_state = 1},
  [359] = {.lex_state = 1},
  [360] = {.lex_state = 1},
  [361] = {.lex_state = 1},
  [362] = {.lex_state = 1},
  [363] = {.lex_state = 1},
  [364] = {.lex_state = 1},
  [365] = {.lex_state = 1},
  [366] = {.lex_state = 1},
  [367] = {.lex_state = 1},
  [368] = {.lex_state = 6},
  [369] = {.lex_state = 1},
  [370] = {.lex_state = 6},
  [371] = {.lex_state = 1},
  [372] = {.lex_state = 1},
  [373] = {.lex_state = 1},
  [374] = {.lex_state = 1},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 1},
  [385] = {.lex_state = 1},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 1},
  [394] = {.lex_state = 1},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 1},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 1},
  [403] = {.lex_state = 1},
  [404] = {.lex_state = 1},
  [405] = {.lex_state = 1},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 1},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 1},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 1},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 1},
  [418] = {.lex_state = 1},
  [419] = {.lex_state = 1},
  [420] = {.lex_state = 1},
  [421] = {.lex_state = 1},
  [422] = {.lex_state = 0},
  [423] = {.lex_state = 1},
  [424] = {.lex_state = 1},
  [425] = {.lex_state = 1},
  [426] = {.lex_state = 1},
  [427] = {.lex_state = 1},
  [428] = {.lex_state = 1},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 1},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 1},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 1},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 137},
  [441] = {.lex_state = 137},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_version] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [sym_controlled_language_tag] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_u2260] = ACTIONS(1),
    [sym_less_than] = ACTIONS(1),
    [sym_greater_than] = ACTIONS(1),
    [anon_sym_u2264] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_u2265] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_u00ac] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_u2227] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_u2228] = ACTIONS(1),
    [anon_sym_xor] = ACTIONS(1),
    [anon_sym_u22bb] = ACTIONS(1),
    [anon_sym_implies] = ACTIONS(1),
    [anon_sym_EQ_EQ_GT] = ACTIONS(1),
    [anon_sym_u21d2] = ACTIONS(1),
    [anon_sym_iff] = ACTIONS(1),
    [anon_sym_u21d4] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_forall] = ACTIONS(1),
    [anon_sym_u2200] = ACTIONS(1),
    [anon_sym_exists] = ACTIONS(1),
    [anon_sym_u2203] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_u2208] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_u2205] = ACTIONS(1),
    [sym_reserved_self] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_u2254] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym_optional] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_integer] = ACTIONS(1),
    [anon_sym_decimal] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_iri] = ACTIONS(1),
    [anon_sym_binary] = ACTIONS(1),
    [sym_quoted_string] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_POUND_LBRACK] = ACTIONS(1),
    [sym_hex_byte] = ACTIONS(1),
    [sym_double] = ACTIONS(1),
    [sym_decimal] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_unsigned] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_u22a4] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_u22a5] = ACTIONS(1),
    [anon_sym_datatype] = ACTIONS(1),
    [sym_opaque] = ACTIONS(1),
    [anon_sym_entity] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_event] = ACTIONS(1),
    [anon_sym_source] = ACTIONS(1),
    [anon_sym_property] = ACTIONS(1),
    [anon_sym_structure] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_rdf] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [sym_wildcard] = ACTIONS(1),
    [anon_sym_identity] = ACTIONS(1),
    [anon_sym_ref] = ACTIONS(1),
    [sym_unknown_type] = ACTIONS(1),
    [anon_sym_ordered] = ACTIONS(1),
    [anon_sym_unordered] = ACTIONS(1),
    [anon_sym_unique] = ACTIONS(1),
    [anon_sym_nonunique] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_u2192] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_u2190] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_module] = STATE(445),
    [anon_sym_module] = ACTIONS(5),
    [sym_line_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 36,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(23), 1,
      anon_sym_def,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_negation,
    STATE(5), 1,
      sym_constraint_environment,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(119), 1,
      sym_constraint_sentence,
    STATE(138), 1,
      sym_quantified_sentence,
    STATE(140), 1,
      sym_boolean_sentence,
    STATE(142), 1,
      sym_simple_sentence,
    STATE(171), 1,
      sym_term,
    STATE(409), 1,
      sym_quantified_variable_binding,
    STATE(422), 1,
      sym__sequence_value_constraints,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(55), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(130), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(292), 2,
      sym_environment_def,
      aux_sym_constraint_environment_repeat1,
    STATE(337), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(141), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(57), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [130] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_negation,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(78), 1,
      sym_constraint_sentence,
    STATE(138), 1,
      sym_quantified_sentence,
    STATE(140), 1,
      sym_boolean_sentence,
    STATE(142), 1,
      sym_simple_sentence,
    STATE(171), 1,
      sym_term,
    STATE(409), 1,
      sym_quantified_variable_binding,
    STATE(422), 1,
      sym__sequence_value_constraints,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(55), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(130), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(337), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(141), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(57), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [250] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_negation,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(77), 1,
      sym_constraint_sentence,
    STATE(138), 1,
      sym_quantified_sentence,
    STATE(140), 1,
      sym_boolean_sentence,
    STATE(142), 1,
      sym_simple_sentence,
    STATE(171), 1,
      sym_term,
    STATE(409), 1,
      sym_quantified_variable_binding,
    STATE(422), 1,
      sym__sequence_value_constraints,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(55), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(130), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(337), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(141), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(57), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [370] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_negation,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(124), 1,
      sym_constraint_sentence,
    STATE(138), 1,
      sym_quantified_sentence,
    STATE(140), 1,
      sym_boolean_sentence,
    STATE(142), 1,
      sym_simple_sentence,
    STATE(171), 1,
      sym_term,
    STATE(409), 1,
      sym_quantified_variable_binding,
    STATE(422), 1,
      sym__sequence_value_constraints,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(55), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(130), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(337), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(141), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(57), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [490] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_negation,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(79), 1,
      sym_constraint_sentence,
    STATE(138), 1,
      sym_quantified_sentence,
    STATE(140), 1,
      sym_boolean_sentence,
    STATE(142), 1,
      sym_simple_sentence,
    STATE(171), 1,
      sym_term,
    STATE(409), 1,
      sym_quantified_variable_binding,
    STATE(422), 1,
      sym__sequence_value_constraints,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(55), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(130), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(337), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(141), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(57), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [610] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_negation,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(89), 1,
      sym_constraint_sentence,
    STATE(138), 1,
      sym_quantified_sentence,
    STATE(140), 1,
      sym_boolean_sentence,
    STATE(142), 1,
      sym_simple_sentence,
    STATE(171), 1,
      sym_term,
    STATE(409), 1,
      sym_quantified_variable_binding,
    STATE(422), 1,
      sym__sequence_value_constraints,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(55), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(130), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(337), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(141), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(57), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [730] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_negation,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(108), 1,
      sym_constraint_sentence,
    STATE(138), 1,
      sym_quantified_sentence,
    STATE(140), 1,
      sym_boolean_sentence,
    STATE(142), 1,
      sym_simple_sentence,
    STATE(171), 1,
      sym_term,
    STATE(186), 1,
      sym_predicate_value,
    STATE(409), 1,
      sym_quantified_variable_binding,
    STATE(422), 1,
      sym__sequence_value_constraints,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(55), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(130), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(337), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(141), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(57), 4,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_sequence_builder,
  [852] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_negation,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(121), 1,
      sym_constraint_sentence,
    STATE(138), 1,
      sym_quantified_sentence,
    STATE(140), 1,
      sym_boolean_sentence,
    STATE(142), 1,
      sym_simple_sentence,
    STATE(171), 1,
      sym_term,
    STATE(409), 1,
      sym_quantified_variable_binding,
    STATE(422), 1,
      sym__sequence_value_constraints,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(55), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(130), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(337), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(141), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(57), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [972] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(41), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(43), 46,
      anon_sym_is,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_PLUS,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1031] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(45), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(47), 45,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_PLUS,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1089] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(49), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(51), 43,
      anon_sym_version,
      anon_sym_is,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1145] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(57), 1,
      sym_language_tag,
    ACTIONS(53), 6,
      sym_identifier,
      anon_sym_AT,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(55), 39,
      anon_sym_is,
      anon_sym_end,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1201] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(59), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(61), 40,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1254] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(63), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(65), 40,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1307] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(69), 40,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1360] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(71), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(73), 40,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1413] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(75), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(77), 40,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1466] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(81), 40,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1519] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(83), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(85), 40,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1572] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(87), 1,
      sym_identifier,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_RPAREN,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(95), 1,
      sym_reserved_self,
    ACTIONS(97), 1,
      anon_sym_LBRACE,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    STATE(24), 1,
      aux_sym_actual_arguments_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_term,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(123), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(145), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1652] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(87), 1,
      sym_identifier,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(95), 1,
      sym_reserved_self,
    ACTIONS(97), 1,
      anon_sym_LBRACE,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
    STATE(24), 1,
      aux_sym_actual_arguments_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_term,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(123), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(145), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1732] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(87), 1,
      sym_identifier,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(95), 1,
      sym_reserved_self,
    ACTIONS(97), 1,
      anon_sym_LBRACE,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(115), 1,
      anon_sym_RPAREN,
    STATE(22), 1,
      aux_sym_actual_arguments_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_term,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(123), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(145), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1812] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(117), 1,
      sym_identifier,
    ACTIONS(120), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_RPAREN,
    ACTIONS(125), 1,
      anon_sym_u2205,
    ACTIONS(128), 1,
      sym_reserved_self,
    ACTIONS(131), 1,
      anon_sym_LBRACE,
    ACTIONS(134), 1,
      sym_quoted_string,
    ACTIONS(137), 1,
      anon_sym_LT,
    ACTIONS(140), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(143), 1,
      sym_double,
    STATE(24), 1,
      aux_sym_actual_arguments_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_term,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(149), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(152), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(123), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(146), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(145), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1892] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(87), 1,
      sym_identifier,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(95), 1,
      sym_reserved_self,
    ACTIONS(97), 1,
      anon_sym_LBRACE,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    STATE(21), 1,
      aux_sym_actual_arguments_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_term,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(123), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(145), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1972] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(110), 1,
      sym_term,
    STATE(422), 1,
      sym__sequence_value_constraints,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(55), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(57), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2046] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(157), 1,
      anon_sym_COLON,
    ACTIONS(159), 1,
      anon_sym_DOT,
    STATE(37), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(45), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(47), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [2092] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(109), 1,
      sym_term,
    STATE(422), 1,
      sym__sequence_value_constraints,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(55), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(57), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2166] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(161), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(163), 27,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2208] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(339), 1,
      sym_term,
    STATE(422), 1,
      sym__sequence_value_constraints,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(55), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(57), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2282] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(171), 1,
      anon_sym_DOT,
    STATE(31), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(169), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(167), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [2325] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(176), 1,
      anon_sym_RBRACK,
    ACTIONS(178), 1,
      anon_sym_LBRACE,
    STATE(45), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(117), 1,
      sym_simple_value,
    STATE(123), 1,
      sym_sequence_of_predicate_values,
    STATE(147), 1,
      sym_identifier_reference,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(156), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [2402] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(180), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(182), 27,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2441] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(184), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(186), 27,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2480] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(178), 1,
      anon_sym_LBRACE,
    ACTIONS(188), 1,
      anon_sym_RBRACK,
    STATE(45), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(117), 1,
      sym_simple_value,
    STATE(123), 1,
      sym_sequence_of_predicate_values,
    STATE(147), 1,
      sym_identifier_reference,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(156), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [2557] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(190), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(192), 27,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2596] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(159), 1,
      anon_sym_DOT,
    STATE(31), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(196), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(194), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [2639] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(159), 1,
      anon_sym_DOT,
    STATE(31), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(196), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(194), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [2682] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(178), 1,
      anon_sym_LBRACE,
    ACTIONS(198), 1,
      anon_sym_RBRACK,
    STATE(45), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(117), 1,
      sym_simple_value,
    STATE(123), 1,
      sym_sequence_of_predicate_values,
    STATE(147), 1,
      sym_identifier_reference,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(156), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [2759] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(178), 1,
      anon_sym_LBRACE,
    ACTIONS(200), 1,
      anon_sym_RBRACK,
    STATE(35), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(117), 1,
      sym_simple_value,
    STATE(123), 1,
      sym_sequence_of_predicate_values,
    STATE(147), 1,
      sym_identifier_reference,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(156), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [2836] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(202), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(204), 27,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2875] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(206), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(208), 27,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2914] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(178), 1,
      anon_sym_LBRACE,
    ACTIONS(210), 1,
      anon_sym_RBRACK,
    STATE(39), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(117), 1,
      sym_simple_value,
    STATE(123), 1,
      sym_sequence_of_predicate_values,
    STATE(147), 1,
      sym_identifier_reference,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(156), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [2991] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(159), 1,
      anon_sym_DOT,
    STATE(38), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(214), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(212), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3034] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(219), 1,
      anon_sym_LBRACK,
    ACTIONS(222), 1,
      anon_sym_RBRACK,
    ACTIONS(224), 1,
      anon_sym_u2205,
    ACTIONS(227), 1,
      anon_sym_LBRACE,
    ACTIONS(230), 1,
      sym_quoted_string,
    ACTIONS(233), 1,
      anon_sym_LT,
    ACTIONS(236), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(239), 1,
      sym_double,
    STATE(45), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(117), 1,
      sym_simple_value,
    STATE(123), 1,
      sym_sequence_of_predicate_values,
    STATE(147), 1,
      sym_identifier_reference,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(245), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(248), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(242), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(156), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3111] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(178), 1,
      anon_sym_LBRACE,
    ACTIONS(251), 1,
      anon_sym_RBRACK,
    STATE(32), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(117), 1,
      sym_simple_value,
    STATE(123), 1,
      sym_sequence_of_predicate_values,
    STATE(147), 1,
      sym_identifier_reference,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(156), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3188] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(253), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(255), 27,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [3227] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(178), 1,
      anon_sym_LBRACE,
    ACTIONS(257), 1,
      anon_sym_RBRACK,
    STATE(49), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(117), 1,
      sym_simple_value,
    STATE(123), 1,
      sym_sequence_of_predicate_values,
    STATE(147), 1,
      sym_identifier_reference,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(156), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3304] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(178), 1,
      anon_sym_LBRACE,
    ACTIONS(259), 1,
      anon_sym_RBRACK,
    STATE(45), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(117), 1,
      sym_simple_value,
    STATE(123), 1,
      sym_sequence_of_predicate_values,
    STATE(147), 1,
      sym_identifier_reference,
    STATE(442), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(156), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3381] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(261), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(263), 27,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [3420] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(161), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(163), 27,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [3459] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(267), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(265), 26,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_def,
      anon_sym_RBRACE,
  [3497] = 19,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(269), 1,
      anon_sym_end,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(277), 1,
      anon_sym_datatype,
    ACTIONS(279), 1,
      anon_sym_entity,
    ACTIONS(281), 1,
      anon_sym_enum,
    ACTIONS(283), 1,
      anon_sym_event,
    ACTIONS(285), 1,
      anon_sym_property,
    ACTIONS(287), 1,
      anon_sym_structure,
    ACTIONS(289), 1,
      anon_sym_union,
    ACTIONS(291), 1,
      anon_sym_rdf,
    ACTIONS(293), 1,
      anon_sym_class,
    STATE(54), 2,
      sym_import_statement,
      aux_sym_module_body_repeat1,
    STATE(71), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(93), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(235), 9,
      sym_data_type_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [3567] = 19,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(277), 1,
      anon_sym_datatype,
    ACTIONS(279), 1,
      anon_sym_entity,
    ACTIONS(281), 1,
      anon_sym_enum,
    ACTIONS(283), 1,
      anon_sym_event,
    ACTIONS(285), 1,
      anon_sym_property,
    ACTIONS(287), 1,
      anon_sym_structure,
    ACTIONS(289), 1,
      anon_sym_union,
    ACTIONS(291), 1,
      anon_sym_rdf,
    ACTIONS(293), 1,
      anon_sym_class,
    ACTIONS(295), 1,
      anon_sym_end,
    STATE(70), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(100), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(164), 2,
      sym_import_statement,
      aux_sym_module_body_repeat1,
    STATE(235), 9,
      sym_data_type_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [3637] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(299), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(297), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3674] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    ACTIONS(178), 1,
      anon_sym_LBRACE,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      anon_sym_u2205,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(29), 1,
      sym_identifier_reference,
    STATE(42), 1,
      sym_value,
    STATE(116), 1,
      sym_simple_value,
    STATE(377), 1,
      sym__sequence_value_constraints,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(51), 3,
      sym_sequence_of_values,
      sym_value_constructor,
      sym_mapping_value,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3745] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(214), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(212), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3782] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(307), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3819] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(313), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(311), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3856] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(317), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(315), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3893] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(321), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(319), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3930] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(325), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(323), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3967] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(329), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(327), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4004] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(333), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(331), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4041] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(337), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(335), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4078] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    ACTIONS(178), 1,
      anon_sym_LBRACE,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      anon_sym_u2205,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(29), 1,
      sym_identifier_reference,
    STATE(116), 1,
      sym_simple_value,
    STATE(159), 1,
      sym_value,
    STATE(377), 1,
      sym__sequence_value_constraints,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(51), 3,
      sym_sequence_of_values,
      sym_value_constructor,
      sym_mapping_value,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4149] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(178), 1,
      anon_sym_LBRACE,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      anon_sym_u2205,
    STATE(29), 1,
      sym_identifier_reference,
    STATE(42), 1,
      sym_value,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(118), 1,
      sym_simple_value,
    STATE(377), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(51), 3,
      sym_sequence_of_values,
      sym_value_constructor,
      sym_mapping_value,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4220] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(45), 1,
      sym_identifier,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(47), 26,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_LBRACE,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_PLUS,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [4258] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(343), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(345), 6,
      anon_sym_LPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
    ACTIONS(341), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4296] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(277), 1,
      anon_sym_datatype,
    ACTIONS(279), 1,
      anon_sym_entity,
    ACTIONS(281), 1,
      anon_sym_enum,
    ACTIONS(283), 1,
      anon_sym_event,
    ACTIONS(285), 1,
      anon_sym_property,
    ACTIONS(287), 1,
      anon_sym_structure,
    ACTIONS(289), 1,
      anon_sym_union,
    ACTIONS(291), 1,
      anon_sym_rdf,
    ACTIONS(293), 1,
      anon_sym_class,
    ACTIONS(347), 1,
      anon_sym_end,
    STATE(98), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(106), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(235), 9,
      sym_data_type_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [4359] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(277), 1,
      anon_sym_datatype,
    ACTIONS(279), 1,
      anon_sym_entity,
    ACTIONS(281), 1,
      anon_sym_enum,
    ACTIONS(283), 1,
      anon_sym_event,
    ACTIONS(285), 1,
      anon_sym_property,
    ACTIONS(287), 1,
      anon_sym_structure,
    ACTIONS(289), 1,
      anon_sym_union,
    ACTIONS(291), 1,
      anon_sym_rdf,
    ACTIONS(293), 1,
      anon_sym_class,
    ACTIONS(295), 1,
      anon_sym_end,
    STATE(100), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(106), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(235), 9,
      sym_data_type_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [4422] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(349), 1,
      anon_sym_RBRACK,
    STATE(76), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(149), 1,
      sym_simple_value,
    STATE(168), 1,
      sym_identifier_reference,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(174), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4483] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(351), 1,
      anon_sym_RBRACK,
    STATE(75), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(149), 1,
      sym_simple_value,
    STATE(168), 1,
      sym_identifier_reference,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(174), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4544] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(353), 1,
      anon_sym_RBRACK,
    STATE(72), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(149), 1,
      sym_simple_value,
    STATE(168), 1,
      sym_identifier_reference,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(174), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4605] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(355), 1,
      anon_sym_RBRACK,
    STATE(76), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(149), 1,
      sym_simple_value,
    STATE(168), 1,
      sym_identifier_reference,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(174), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4666] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(357), 1,
      sym_identifier,
    ACTIONS(360), 1,
      anon_sym_RBRACK,
    ACTIONS(362), 1,
      sym_quoted_string,
    ACTIONS(365), 1,
      anon_sym_LT,
    ACTIONS(368), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(371), 1,
      sym_double,
    STATE(76), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(149), 1,
      sym_simple_value,
    STATE(168), 1,
      sym_identifier_reference,
    ACTIONS(377), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(380), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(101), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(174), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(374), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(94), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4727] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(3), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
    ACTIONS(383), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4759] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(3), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
    ACTIONS(385), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4791] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(389), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(391), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(393), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(395), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(397), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    ACTIONS(387), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
    STATE(3), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [4833] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(399), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(401), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [4864] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(403), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(405), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [4895] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(407), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(409), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [4926] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(411), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(413), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [4957] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(415), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(417), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [4988] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(419), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(421), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5019] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(423), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(425), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5050] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(427), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(429), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5081] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(45), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(47), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_as,
  [5111] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(389), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(391), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(393), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(395), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(397), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    ACTIONS(431), 4,
      anon_sym_is,
      anon_sym_end,
      anon_sym_in,
      anon_sym_def,
    STATE(3), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [5151] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(433), 1,
      sym_language_tag,
    ACTIONS(53), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(55), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5183] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(41), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(43), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_as,
  [5213] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(63), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(65), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5242] = 13,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(277), 1,
      anon_sym_datatype,
    ACTIONS(279), 1,
      anon_sym_entity,
    ACTIONS(281), 1,
      anon_sym_enum,
    ACTIONS(283), 1,
      anon_sym_event,
    ACTIONS(285), 1,
      anon_sym_property,
    ACTIONS(287), 1,
      anon_sym_structure,
    ACTIONS(289), 1,
      anon_sym_union,
    ACTIONS(291), 1,
      anon_sym_rdf,
    ACTIONS(293), 1,
      anon_sym_class,
    ACTIONS(295), 1,
      anon_sym_end,
    STATE(99), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(235), 9,
      sym_data_type_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [5291] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(69), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5320] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(59), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(61), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5349] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(75), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(77), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5378] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(81), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5407] = 13,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(277), 1,
      anon_sym_datatype,
    ACTIONS(279), 1,
      anon_sym_entity,
    ACTIONS(281), 1,
      anon_sym_enum,
    ACTIONS(283), 1,
      anon_sym_event,
    ACTIONS(285), 1,
      anon_sym_property,
    ACTIONS(287), 1,
      anon_sym_structure,
    ACTIONS(289), 1,
      anon_sym_union,
    ACTIONS(291), 1,
      anon_sym_rdf,
    ACTIONS(293), 1,
      anon_sym_class,
    ACTIONS(435), 1,
      anon_sym_end,
    STATE(99), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(235), 9,
      sym_data_type_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [5456] = 13,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(437), 1,
      anon_sym_end,
    ACTIONS(439), 1,
      anon_sym_datatype,
    ACTIONS(442), 1,
      anon_sym_entity,
    ACTIONS(445), 1,
      anon_sym_enum,
    ACTIONS(448), 1,
      anon_sym_event,
    ACTIONS(451), 1,
      anon_sym_property,
    ACTIONS(454), 1,
      anon_sym_structure,
    ACTIONS(457), 1,
      anon_sym_union,
    ACTIONS(460), 1,
      anon_sym_rdf,
    ACTIONS(463), 1,
      anon_sym_class,
    STATE(99), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(235), 9,
      sym_data_type_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [5505] = 13,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(277), 1,
      anon_sym_datatype,
    ACTIONS(279), 1,
      anon_sym_entity,
    ACTIONS(281), 1,
      anon_sym_enum,
    ACTIONS(283), 1,
      anon_sym_event,
    ACTIONS(285), 1,
      anon_sym_property,
    ACTIONS(287), 1,
      anon_sym_structure,
    ACTIONS(289), 1,
      anon_sym_union,
    ACTIONS(291), 1,
      anon_sym_rdf,
    ACTIONS(293), 1,
      anon_sym_class,
    ACTIONS(347), 1,
      anon_sym_end,
    STATE(99), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(235), 9,
      sym_data_type_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [5554] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(83), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(85), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5583] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(466), 1,
      anon_sym_COLON,
    ACTIONS(468), 1,
      anon_sym_DOT,
    STATE(111), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(45), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(47), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5618] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(49), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(51), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5647] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(71), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(73), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5676] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(468), 1,
      anon_sym_DOT,
    STATE(113), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(214), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(212), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5708] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(470), 1,
      sym_identifier,
    ACTIONS(474), 1,
      anon_sym_AT,
    ACTIONS(477), 1,
      anon_sym_assert,
    STATE(106), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    ACTIONS(472), 13,
      anon_sym_end,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [5744] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(480), 1,
      anon_sym_DOT,
    STATE(107), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(169), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(167), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5776] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(389), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(391), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(393), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(483), 2,
      anon_sym_in,
      anon_sym_def,
    ACTIONS(395), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(397), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(3), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [5814] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(487), 1,
      anon_sym_LPAREN,
    STATE(112), 1,
      sym_actual_arguments,
    ACTIONS(485), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [5844] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(487), 1,
      anon_sym_LPAREN,
    STATE(112), 1,
      sym_actual_arguments,
    ACTIONS(489), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [5874] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(468), 1,
      anon_sym_DOT,
    STATE(107), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(196), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(194), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5906] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(345), 20,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [5932] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(468), 1,
      anon_sym_DOT,
    STATE(107), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(196), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(194), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5964] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(491), 1,
      sym_identifier,
    ACTIONS(493), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5991] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(495), 1,
      sym_identifier,
    ACTIONS(497), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [6018] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(161), 1,
      sym_identifier,
    STATE(56), 1,
      sym__has_type,
    ACTIONS(499), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(163), 15,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [6049] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(67), 1,
      sym__has_type,
    ACTIONS(501), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(299), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(297), 12,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_u2205,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6080] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(67), 1,
      sym__has_type,
    ACTIONS(501), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(161), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(163), 12,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_u2205,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6111] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(503), 1,
      anon_sym_end,
    ACTIONS(389), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(391), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(393), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(395), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(397), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(3), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [6148] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(337), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(335), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6175] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(505), 1,
      anon_sym_RPAREN,
    ACTIONS(389), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(391), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(393), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(395), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(397), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(3), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [6212] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(313), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(311), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6239] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(299), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(297), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6266] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(507), 1,
      anon_sym_end,
    ACTIONS(389), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(391), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(393), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(395), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(397), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(3), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [6303] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(267), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(265), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6330] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(325), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(323), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6357] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(513), 1,
      anon_sym_LPAREN,
    STATE(133), 1,
      sym_actual_arguments,
    ACTIONS(509), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(511), 13,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6388] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(321), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(319), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6415] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(307), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6442] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(515), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6466] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(466), 1,
      anon_sym_COLON,
    ACTIONS(45), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(47), 13,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_u2205,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6494] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LPAREN,
    ACTIONS(519), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      sym_optional,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(153), 1,
      sym_function_cardinality_expression,
    STATE(255), 1,
      sym_function_type_reference,
    STATE(260), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(523), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [6534] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(343), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(345), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6560] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(333), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(331), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6586] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(525), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6610] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(317), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(315), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6636] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(329), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(327), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6662] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(527), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6686] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LPAREN,
    ACTIONS(529), 1,
      anon_sym_LBRACE,
    ACTIONS(531), 1,
      sym_unknown_type,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(161), 1,
      sym_cardinality_expression,
    STATE(180), 1,
      sym_type_reference,
    STATE(155), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(523), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [6726] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(527), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6750] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(533), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6774] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(527), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6798] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(157), 1,
      anon_sym_COLON,
    ACTIONS(535), 1,
      sym_identifier,
    STATE(165), 1,
      sym_iri,
    ACTIONS(537), 14,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [6830] = 11,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(429), 1,
      sym_simple_value,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(20), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [6872] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(214), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(212), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6898] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(543), 1,
      sym_controlled_language_tag,
    ACTIONS(539), 2,
      sym_identifier,
      anon_sym_AT,
    ACTIONS(541), 14,
      anon_sym_end,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [6925] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(545), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(547), 12,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_u2205,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6952] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(549), 1,
      sym_identifier,
    ACTIONS(551), 15,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [6976] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(67), 1,
      sym__has_type,
    ACTIONS(501), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(553), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(555), 9,
      anon_sym_RBRACK,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7004] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LPAREN,
    ACTIONS(531), 1,
      sym_unknown_type,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(333), 1,
      sym_type_reference,
    STATE(155), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(523), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7038] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(557), 1,
      sym_identifier,
    ACTIONS(559), 15,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [7062] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(561), 1,
      sym_identifier,
    ACTIONS(563), 15,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [7086] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LPAREN,
    ACTIONS(521), 1,
      sym_optional,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(261), 1,
      sym_function_type_reference,
    STATE(260), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(523), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7120] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(565), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(567), 12,
      anon_sym_LBRACK,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7144] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(569), 1,
      sym_identifier,
    ACTIONS(571), 15,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [7168] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(545), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(547), 12,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_u2205,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7192] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(573), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(575), 12,
      anon_sym_LBRACK,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7216] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(577), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(579), 12,
      anon_sym_LBRACK,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7240] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(581), 1,
      sym_identifier,
    ACTIONS(583), 15,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [7264] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LPAREN,
    ACTIONS(531), 1,
      sym_unknown_type,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(431), 1,
      sym_type_reference,
    STATE(155), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(523), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7298] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LPAREN,
    ACTIONS(531), 1,
      sym_unknown_type,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(178), 1,
      sym_type_reference,
    STATE(155), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(523), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7332] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(585), 1,
      sym_identifier,
    ACTIONS(587), 15,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [7356] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(589), 1,
      sym_identifier,
    ACTIONS(591), 15,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [7380] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(595), 1,
      anon_sym_import,
    STATE(164), 2,
      sym_import_statement,
      aux_sym_module_body_repeat1,
    ACTIONS(593), 12,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7405] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(598), 1,
      sym_identifier,
    ACTIONS(600), 14,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7428] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(602), 1,
      sym_identifier,
    ACTIONS(604), 14,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7451] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(517), 1,
      anon_sym_LPAREN,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(263), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(523), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7479] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(553), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(555), 9,
      anon_sym_RBRACK,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7503] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(606), 1,
      sym_identifier,
    ACTIONS(608), 1,
      anon_sym_is,
    STATE(185), 1,
      sym_annotation_only_body,
    ACTIONS(610), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
  [7529] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(612), 1,
      sym_opaque,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(187), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym__data_type_base,
    ACTIONS(523), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7557] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(487), 1,
      anon_sym_LPAREN,
    ACTIONS(614), 1,
      anon_sym_EQ,
    STATE(69), 1,
      sym_actual_arguments,
    ACTIONS(616), 2,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
    ACTIONS(618), 2,
      sym_less_than,
      sym_greater_than,
    ACTIONS(620), 2,
      anon_sym_LT_EQ,
      anon_sym_u2264,
    ACTIONS(622), 2,
      anon_sym_GT_EQ,
      anon_sym_u2265,
    STATE(28), 3,
      sym_not_equal,
      sym_less_than_or_equal,
      sym_greater_than_or_equal,
  [7591] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(626), 1,
      anon_sym_end,
    ACTIONS(628), 1,
      anon_sym_ref,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(175), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(253), 2,
      sym_member,
      aux_sym_entity_body_repeat1,
    STATE(340), 2,
      sym_member_def,
      sym_property_ref,
  [7626] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(630), 13,
      anon_sym_end,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7645] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(553), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(555), 9,
      anon_sym_RBRACK,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7666] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(628), 1,
      anon_sym_ref,
    ACTIONS(632), 1,
      anon_sym_end,
    STATE(106), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(250), 2,
      sym_member,
      aux_sym_entity_body_repeat1,
    STATE(340), 2,
      sym_member_def,
      sym_property_ref,
  [7701] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(634), 1,
      sym_identifier,
    ACTIONS(636), 12,
      anon_sym_end,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
  [7722] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(181), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym__data_type_base,
    ACTIONS(523), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7747] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(638), 1,
      sym_identifier,
    ACTIONS(640), 12,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
  [7768] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(642), 13,
      anon_sym_end,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7787] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(644), 1,
      sym_identifier,
    ACTIONS(646), 12,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
  [7808] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(608), 1,
      anon_sym_is,
    STATE(210), 1,
      sym_annotation_only_body,
    ACTIONS(648), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7830] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(650), 1,
      anon_sym_is,
    STATE(227), 1,
      sym_entity_body,
    ACTIONS(652), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7852] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(654), 1,
      anon_sym_is,
    STATE(228), 1,
      sym_structured_body,
    ACTIONS(656), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7874] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(658), 1,
      sym_identifier,
    ACTIONS(660), 1,
      anon_sym_end,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(286), 1,
      sym_identifier_reference,
    STATE(106), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(267), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [7908] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(662), 1,
      sym_identifier,
    ACTIONS(664), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
  [7928] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(214), 2,
      sym_less_than,
      sym_greater_than,
    ACTIONS(483), 2,
      anon_sym_in,
      anon_sym_def,
    ACTIONS(212), 8,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_LT_EQ,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
  [7950] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(608), 1,
      anon_sym_is,
    STATE(219), 1,
      sym_annotation_only_body,
    ACTIONS(666), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7972] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(670), 1,
      anon_sym_of,
    STATE(239), 1,
      sym_union_body,
    ACTIONS(668), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7994] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(654), 1,
      anon_sym_is,
    STATE(242), 1,
      sym_structured_body,
    ACTIONS(672), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8016] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(676), 1,
      anon_sym_of,
    STATE(233), 1,
      sym_enum_body,
    ACTIONS(674), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8038] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(658), 1,
      sym_identifier,
    ACTIONS(678), 1,
      anon_sym_end,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(286), 1,
      sym_identifier_reference,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(184), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(268), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [8072] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(680), 1,
      anon_sym_is,
    STATE(234), 1,
      sym_type_class_body,
    ACTIONS(682), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8094] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(684), 1,
      sym_identifier,
    ACTIONS(686), 10,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
      sym_unknown_type,
  [8113] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(688), 1,
      sym_identifier,
    ACTIONS(690), 10,
      anon_sym_LPAREN,
      sym_optional,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [8132] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(692), 1,
      sym_identifier,
    ACTIONS(694), 10,
      anon_sym_LPAREN,
      sym_optional,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [8151] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(696), 1,
      sym_identifier,
    ACTIONS(698), 10,
      anon_sym_LPAREN,
      sym_optional,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [8170] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(700), 1,
      sym_identifier,
    ACTIONS(702), 1,
      anon_sym_LPAREN,
    STATE(310), 1,
      sym_sequence_ordering,
    STATE(346), 1,
      aux_sym_named_variable_set_repeat1,
    STATE(386), 1,
      sym_sequence_uniqueness,
    ACTIONS(704), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(706), 2,
      anon_sym_unique,
      anon_sym_nonunique,
    STATE(397), 2,
      sym_named_variable_set,
      sym_mapping_variable,
  [8201] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(708), 1,
      sym_identifier,
    ACTIONS(710), 10,
      anon_sym_LPAREN,
      sym_optional,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [8220] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(712), 1,
      sym_identifier,
    ACTIONS(714), 10,
      anon_sym_LPAREN,
      sym_optional,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [8239] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(700), 1,
      sym_identifier,
    ACTIONS(702), 1,
      anon_sym_LPAREN,
    STATE(310), 1,
      sym_sequence_ordering,
    STATE(346), 1,
      aux_sym_named_variable_set_repeat1,
    STATE(386), 1,
      sym_sequence_uniqueness,
    ACTIONS(704), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(706), 2,
      anon_sym_unique,
      anon_sym_nonunique,
    STATE(444), 2,
      sym_named_variable_set,
      sym_mapping_variable,
  [8270] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(716), 1,
      sym_identifier,
    ACTIONS(718), 10,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
      sym_unknown_type,
  [8289] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(720), 1,
      sym_identifier,
    ACTIONS(722), 10,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
      sym_unknown_type,
  [8308] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(724), 1,
      anon_sym_LPAREN,
    STATE(8), 1,
      sym__by_definition,
    STATE(132), 1,
      sym__has_type,
    STATE(282), 1,
      sym__function_type,
    STATE(313), 1,
      sym_function_signature,
    ACTIONS(726), 2,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
    ACTIONS(728), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    STATE(356), 2,
      sym_function_def,
      sym_constant_def,
  [8339] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(732), 10,
      anon_sym_LPAREN,
      sym_optional,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [8358] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(734), 1,
      sym_identifier,
    ACTIONS(736), 10,
      anon_sym_LPAREN,
      sym_optional,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [8377] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(738), 1,
      sym_identifier,
    ACTIONS(740), 10,
      anon_sym_LPAREN,
      sym_optional,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [8396] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(742), 1,
      sym_identifier,
    ACTIONS(744), 10,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
      sym_unknown_type,
  [8415] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(746), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8431] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(748), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8447] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(750), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8463] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(752), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8479] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(754), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8495] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(756), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8511] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(758), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8527] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(760), 1,
      sym_identifier,
    ACTIONS(762), 1,
      anon_sym_end,
    STATE(106), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(321), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [8555] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(764), 1,
      anon_sym_end,
    ACTIONS(766), 1,
      anon_sym_def,
    STATE(307), 1,
      aux_sym_type_class_body_repeat1,
    STATE(361), 1,
      sym_method_def,
    STATE(106), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
  [8585] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(768), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8601] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(770), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8617] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(772), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8633] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(774), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8649] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(776), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8665] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(778), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8681] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(780), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8697] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(782), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8713] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(784), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8729] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(786), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8745] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(788), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8761] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(790), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8777] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(792), 1,
      anon_sym_LPAREN,
    STATE(398), 1,
      sym_quantified_sentence,
    STATE(409), 1,
      sym_quantified_variable_binding,
    STATE(439), 1,
      sym_sequence_builder_body,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(337), 2,
      sym_universal,
      sym_existential,
  [8805] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(792), 1,
      anon_sym_LPAREN,
    STATE(398), 1,
      sym_quantified_sentence,
    STATE(409), 1,
      sym_quantified_variable_binding,
    STATE(414), 1,
      sym_sequence_builder_body,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(337), 2,
      sym_universal,
      sym_existential,
  [8833] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(766), 1,
      anon_sym_def,
    ACTIONS(794), 1,
      anon_sym_end,
    STATE(315), 1,
      aux_sym_type_class_body_repeat1,
    STATE(361), 1,
      sym_method_def,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(216), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [8863] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(760), 1,
      sym_identifier,
    ACTIONS(796), 1,
      anon_sym_end,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(215), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(296), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [8891] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(798), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8907] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(800), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8923] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(802), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8939] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(804), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8955] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(806), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8971] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(808), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8987] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(810), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9003] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(812), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9019] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(814), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9035] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(816), 10,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9051] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(818), 1,
      anon_sym_RBRACE,
    ACTIONS(820), 1,
      sym_unsigned,
    STATE(276), 1,
      sym_sequence_ordering,
    STATE(336), 1,
      sym_sequence_uniqueness,
    STATE(395), 1,
      sym__cardinality_inner,
    ACTIONS(704), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(706), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [9078] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(820), 1,
      sym_unsigned,
    STATE(283), 1,
      sym_sequence_ordering,
    STATE(357), 1,
      sym_sequence_uniqueness,
    STATE(408), 1,
      sym__cardinality_inner,
    ACTIONS(704), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(706), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [9102] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(608), 1,
      anon_sym_is,
    STATE(7), 1,
      sym__by_definition,
    STATE(302), 1,
      sym_function_body,
    STATE(365), 1,
      sym_annotation_only_body,
    ACTIONS(822), 2,
      anon_sym_end,
      anon_sym_def,
    ACTIONS(824), 2,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [9126] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(826), 1,
      anon_sym_identity,
    STATE(251), 1,
      sym_entity_identity,
    STATE(106), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
  [9150] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(826), 1,
      anon_sym_identity,
    STATE(252), 1,
      sym_entity_identity,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(246), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [9174] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(376), 1,
      sym_quantified_sentence,
    STATE(409), 1,
      sym_quantified_variable_binding,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(337), 2,
      sym_universal,
      sym_existential,
  [9196] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(628), 1,
      anon_sym_ref,
    ACTIONS(828), 1,
      anon_sym_end,
    STATE(259), 2,
      sym_member,
      aux_sym_entity_body_repeat1,
    STATE(340), 2,
      sym_member_def,
      sym_property_ref,
  [9217] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(628), 1,
      anon_sym_ref,
    ACTIONS(830), 1,
      anon_sym_end,
    STATE(259), 2,
      sym_member,
      aux_sym_entity_body_repeat1,
    STATE(340), 2,
      sym_member_def,
      sym_property_ref,
  [9238] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(628), 1,
      anon_sym_ref,
    ACTIONS(832), 1,
      anon_sym_end,
    STATE(254), 2,
      sym_member,
      aux_sym_entity_body_repeat1,
    STATE(340), 2,
      sym_member_def,
      sym_property_ref,
  [9259] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(628), 1,
      anon_sym_ref,
    ACTIONS(834), 1,
      anon_sym_end,
    STATE(249), 2,
      sym_member,
      aux_sym_entity_body_repeat1,
    STATE(340), 2,
      sym_member_def,
      sym_property_ref,
  [9280] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(628), 1,
      anon_sym_ref,
    ACTIONS(632), 1,
      anon_sym_end,
    STATE(259), 2,
      sym_member,
      aux_sym_entity_body_repeat1,
    STATE(340), 2,
      sym_member_def,
      sym_property_ref,
  [9301] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(628), 1,
      anon_sym_ref,
    ACTIONS(836), 1,
      anon_sym_end,
    STATE(259), 2,
      sym_member,
      aux_sym_entity_body_repeat1,
    STATE(340), 2,
      sym_member_def,
      sym_property_ref,
  [9322] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(838), 1,
      sym_identifier,
    ACTIONS(840), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [9337] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(297), 1,
      sym__has_type,
    STATE(328), 1,
      sym__type_variable_restriction,
    ACTIONS(844), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(842), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [9356] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_RBRACK,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(257), 4,
      sym__import,
      sym_member_import,
      sym_module_import,
      aux_sym_import_statement_repeat1,
  [9375] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(851), 1,
      sym_identifier,
    ACTIONS(853), 1,
      anon_sym_RBRACK,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(257), 4,
      sym__import,
      sym_member_import,
      sym_module_import,
      aux_sym_import_statement_repeat1,
  [9394] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(855), 1,
      sym_identifier,
    ACTIONS(858), 1,
      anon_sym_end,
    ACTIONS(860), 1,
      anon_sym_ref,
    STATE(259), 2,
      sym_member,
      aux_sym_entity_body_repeat1,
    STATE(340), 2,
      sym_member_def,
      sym_property_ref,
  [9415] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(865), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [9430] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(867), 1,
      sym_identifier,
    ACTIONS(869), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [9445] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    ACTIONS(871), 1,
      anon_sym_end,
    STATE(106), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
  [9466] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(873), 1,
      sym_identifier,
    ACTIONS(875), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [9481] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(297), 1,
      sym__has_type,
    STATE(343), 1,
      sym__type_variable_restriction,
    ACTIONS(844), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(877), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [9500] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(851), 1,
      sym_identifier,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(258), 4,
      sym__import,
      sym_member_import,
      sym_module_import,
      aux_sym_import_statement_repeat1,
  [9516] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(879), 1,
      sym_identifier,
    ACTIONS(882), 1,
      anon_sym_end,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(286), 1,
      sym_identifier_reference,
    STATE(266), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [9536] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(658), 1,
      sym_identifier,
    ACTIONS(884), 1,
      anon_sym_end,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(286), 1,
      sym_identifier_reference,
    STATE(266), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [9556] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(658), 1,
      sym_identifier,
    ACTIONS(660), 1,
      anon_sym_end,
    STATE(88), 1,
      sym_qualified_identifier,
    STATE(286), 1,
      sym_identifier_reference,
    STATE(266), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [9576] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(310), 1,
      sym_sequence_ordering,
    STATE(386), 1,
      sym_sequence_uniqueness,
    ACTIONS(704), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(706), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [9594] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(851), 1,
      sym_identifier,
    ACTIONS(886), 1,
      anon_sym_LBRACK,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(173), 3,
      sym__import,
      sym_member_import,
      sym_module_import,
  [9612] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(519), 1,
      anon_sym_LBRACE,
    ACTIONS(888), 1,
      sym_identifier,
    ACTIONS(890), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      aux_sym_type_class_def_repeat1,
    STATE(326), 1,
      sym_type_variable,
    STATE(373), 1,
      sym_function_cardinality_expression,
  [9634] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(894), 1,
      anon_sym_RPAREN,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(273), 1,
      sym_identifier_reference,
    STATE(279), 1,
      aux_sym_type_class_arguments_repeat1,
    STATE(371), 1,
      sym_type_class_reference,
  [9656] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(898), 1,
      anon_sym_LPAREN,
    STATE(298), 1,
      sym_type_class_arguments,
    ACTIONS(896), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS,
  [9672] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(900), 1,
      sym_identifier,
    ACTIONS(903), 1,
      anon_sym_RPAREN,
    ACTIONS(905), 1,
      anon_sym_LBRACE,
    STATE(274), 1,
      aux_sym_type_class_def_repeat1,
    STATE(326), 1,
      sym_type_variable,
    STATE(373), 1,
      sym_function_cardinality_expression,
  [9694] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(724), 1,
      anon_sym_LPAREN,
    STATE(132), 1,
      sym__has_type,
    STATE(245), 1,
      sym_function_signature,
    STATE(282), 1,
      sym__function_type,
    ACTIONS(728), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [9714] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(820), 1,
      sym_unsigned,
    ACTIONS(908), 1,
      anon_sym_RBRACE,
    STATE(342), 1,
      sym_sequence_uniqueness,
    STATE(383), 1,
      sym__cardinality_inner,
    ACTIONS(706), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [9734] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(273), 1,
      anon_sym_AT,
    ACTIONS(275), 1,
      anon_sym_assert,
    STATE(152), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(262), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [9752] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(910), 1,
      sym_wildcard,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(272), 1,
      aux_sym_type_class_arguments_repeat1,
    STATE(273), 1,
      sym_identifier_reference,
    STATE(371), 1,
      sym_type_class_reference,
  [9774] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(912), 1,
      sym_identifier,
    ACTIONS(915), 1,
      anon_sym_RPAREN,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(273), 1,
      sym_identifier_reference,
    STATE(279), 1,
      aux_sym_type_class_arguments_repeat1,
    STATE(371), 1,
      sym_type_class_reference,
  [9796] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(917), 1,
      anon_sym_RBRACK,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(291), 1,
      aux_sym_rdf_types_repeat1,
    STATE(353), 1,
      sym_identifier_reference,
  [9815] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(921), 1,
      anon_sym_PLUS,
    STATE(285), 1,
      aux_sym__type_variable_restriction_repeat1,
    ACTIONS(919), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [9830] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(923), 5,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [9841] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(820), 1,
      sym_unsigned,
    STATE(368), 1,
      sym_sequence_uniqueness,
    STATE(391), 1,
      sym__cardinality_inner,
    ACTIONS(706), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [9858] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(925), 1,
      anon_sym_is,
    STATE(351), 1,
      sym__module_locations,
    STATE(352), 1,
      sym_iri,
    STATE(437), 1,
      sym_module_body,
  [9877] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(921), 1,
      anon_sym_PLUS,
    STATE(293), 1,
      aux_sym__type_variable_restriction_repeat1,
    ACTIONS(927), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [9892] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(608), 1,
      anon_sym_is,
    ACTIONS(929), 1,
      sym_identifier,
    ACTIONS(931), 1,
      anon_sym_end,
    ACTIONS(933), 1,
      anon_sym_as,
    STATE(355), 1,
      sym_annotation_only_body,
  [9911] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(935), 1,
      anon_sym_RBRACK,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(280), 1,
      aux_sym_rdf_types_repeat1,
    STATE(353), 1,
      sym_identifier_reference,
  [9930] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(628), 1,
      anon_sym_ref,
    STATE(347), 1,
      sym_member,
    STATE(340), 2,
      sym_member_def,
      sym_property_ref,
  [9947] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(937), 5,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [9958] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(519), 1,
      anon_sym_LBRACE,
    ACTIONS(888), 1,
      sym_identifier,
    STATE(271), 1,
      aux_sym_type_class_def_repeat1,
    STATE(326), 1,
      sym_type_variable,
    STATE(373), 1,
      sym_function_cardinality_expression,
  [9977] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(939), 1,
      sym_identifier,
    ACTIONS(942), 1,
      anon_sym_RBRACK,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(291), 1,
      aux_sym_rdf_types_repeat1,
    STATE(353), 1,
      sym_identifier_reference,
  [9996] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      anon_sym_def,
    ACTIONS(944), 1,
      anon_sym_in,
    STATE(80), 1,
      sym_constraint_environment_end,
    STATE(299), 2,
      sym_environment_def,
      aux_sym_constraint_environment_repeat1,
  [10013] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(948), 1,
      anon_sym_PLUS,
    STATE(293), 1,
      aux_sym__type_variable_restriction_repeat1,
    ACTIONS(946), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [10028] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(45), 1,
      sym_identifier,
    ACTIONS(466), 1,
      anon_sym_COLON,
    ACTIONS(47), 3,
      anon_sym_is,
      anon_sym_end,
      anon_sym_as,
  [10043] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(951), 4,
      anon_sym_RBRACE,
      sym_unsigned,
      anon_sym_unique,
      anon_sym_nonunique,
  [10053] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(760), 1,
      sym_identifier,
    ACTIONS(762), 1,
      anon_sym_end,
    STATE(317), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [10067] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(892), 1,
      sym_identifier,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(273), 1,
      sym_identifier_reference,
    STATE(281), 1,
      sym_type_class_reference,
  [10083] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(953), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS,
  [10093] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(955), 1,
      anon_sym_in,
    ACTIONS(957), 1,
      anon_sym_def,
    STATE(299), 2,
      sym_environment_def,
      aux_sym_constraint_environment_repeat1,
  [10107] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(410), 1,
      sym_identifier_reference,
  [10123] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(892), 1,
      sym_identifier,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(273), 1,
      sym_identifier_reference,
    STATE(314), 1,
      sym_type_class_reference,
  [10139] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(608), 1,
      anon_sym_is,
    STATE(363), 1,
      sym_annotation_only_body,
    ACTIONS(962), 2,
      anon_sym_end,
      anon_sym_def,
  [10153] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(608), 1,
      anon_sym_is,
    ACTIONS(964), 1,
      sym_identifier,
    ACTIONS(966), 1,
      anon_sym_end,
    STATE(359), 1,
      sym_annotation_only_body,
  [10169] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(968), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS,
  [10179] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(970), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS,
  [10189] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(972), 1,
      anon_sym_end,
    ACTIONS(974), 1,
      anon_sym_def,
    STATE(306), 1,
      aux_sym_type_class_body_repeat1,
    STATE(361), 1,
      sym_method_def,
  [10205] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(766), 1,
      anon_sym_def,
    ACTIONS(977), 1,
      anon_sym_end,
    STATE(306), 1,
      aux_sym_type_class_body_repeat1,
    STATE(361), 1,
      sym_method_def,
  [10221] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(979), 1,
      anon_sym_is,
    ACTIONS(981), 1,
      anon_sym_EQ,
    STATE(148), 2,
      sym_informal_constraint,
      sym_formal_constraint,
  [10235] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(608), 1,
      anon_sym_is,
    ACTIONS(983), 1,
      sym_identifier,
    ACTIONS(985), 1,
      anon_sym_end,
    STATE(350), 1,
      sym_annotation_only_body,
  [10251] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(987), 1,
      anon_sym_RBRACE,
    STATE(433), 1,
      sym_sequence_uniqueness,
    ACTIONS(706), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [10265] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(608), 1,
      anon_sym_is,
    ACTIONS(989), 1,
      anon_sym_type,
    STATE(226), 1,
      sym_annotation_only_body,
    STATE(372), 1,
      sym_rdf_types,
  [10281] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(139), 1,
      sym__has_type,
    STATE(169), 1,
      sym__type_expression_to,
    ACTIONS(991), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [10295] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(7), 1,
      sym__by_definition,
    STATE(366), 1,
      sym_function_body,
    ACTIONS(824), 2,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [10309] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(946), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS,
  [10319] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(766), 1,
      anon_sym_def,
    ACTIONS(993), 1,
      anon_sym_end,
    STATE(306), 1,
      aux_sym_type_class_body_repeat1,
    STATE(361), 1,
      sym_method_def,
  [10335] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(132), 1,
      sym__has_type,
    STATE(289), 1,
      sym__function_type,
    ACTIONS(728), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [10349] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(995), 1,
      sym_identifier,
    ACTIONS(998), 1,
      anon_sym_end,
    STATE(317), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [10363] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1000), 1,
      sym_identifier,
    ACTIONS(1003), 1,
      anon_sym_RPAREN,
    STATE(318), 1,
      aux_sym_function_signature_repeat1,
    STATE(369), 1,
      sym_function_parameter,
  [10379] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1005), 1,
      sym_identifier,
    ACTIONS(1007), 1,
      anon_sym_RPAREN,
    STATE(318), 1,
      aux_sym_function_signature_repeat1,
    STATE(369), 1,
      sym_function_parameter,
  [10395] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(132), 1,
      sym__has_type,
    STATE(364), 1,
      sym__function_type,
    ACTIONS(728), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [10409] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(760), 1,
      sym_identifier,
    ACTIONS(1009), 1,
      anon_sym_end,
    STATE(317), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [10423] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1011), 1,
      anon_sym_RBRACK,
    ACTIONS(1013), 1,
      sym_hex_byte,
    STATE(345), 1,
      aux_sym_binary_repeat1,
  [10436] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(170), 1,
      sym__type_restriction,
    ACTIONS(1015), 2,
      anon_sym_u2190,
      anon_sym_LT_DASH,
  [10447] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(892), 1,
      sym_identifier,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(183), 1,
      sym_identifier_reference,
  [10460] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(1017), 1,
      sym_quoted_string,
    STATE(404), 1,
      sym_iri,
  [10473] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1019), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [10482] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(396), 1,
      sym__has_type,
    ACTIONS(1021), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [10493] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1023), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [10502] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1025), 1,
      sym_identifier,
    ACTIONS(1027), 2,
      anon_sym_end,
      anon_sym_ref,
  [10513] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1029), 1,
      anon_sym_RBRACK,
    ACTIONS(1031), 1,
      sym_hex_byte,
    STATE(330), 1,
      aux_sym_binary_repeat1,
  [10526] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1013), 1,
      sym_hex_byte,
    ACTIONS(1034), 1,
      anon_sym_RBRACK,
    STATE(334), 1,
      aux_sym_binary_repeat1,
  [10539] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(892), 1,
      sym_identifier,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(413), 1,
      sym_identifier_reference,
  [10552] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(160), 1,
      sym__has_type,
    ACTIONS(1036), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [10563] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1013), 1,
      sym_hex_byte,
    ACTIONS(1038), 1,
      anon_sym_RBRACK,
    STATE(330), 1,
      aux_sym_binary_repeat1,
  [10576] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1005), 1,
      sym_identifier,
    STATE(319), 1,
      aux_sym_function_signature_repeat1,
    STATE(369), 1,
      sym_function_parameter,
  [10589] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(820), 1,
      sym_unsigned,
    ACTIONS(1040), 1,
      anon_sym_RBRACE,
    STATE(381), 1,
      sym__cardinality_inner,
  [10602] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1042), 1,
      sym_identifier,
    ACTIONS(1044), 1,
      sym_reserved_self,
    STATE(400), 1,
      sym_quantified_variable,
  [10615] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1046), 1,
      anon_sym_RBRACE,
    ACTIONS(1048), 1,
      anon_sym_DOT_DOT,
    STATE(392), 1,
      sym_cardinality_range,
  [10628] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(487), 1,
      anon_sym_LPAREN,
    ACTIONS(1050), 1,
      anon_sym_COMMA,
    STATE(112), 1,
      sym_actual_arguments,
  [10641] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1052), 1,
      sym_identifier,
    ACTIONS(1054), 2,
      anon_sym_end,
      anon_sym_ref,
  [10652] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(892), 1,
      sym_identifier,
    STATE(11), 1,
      sym_qualified_identifier,
    STATE(329), 1,
      sym_identifier_reference,
  [10665] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(820), 1,
      sym_unsigned,
    ACTIONS(1056), 1,
      anon_sym_RBRACE,
    STATE(411), 1,
      sym__cardinality_inner,
  [10678] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1058), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [10687] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1060), 1,
      sym_identifier,
    ACTIONS(1063), 1,
      anon_sym_PIPE,
    STATE(344), 1,
      aux_sym_named_variable_set_repeat1,
  [10700] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1013), 1,
      sym_hex_byte,
    ACTIONS(1065), 1,
      anon_sym_RBRACK,
    STATE(330), 1,
      aux_sym_binary_repeat1,
  [10713] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1067), 1,
      sym_identifier,
    ACTIONS(1069), 1,
      anon_sym_PIPE,
    STATE(344), 1,
      aux_sym_named_variable_set_repeat1,
  [10726] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1071), 1,
      sym_identifier,
    ACTIONS(1073), 2,
      anon_sym_end,
      anon_sym_ref,
  [10737] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1075), 1,
      anon_sym_RBRACE,
    ACTIONS(1077), 1,
      sym_unsigned,
  [10747] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1079), 2,
      anon_sym_RBRACK,
      sym_hex_byte,
  [10755] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1081), 1,
      sym_identifier,
    ACTIONS(1083), 1,
      anon_sym_end,
  [10765] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(925), 1,
      anon_sym_is,
    STATE(416), 1,
      sym_module_body,
  [10775] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1085), 1,
      anon_sym_version,
    ACTIONS(1087), 1,
      anon_sym_is,
  [10785] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1089), 2,
      anon_sym_RBRACK,
      sym_identifier,
  [10793] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1091), 1,
      sym_identifier,
    STATE(209), 1,
      sym_member_def,
  [10803] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1093), 1,
      sym_identifier,
    ACTIONS(1095), 1,
      anon_sym_end,
  [10813] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1097), 2,
      anon_sym_in,
      anon_sym_def,
  [10821] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(820), 1,
      sym_unsigned,
    STATE(388), 1,
      sym__cardinality_inner,
  [10831] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(29), 1,
      anon_sym_LT,
    STATE(385), 1,
      sym_iri,
  [10841] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1099), 1,
      sym_identifier,
    ACTIONS(1101), 1,
      anon_sym_end,
  [10851] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1103), 2,
      anon_sym_in,
      anon_sym_u2208,
  [10859] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1105), 2,
      anon_sym_end,
      anon_sym_def,
  [10867] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1107), 1,
      sym_identifier,
    ACTIONS(1109), 1,
      sym_reserved_self,
  [10877] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1111), 2,
      anon_sym_end,
      anon_sym_def,
  [10885] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1113), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [10893] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1115), 2,
      anon_sym_end,
      anon_sym_def,
  [10901] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1117), 2,
      anon_sym_in,
      anon_sym_def,
  [10909] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1119), 1,
      sym_identifier,
    ACTIONS(1121), 1,
      sym_reserved_self,
  [10919] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(820), 1,
      sym_unsigned,
    STATE(378), 1,
      sym__cardinality_inner,
  [10929] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1123), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [10937] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1125), 2,
      anon_sym_RBRACE,
      sym_unsigned,
  [10945] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1127), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [10953] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(608), 1,
      anon_sym_is,
    STATE(237), 1,
      sym_annotation_only_body,
  [10963] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1129), 1,
      sym_identifier,
  [10970] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1131), 1,
      anon_sym_source,
  [10977] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1133), 1,
      anon_sym_RPAREN,
  [10984] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1135), 1,
      anon_sym_RPAREN,
  [10991] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1137), 1,
      anon_sym_LBRACK,
  [10998] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1139), 1,
      anon_sym_RBRACE,
  [11005] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1141), 1,
      anon_sym_LBRACK,
  [11012] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1143), 1,
      anon_sym_RPAREN,
  [11019] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1145), 1,
      anon_sym_RBRACE,
  [11026] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1147), 1,
      ts_builtin_sym_end,
  [11033] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1149), 1,
      anon_sym_RBRACE,
  [11040] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1151), 1,
      anon_sym_is,
  [11047] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1153), 1,
      anon_sym_is,
  [11054] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1155), 1,
      anon_sym_RBRACE,
  [11061] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1157), 1,
      ts_builtin_sym_end,
  [11068] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1159), 1,
      anon_sym_RBRACE,
  [11075] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1161), 1,
      anon_sym_PIPE,
  [11082] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1163), 1,
      anon_sym_RBRACE,
  [11089] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1165), 1,
      anon_sym_RBRACE,
  [11096] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1167), 1,
      anon_sym_RBRACE,
  [11103] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1169), 1,
      sym_identifier,
  [11110] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1171), 1,
      sym_identifier,
  [11117] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1173), 1,
      anon_sym_RBRACE,
  [11124] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1175), 1,
      sym_identifier,
  [11131] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1177), 1,
      anon_sym_PIPE,
  [11138] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1179), 1,
      anon_sym_RBRACE,
  [11145] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1181), 1,
      anon_sym_COMMA,
  [11152] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1183), 1,
      anon_sym_COMMA,
  [11159] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1185), 1,
      sym_quoted_string,
  [11166] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1187), 1,
      sym_identifier,
  [11173] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1189), 1,
      sym_identifier,
  [11180] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1191), 1,
      anon_sym_is,
  [11187] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1193), 1,
      sym_identifier,
  [11194] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1195), 1,
      ts_builtin_sym_end,
  [11201] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
  [11208] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1199), 1,
      anon_sym_RBRACE,
  [11215] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1201), 1,
      anon_sym_COMMA,
  [11222] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1203), 1,
      anon_sym_is,
  [11229] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1205), 1,
      anon_sym_RBRACE,
  [11236] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1207), 1,
      sym_identifier,
  [11243] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1209), 1,
      anon_sym_EQ,
  [11250] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1211), 1,
      anon_sym_RBRACE,
  [11257] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1213), 1,
      anon_sym_is,
  [11264] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1215), 1,
      ts_builtin_sym_end,
  [11271] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1217), 1,
      anon_sym_GT,
  [11278] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1219), 1,
      sym_identifier,
  [11285] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1221), 1,
      sym_identifier,
  [11292] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1223), 1,
      sym_identifier,
  [11299] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1225), 1,
      sym_identifier,
  [11306] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1227), 1,
      anon_sym_LBRACK,
  [11313] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1229), 1,
      sym_identifier,
  [11320] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1231), 1,
      sym_identifier,
  [11327] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1233), 1,
      sym_identifier,
  [11334] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1235), 1,
      sym_identifier,
  [11341] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1237), 1,
      anon_sym_GT,
  [11348] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1239), 1,
      sym_identifier,
  [11355] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1241), 1,
      anon_sym_RPAREN,
  [11362] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1243), 1,
      sym_identifier,
  [11369] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1245), 1,
      anon_sym_RPAREN,
  [11376] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1247), 1,
      anon_sym_LBRACK,
  [11383] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1249), 1,
      anon_sym_RBRACE,
  [11390] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1251), 1,
      sym_identifier,
  [11397] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1253), 1,
      ts_builtin_sym_end,
  [11404] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1255), 1,
      anon_sym_RBRACE,
  [11411] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1257), 1,
      ts_builtin_sym_end,
  [11418] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1259), 1,
      sym_identifier,
  [11425] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1261), 1,
      anon_sym_RBRACE,
  [11432] = 2,
    ACTIONS(1263), 1,
      aux_sym_iri_token1,
    ACTIONS(1265), 1,
      sym_line_comment,
  [11439] = 2,
    ACTIONS(1265), 1,
      sym_line_comment,
    ACTIONS(1267), 1,
      aux_sym_iri_token1,
  [11446] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1269), 1,
      anon_sym_LBRACK,
  [11453] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      anon_sym_LBRACK,
  [11460] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1273), 1,
      anon_sym_PIPE,
  [11467] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1275), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 130,
  [SMALL_STATE(4)] = 250,
  [SMALL_STATE(5)] = 370,
  [SMALL_STATE(6)] = 490,
  [SMALL_STATE(7)] = 610,
  [SMALL_STATE(8)] = 730,
  [SMALL_STATE(9)] = 852,
  [SMALL_STATE(10)] = 972,
  [SMALL_STATE(11)] = 1031,
  [SMALL_STATE(12)] = 1089,
  [SMALL_STATE(13)] = 1145,
  [SMALL_STATE(14)] = 1201,
  [SMALL_STATE(15)] = 1254,
  [SMALL_STATE(16)] = 1307,
  [SMALL_STATE(17)] = 1360,
  [SMALL_STATE(18)] = 1413,
  [SMALL_STATE(19)] = 1466,
  [SMALL_STATE(20)] = 1519,
  [SMALL_STATE(21)] = 1572,
  [SMALL_STATE(22)] = 1652,
  [SMALL_STATE(23)] = 1732,
  [SMALL_STATE(24)] = 1812,
  [SMALL_STATE(25)] = 1892,
  [SMALL_STATE(26)] = 1972,
  [SMALL_STATE(27)] = 2046,
  [SMALL_STATE(28)] = 2092,
  [SMALL_STATE(29)] = 2166,
  [SMALL_STATE(30)] = 2208,
  [SMALL_STATE(31)] = 2282,
  [SMALL_STATE(32)] = 2325,
  [SMALL_STATE(33)] = 2402,
  [SMALL_STATE(34)] = 2441,
  [SMALL_STATE(35)] = 2480,
  [SMALL_STATE(36)] = 2557,
  [SMALL_STATE(37)] = 2596,
  [SMALL_STATE(38)] = 2639,
  [SMALL_STATE(39)] = 2682,
  [SMALL_STATE(40)] = 2759,
  [SMALL_STATE(41)] = 2836,
  [SMALL_STATE(42)] = 2875,
  [SMALL_STATE(43)] = 2914,
  [SMALL_STATE(44)] = 2991,
  [SMALL_STATE(45)] = 3034,
  [SMALL_STATE(46)] = 3111,
  [SMALL_STATE(47)] = 3188,
  [SMALL_STATE(48)] = 3227,
  [SMALL_STATE(49)] = 3304,
  [SMALL_STATE(50)] = 3381,
  [SMALL_STATE(51)] = 3420,
  [SMALL_STATE(52)] = 3459,
  [SMALL_STATE(53)] = 3497,
  [SMALL_STATE(54)] = 3567,
  [SMALL_STATE(55)] = 3637,
  [SMALL_STATE(56)] = 3674,
  [SMALL_STATE(57)] = 3745,
  [SMALL_STATE(58)] = 3782,
  [SMALL_STATE(59)] = 3819,
  [SMALL_STATE(60)] = 3856,
  [SMALL_STATE(61)] = 3893,
  [SMALL_STATE(62)] = 3930,
  [SMALL_STATE(63)] = 3967,
  [SMALL_STATE(64)] = 4004,
  [SMALL_STATE(65)] = 4041,
  [SMALL_STATE(66)] = 4078,
  [SMALL_STATE(67)] = 4149,
  [SMALL_STATE(68)] = 4220,
  [SMALL_STATE(69)] = 4258,
  [SMALL_STATE(70)] = 4296,
  [SMALL_STATE(71)] = 4359,
  [SMALL_STATE(72)] = 4422,
  [SMALL_STATE(73)] = 4483,
  [SMALL_STATE(74)] = 4544,
  [SMALL_STATE(75)] = 4605,
  [SMALL_STATE(76)] = 4666,
  [SMALL_STATE(77)] = 4727,
  [SMALL_STATE(78)] = 4759,
  [SMALL_STATE(79)] = 4791,
  [SMALL_STATE(80)] = 4833,
  [SMALL_STATE(81)] = 4864,
  [SMALL_STATE(82)] = 4895,
  [SMALL_STATE(83)] = 4926,
  [SMALL_STATE(84)] = 4957,
  [SMALL_STATE(85)] = 4988,
  [SMALL_STATE(86)] = 5019,
  [SMALL_STATE(87)] = 5050,
  [SMALL_STATE(88)] = 5081,
  [SMALL_STATE(89)] = 5111,
  [SMALL_STATE(90)] = 5151,
  [SMALL_STATE(91)] = 5183,
  [SMALL_STATE(92)] = 5213,
  [SMALL_STATE(93)] = 5242,
  [SMALL_STATE(94)] = 5291,
  [SMALL_STATE(95)] = 5320,
  [SMALL_STATE(96)] = 5349,
  [SMALL_STATE(97)] = 5378,
  [SMALL_STATE(98)] = 5407,
  [SMALL_STATE(99)] = 5456,
  [SMALL_STATE(100)] = 5505,
  [SMALL_STATE(101)] = 5554,
  [SMALL_STATE(102)] = 5583,
  [SMALL_STATE(103)] = 5618,
  [SMALL_STATE(104)] = 5647,
  [SMALL_STATE(105)] = 5676,
  [SMALL_STATE(106)] = 5708,
  [SMALL_STATE(107)] = 5744,
  [SMALL_STATE(108)] = 5776,
  [SMALL_STATE(109)] = 5814,
  [SMALL_STATE(110)] = 5844,
  [SMALL_STATE(111)] = 5874,
  [SMALL_STATE(112)] = 5906,
  [SMALL_STATE(113)] = 5932,
  [SMALL_STATE(114)] = 5964,
  [SMALL_STATE(115)] = 5991,
  [SMALL_STATE(116)] = 6018,
  [SMALL_STATE(117)] = 6049,
  [SMALL_STATE(118)] = 6080,
  [SMALL_STATE(119)] = 6111,
  [SMALL_STATE(120)] = 6148,
  [SMALL_STATE(121)] = 6175,
  [SMALL_STATE(122)] = 6212,
  [SMALL_STATE(123)] = 6239,
  [SMALL_STATE(124)] = 6266,
  [SMALL_STATE(125)] = 6303,
  [SMALL_STATE(126)] = 6330,
  [SMALL_STATE(127)] = 6357,
  [SMALL_STATE(128)] = 6388,
  [SMALL_STATE(129)] = 6415,
  [SMALL_STATE(130)] = 6442,
  [SMALL_STATE(131)] = 6466,
  [SMALL_STATE(132)] = 6494,
  [SMALL_STATE(133)] = 6534,
  [SMALL_STATE(134)] = 6560,
  [SMALL_STATE(135)] = 6586,
  [SMALL_STATE(136)] = 6610,
  [SMALL_STATE(137)] = 6636,
  [SMALL_STATE(138)] = 6662,
  [SMALL_STATE(139)] = 6686,
  [SMALL_STATE(140)] = 6726,
  [SMALL_STATE(141)] = 6750,
  [SMALL_STATE(142)] = 6774,
  [SMALL_STATE(143)] = 6798,
  [SMALL_STATE(144)] = 6830,
  [SMALL_STATE(145)] = 6872,
  [SMALL_STATE(146)] = 6898,
  [SMALL_STATE(147)] = 6925,
  [SMALL_STATE(148)] = 6952,
  [SMALL_STATE(149)] = 6976,
  [SMALL_STATE(150)] = 7004,
  [SMALL_STATE(151)] = 7038,
  [SMALL_STATE(152)] = 7062,
  [SMALL_STATE(153)] = 7086,
  [SMALL_STATE(154)] = 7120,
  [SMALL_STATE(155)] = 7144,
  [SMALL_STATE(156)] = 7168,
  [SMALL_STATE(157)] = 7192,
  [SMALL_STATE(158)] = 7216,
  [SMALL_STATE(159)] = 7240,
  [SMALL_STATE(160)] = 7264,
  [SMALL_STATE(161)] = 7298,
  [SMALL_STATE(162)] = 7332,
  [SMALL_STATE(163)] = 7356,
  [SMALL_STATE(164)] = 7380,
  [SMALL_STATE(165)] = 7405,
  [SMALL_STATE(166)] = 7428,
  [SMALL_STATE(167)] = 7451,
  [SMALL_STATE(168)] = 7479,
  [SMALL_STATE(169)] = 7503,
  [SMALL_STATE(170)] = 7529,
  [SMALL_STATE(171)] = 7557,
  [SMALL_STATE(172)] = 7591,
  [SMALL_STATE(173)] = 7626,
  [SMALL_STATE(174)] = 7645,
  [SMALL_STATE(175)] = 7666,
  [SMALL_STATE(176)] = 7701,
  [SMALL_STATE(177)] = 7722,
  [SMALL_STATE(178)] = 7747,
  [SMALL_STATE(179)] = 7768,
  [SMALL_STATE(180)] = 7787,
  [SMALL_STATE(181)] = 7808,
  [SMALL_STATE(182)] = 7830,
  [SMALL_STATE(183)] = 7852,
  [SMALL_STATE(184)] = 7874,
  [SMALL_STATE(185)] = 7908,
  [SMALL_STATE(186)] = 7928,
  [SMALL_STATE(187)] = 7950,
  [SMALL_STATE(188)] = 7972,
  [SMALL_STATE(189)] = 7994,
  [SMALL_STATE(190)] = 8016,
  [SMALL_STATE(191)] = 8038,
  [SMALL_STATE(192)] = 8072,
  [SMALL_STATE(193)] = 8094,
  [SMALL_STATE(194)] = 8113,
  [SMALL_STATE(195)] = 8132,
  [SMALL_STATE(196)] = 8151,
  [SMALL_STATE(197)] = 8170,
  [SMALL_STATE(198)] = 8201,
  [SMALL_STATE(199)] = 8220,
  [SMALL_STATE(200)] = 8239,
  [SMALL_STATE(201)] = 8270,
  [SMALL_STATE(202)] = 8289,
  [SMALL_STATE(203)] = 8308,
  [SMALL_STATE(204)] = 8339,
  [SMALL_STATE(205)] = 8358,
  [SMALL_STATE(206)] = 8377,
  [SMALL_STATE(207)] = 8396,
  [SMALL_STATE(208)] = 8415,
  [SMALL_STATE(209)] = 8431,
  [SMALL_STATE(210)] = 8447,
  [SMALL_STATE(211)] = 8463,
  [SMALL_STATE(212)] = 8479,
  [SMALL_STATE(213)] = 8495,
  [SMALL_STATE(214)] = 8511,
  [SMALL_STATE(215)] = 8527,
  [SMALL_STATE(216)] = 8555,
  [SMALL_STATE(217)] = 8585,
  [SMALL_STATE(218)] = 8601,
  [SMALL_STATE(219)] = 8617,
  [SMALL_STATE(220)] = 8633,
  [SMALL_STATE(221)] = 8649,
  [SMALL_STATE(222)] = 8665,
  [SMALL_STATE(223)] = 8681,
  [SMALL_STATE(224)] = 8697,
  [SMALL_STATE(225)] = 8713,
  [SMALL_STATE(226)] = 8729,
  [SMALL_STATE(227)] = 8745,
  [SMALL_STATE(228)] = 8761,
  [SMALL_STATE(229)] = 8777,
  [SMALL_STATE(230)] = 8805,
  [SMALL_STATE(231)] = 8833,
  [SMALL_STATE(232)] = 8863,
  [SMALL_STATE(233)] = 8891,
  [SMALL_STATE(234)] = 8907,
  [SMALL_STATE(235)] = 8923,
  [SMALL_STATE(236)] = 8939,
  [SMALL_STATE(237)] = 8955,
  [SMALL_STATE(238)] = 8971,
  [SMALL_STATE(239)] = 8987,
  [SMALL_STATE(240)] = 9003,
  [SMALL_STATE(241)] = 9019,
  [SMALL_STATE(242)] = 9035,
  [SMALL_STATE(243)] = 9051,
  [SMALL_STATE(244)] = 9078,
  [SMALL_STATE(245)] = 9102,
  [SMALL_STATE(246)] = 9126,
  [SMALL_STATE(247)] = 9150,
  [SMALL_STATE(248)] = 9174,
  [SMALL_STATE(249)] = 9196,
  [SMALL_STATE(250)] = 9217,
  [SMALL_STATE(251)] = 9238,
  [SMALL_STATE(252)] = 9259,
  [SMALL_STATE(253)] = 9280,
  [SMALL_STATE(254)] = 9301,
  [SMALL_STATE(255)] = 9322,
  [SMALL_STATE(256)] = 9337,
  [SMALL_STATE(257)] = 9356,
  [SMALL_STATE(258)] = 9375,
  [SMALL_STATE(259)] = 9394,
  [SMALL_STATE(260)] = 9415,
  [SMALL_STATE(261)] = 9430,
  [SMALL_STATE(262)] = 9445,
  [SMALL_STATE(263)] = 9466,
  [SMALL_STATE(264)] = 9481,
  [SMALL_STATE(265)] = 9500,
  [SMALL_STATE(266)] = 9516,
  [SMALL_STATE(267)] = 9536,
  [SMALL_STATE(268)] = 9556,
  [SMALL_STATE(269)] = 9576,
  [SMALL_STATE(270)] = 9594,
  [SMALL_STATE(271)] = 9612,
  [SMALL_STATE(272)] = 9634,
  [SMALL_STATE(273)] = 9656,
  [SMALL_STATE(274)] = 9672,
  [SMALL_STATE(275)] = 9694,
  [SMALL_STATE(276)] = 9714,
  [SMALL_STATE(277)] = 9734,
  [SMALL_STATE(278)] = 9752,
  [SMALL_STATE(279)] = 9774,
  [SMALL_STATE(280)] = 9796,
  [SMALL_STATE(281)] = 9815,
  [SMALL_STATE(282)] = 9830,
  [SMALL_STATE(283)] = 9841,
  [SMALL_STATE(284)] = 9858,
  [SMALL_STATE(285)] = 9877,
  [SMALL_STATE(286)] = 9892,
  [SMALL_STATE(287)] = 9911,
  [SMALL_STATE(288)] = 9930,
  [SMALL_STATE(289)] = 9947,
  [SMALL_STATE(290)] = 9958,
  [SMALL_STATE(291)] = 9977,
  [SMALL_STATE(292)] = 9996,
  [SMALL_STATE(293)] = 10013,
  [SMALL_STATE(294)] = 10028,
  [SMALL_STATE(295)] = 10043,
  [SMALL_STATE(296)] = 10053,
  [SMALL_STATE(297)] = 10067,
  [SMALL_STATE(298)] = 10083,
  [SMALL_STATE(299)] = 10093,
  [SMALL_STATE(300)] = 10107,
  [SMALL_STATE(301)] = 10123,
  [SMALL_STATE(302)] = 10139,
  [SMALL_STATE(303)] = 10153,
  [SMALL_STATE(304)] = 10169,
  [SMALL_STATE(305)] = 10179,
  [SMALL_STATE(306)] = 10189,
  [SMALL_STATE(307)] = 10205,
  [SMALL_STATE(308)] = 10221,
  [SMALL_STATE(309)] = 10235,
  [SMALL_STATE(310)] = 10251,
  [SMALL_STATE(311)] = 10265,
  [SMALL_STATE(312)] = 10281,
  [SMALL_STATE(313)] = 10295,
  [SMALL_STATE(314)] = 10309,
  [SMALL_STATE(315)] = 10319,
  [SMALL_STATE(316)] = 10335,
  [SMALL_STATE(317)] = 10349,
  [SMALL_STATE(318)] = 10363,
  [SMALL_STATE(319)] = 10379,
  [SMALL_STATE(320)] = 10395,
  [SMALL_STATE(321)] = 10409,
  [SMALL_STATE(322)] = 10423,
  [SMALL_STATE(323)] = 10436,
  [SMALL_STATE(324)] = 10447,
  [SMALL_STATE(325)] = 10460,
  [SMALL_STATE(326)] = 10473,
  [SMALL_STATE(327)] = 10482,
  [SMALL_STATE(328)] = 10493,
  [SMALL_STATE(329)] = 10502,
  [SMALL_STATE(330)] = 10513,
  [SMALL_STATE(331)] = 10526,
  [SMALL_STATE(332)] = 10539,
  [SMALL_STATE(333)] = 10552,
  [SMALL_STATE(334)] = 10563,
  [SMALL_STATE(335)] = 10576,
  [SMALL_STATE(336)] = 10589,
  [SMALL_STATE(337)] = 10602,
  [SMALL_STATE(338)] = 10615,
  [SMALL_STATE(339)] = 10628,
  [SMALL_STATE(340)] = 10641,
  [SMALL_STATE(341)] = 10652,
  [SMALL_STATE(342)] = 10665,
  [SMALL_STATE(343)] = 10678,
  [SMALL_STATE(344)] = 10687,
  [SMALL_STATE(345)] = 10700,
  [SMALL_STATE(346)] = 10713,
  [SMALL_STATE(347)] = 10726,
  [SMALL_STATE(348)] = 10737,
  [SMALL_STATE(349)] = 10747,
  [SMALL_STATE(350)] = 10755,
  [SMALL_STATE(351)] = 10765,
  [SMALL_STATE(352)] = 10775,
  [SMALL_STATE(353)] = 10785,
  [SMALL_STATE(354)] = 10793,
  [SMALL_STATE(355)] = 10803,
  [SMALL_STATE(356)] = 10813,
  [SMALL_STATE(357)] = 10821,
  [SMALL_STATE(358)] = 10831,
  [SMALL_STATE(359)] = 10841,
  [SMALL_STATE(360)] = 10851,
  [SMALL_STATE(361)] = 10859,
  [SMALL_STATE(362)] = 10867,
  [SMALL_STATE(363)] = 10877,
  [SMALL_STATE(364)] = 10885,
  [SMALL_STATE(365)] = 10893,
  [SMALL_STATE(366)] = 10901,
  [SMALL_STATE(367)] = 10909,
  [SMALL_STATE(368)] = 10919,
  [SMALL_STATE(369)] = 10929,
  [SMALL_STATE(370)] = 10937,
  [SMALL_STATE(371)] = 10945,
  [SMALL_STATE(372)] = 10953,
  [SMALL_STATE(373)] = 10963,
  [SMALL_STATE(374)] = 10970,
  [SMALL_STATE(375)] = 10977,
  [SMALL_STATE(376)] = 10984,
  [SMALL_STATE(377)] = 10991,
  [SMALL_STATE(378)] = 10998,
  [SMALL_STATE(379)] = 11005,
  [SMALL_STATE(380)] = 11012,
  [SMALL_STATE(381)] = 11019,
  [SMALL_STATE(382)] = 11026,
  [SMALL_STATE(383)] = 11033,
  [SMALL_STATE(384)] = 11040,
  [SMALL_STATE(385)] = 11047,
  [SMALL_STATE(386)] = 11054,
  [SMALL_STATE(387)] = 11061,
  [SMALL_STATE(388)] = 11068,
  [SMALL_STATE(389)] = 11075,
  [SMALL_STATE(390)] = 11082,
  [SMALL_STATE(391)] = 11089,
  [SMALL_STATE(392)] = 11096,
  [SMALL_STATE(393)] = 11103,
  [SMALL_STATE(394)] = 11110,
  [SMALL_STATE(395)] = 11117,
  [SMALL_STATE(396)] = 11124,
  [SMALL_STATE(397)] = 11131,
  [SMALL_STATE(398)] = 11138,
  [SMALL_STATE(399)] = 11145,
  [SMALL_STATE(400)] = 11152,
  [SMALL_STATE(401)] = 11159,
  [SMALL_STATE(402)] = 11166,
  [SMALL_STATE(403)] = 11173,
  [SMALL_STATE(404)] = 11180,
  [SMALL_STATE(405)] = 11187,
  [SMALL_STATE(406)] = 11194,
  [SMALL_STATE(407)] = 11201,
  [SMALL_STATE(408)] = 11208,
  [SMALL_STATE(409)] = 11215,
  [SMALL_STATE(410)] = 11222,
  [SMALL_STATE(411)] = 11229,
  [SMALL_STATE(412)] = 11236,
  [SMALL_STATE(413)] = 11243,
  [SMALL_STATE(414)] = 11250,
  [SMALL_STATE(415)] = 11257,
  [SMALL_STATE(416)] = 11264,
  [SMALL_STATE(417)] = 11271,
  [SMALL_STATE(418)] = 11278,
  [SMALL_STATE(419)] = 11285,
  [SMALL_STATE(420)] = 11292,
  [SMALL_STATE(421)] = 11299,
  [SMALL_STATE(422)] = 11306,
  [SMALL_STATE(423)] = 11313,
  [SMALL_STATE(424)] = 11320,
  [SMALL_STATE(425)] = 11327,
  [SMALL_STATE(426)] = 11334,
  [SMALL_STATE(427)] = 11341,
  [SMALL_STATE(428)] = 11348,
  [SMALL_STATE(429)] = 11355,
  [SMALL_STATE(430)] = 11362,
  [SMALL_STATE(431)] = 11369,
  [SMALL_STATE(432)] = 11376,
  [SMALL_STATE(433)] = 11383,
  [SMALL_STATE(434)] = 11390,
  [SMALL_STATE(435)] = 11397,
  [SMALL_STATE(436)] = 11404,
  [SMALL_STATE(437)] = 11411,
  [SMALL_STATE(438)] = 11418,
  [SMALL_STATE(439)] = 11425,
  [SMALL_STATE(440)] = 11432,
  [SMALL_STATE(441)] = 11439,
  [SMALL_STATE(442)] = 11446,
  [SMALL_STATE(443)] = 11453,
  [SMALL_STATE(444)] = 11460,
  [SMALL_STATE(445)] = 11467,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [41] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_qualified_identifier, 3, 0, 11),
  [43] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_qualified_identifier, 3, 0, 11),
  [45] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier_reference, 1, 0, 0),
  [47] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier_reference, 1, 0, 0),
  [49] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_iri, 3, 0, 0),
  [51] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_iri, 3, 0, 0),
  [53] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 1, 0, 0),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1, 0, 0),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [59] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 23),
  [61] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 23),
  [63] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary, 3, 0, 49),
  [65] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary, 3, 0, 49),
  [67] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_simple_value, 1, 0, 0),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_simple_value, 1, 0, 0),
  [71] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary, 2, 0, 0),
  [73] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary, 2, 0, 0),
  [75] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean_truth, 1, 0, 0),
  [77] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_truth, 1, 0, 0),
  [79] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean_falsity, 1, 0, 0),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_falsity, 1, 0, 0),
  [83] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1, 0, 0),
  [85] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1, 0, 0),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [117] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(102),
  [120] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(46),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76),
  [125] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(128),
  [128] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(105),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(200),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(90),
  [137] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(440),
  [140] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(331),
  [143] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(94),
  [146] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(94),
  [149] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(96),
  [152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 76), SHIFT_REPEAT(97),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [161] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1, 0, 0),
  [163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1, 0, 0),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 53),
  [169] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 53),
  [171] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 53), SHIFT_REPEAT(393),
  [174] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [180] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_constructor, 4, 0, 70),
  [182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_constructor, 4, 0, 70),
  [184] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 4, 0, 71),
  [186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 4, 0, 71),
  [188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [190] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 3, 0, 51),
  [192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 3, 0, 51),
  [194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_composition, 2, 0, 25),
  [196] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_composition, 2, 0, 25),
  [198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [202] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 1, 0, 12),
  [204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 1, 0, 12),
  [206] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mapping_value, 3, 0, 52),
  [208] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mapping_value, 3, 0, 52),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [212] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 1, 0, 0),
  [214] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 1, 0, 0),
  [216] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46), SHIFT_REPEAT(131),
  [219] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46), SHIFT_REPEAT(46),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46),
  [224] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46), SHIFT_REPEAT(128),
  [227] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46), SHIFT_REPEAT(269),
  [230] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46), SHIFT_REPEAT(90),
  [233] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46), SHIFT_REPEAT(440),
  [236] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46), SHIFT_REPEAT(331),
  [239] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46), SHIFT_REPEAT(94),
  [242] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46), SHIFT_REPEAT(94),
  [245] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46), SHIFT_REPEAT(96),
  [248] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 46), SHIFT_REPEAT(97),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [253] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 2, 0, 0),
  [255] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 2, 0, 0),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 3, 0, 45),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 3, 0, 45),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 5),
  [267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 5),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_predicate_value, 1, 0, 0),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_predicate_value, 1, 0, 0),
  [301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 51),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 51),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 45),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 45),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_actual_arguments, 3, 0, 75),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_actual_arguments, 3, 0, 75),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 1, 0, 12),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 1, 0, 12),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 4, 0, 71),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 4, 0, 71),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_builder, 5, 0, 85),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_builder, 5, 0, 85),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_actual_arguments, 2, 0, 0),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_actual_arguments, 2, 0, 0),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 2, 0, 0),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 2, 0, 0),
  [339] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atomic_sentence, 2, 0, 30),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_functional_term, 2, 0, 31),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_functional_term, 2, 0, 31),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [357] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 46), SHIFT_REPEAT(131),
  [360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 46),
  [362] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 46), SHIFT_REPEAT(90),
  [365] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 46), SHIFT_REPEAT(440),
  [368] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 46), SHIFT_REPEAT(331),
  [371] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 46), SHIFT_REPEAT(94),
  [374] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 46), SHIFT_REPEAT(94),
  [377] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 46), SHIFT_REPEAT(96),
  [380] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 46), SHIFT_REPEAT(97),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_boolean_sentence, 2, 0, 27),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_boolean_sentence, 3, 0, 55),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantified_sentence, 3, 0, 56),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [399] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constraint_environment, 2, 0, 0),
  [401] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint_environment, 2, 0, 0),
  [403] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constraint_environment_end, 1, 0, 0),
  [405] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint_environment_end, 1, 0, 0),
  [407] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negation, 1, 0, 0),
  [409] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_negation, 1, 0, 0),
  [411] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_biconditional, 1, 0, 0),
  [413] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_biconditional, 1, 0, 0),
  [415] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_implication, 1, 0, 0),
  [417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_implication, 1, 0, 0),
  [419] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exclusive_disjunction, 1, 0, 0),
  [421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclusive_disjunction, 1, 0, 0),
  [423] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunction, 1, 0, 0),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 1, 0, 0),
  [427] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conjunction, 1, 0, 0),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 1, 0, 0),
  [431] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_body, 2, 0, 0),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0),
  [439] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(426),
  [442] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(425),
  [445] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(424),
  [448] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(423),
  [451] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(354),
  [454] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(421),
  [457] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(420),
  [460] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(419),
  [463] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(418),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0),
  [474] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0), SHIFT_REPEAT(332),
  [477] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0), SHIFT_REPEAT(430),
  [480] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 53), SHIFT_REPEAT(434),
  [483] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constant_def, 2, 0, 26),
  [485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inequation, 3, 0, 59),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equation, 3, 0, 57),
  [491] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mapping_type, 5, 0, 86),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mapping_type, 5, 0, 86),
  [495] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_builtin_simple_type, 1, 0, 0),
  [497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_builtin_simple_type, 1, 0, 0),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [509] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_actual_arguments_repeat1, 1, 0, 58),
  [511] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 1, 0, 58),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [515] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_sentence, 1, 0, 0),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint_sentence, 3, 0, 0),
  [527] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint_sentence, 1, 0, 0),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_simple_sentence, 1, 0, 0),
  [535] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_import, 1, 0, 4),
  [537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_import, 1, 0, 4),
  [539] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_informal_constraint, 2, 0, 14),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_informal_constraint, 2, 0, 14),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 1, 0, 22),
  [547] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 1, 0, 22),
  [549] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constraint, 3, 0, 1),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint, 3, 0, 1),
  [553] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sequence_of_values_repeat1, 1, 0, 22),
  [555] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 1, 0, 22),
  [557] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_formal_constraint, 4, 0, 60),
  [559] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal_constraint, 4, 0, 60),
  [561] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation, 1, 0, 0),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 1, 0, 0),
  [565] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_not_equal, 1, 0, 0),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_not_equal, 1, 0, 0),
  [569] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_reference, 1, 0, 0),
  [571] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_reference, 1, 0, 0),
  [573] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_less_than_or_equal, 1, 0, 0),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_less_than_or_equal, 1, 0, 0),
  [577] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_greater_than_or_equal, 1, 0, 0),
  [579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_greater_than_or_equal, 1, 0, 0),
  [581] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_property, 4, 0, 13),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_property, 4, 0, 13),
  [585] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_informal_constraint, 3, 0, 32),
  [587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_informal_constraint, 3, 0, 32),
  [589] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_formal_constraint, 3, 0, 26),
  [591] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal_constraint, 3, 0, 26),
  [593] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_body_repeat1, 2, 0, 0),
  [595] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat1, 2, 0, 0), SHIFT_REPEAT(270),
  [598] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_import, 2, 0, 8),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_import, 2, 0, 8),
  [602] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_import, 1, 0, 4),
  [604] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_import, 1, 0, 4),
  [606] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_def, 2, 0, 9),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_def, 2, 0, 9),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [618] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [624] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 2, 0, 0),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [634] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_only_body, 3, 0, 0),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_only_body, 3, 0, 0),
  [638] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__type_expression_to, 3, 0, 39),
  [640] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type_expression_to, 3, 0, 39),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 4, 0, 0),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__type_expression_to, 2, 0, 18),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type_expression_to, 2, 0, 18),
  [648] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 5, 0, 33),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [652] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_def, 2, 0, 5),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [656] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_def, 4, 0, 16),
  [658] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [662] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_def, 3, 0, 17),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_def, 3, 0, 17),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 4, 0, 15),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_def, 2, 0, 5),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [672] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_def, 2, 0, 5),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_def, 2, 0, 5),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 5, 0, 43),
  [684] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 5, 0, 87),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 5, 0, 87),
  [688] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 5, 0, 87),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 5, 0, 87),
  [692] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 2, 0, 0),
  [694] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 2, 0, 0),
  [696] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 4, 0, 79),
  [698] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 4, 0, 79),
  [700] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [708] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 4, 0, 69),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 4, 0, 69),
  [712] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 4, 0, 78),
  [714] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 4, 0, 78),
  [716] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 4, 0, 79),
  [718] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 4, 0, 79),
  [720] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 4, 0, 78),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 4, 0, 78),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [730] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 3, 0, 48),
  [732] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 3, 0, 48),
  [734] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 3, 0, 47),
  [736] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 3, 0, 47),
  [738] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 3, 0, 64),
  [740] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 3, 0, 64),
  [742] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 3, 0, 64),
  [744] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 3, 0, 64),
  [746] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 3, 0, 88),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property_def, 2, 0, 6),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 6, 0, 61),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 4, 0, 62),
  [754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 2, 0, 0),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 4, 0, 94),
  [758] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 3, 0, 0),
  [760] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 4, 0, 0),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structured_body, 4, 0, 0),
  [772] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 5, 0, 34),
  [774] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 2, 0, 0),
  [776] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 3, 0, 35),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_body, 2, 0, 0),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_body, 4, 0, 0),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 5, 0, 62),
  [784] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 3, 0, 0),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_def, 3, 0, 1),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_def, 3, 0, 1),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_def, 5, 0, 37),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_def, 3, 0, 1),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 6, 0, 68),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_definition, 1, 0, 0),
  [804] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structured_body, 3, 0, 0),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_def, 4, 0, 20),
  [808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 4, 0, 35),
  [810] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_def, 3, 0, 1),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structured_body, 2, 0, 0),
  [814] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_body, 3, 0, 0),
  [816] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_def, 3, 0, 1),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 3, 0, 93),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [838] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_type, 2, 0, 18),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_type, 2, 0, 18),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variable, 2, 0, 42),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [846] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(143),
  [849] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2, 0, 0),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [855] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_entity_body_repeat1, 2, 0, 0), SHIFT_REPEAT(312),
  [858] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_entity_body_repeat1, 2, 0, 0),
  [860] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_entity_body_repeat1, 2, 0, 0), SHIFT_REPEAT(341),
  [863] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type_reference, 1, 0, 0),
  [865] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type_reference, 1, 0, 0),
  [867] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_type, 3, 0, 39),
  [869] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_type, 3, 0, 39),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [873] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type_reference, 2, 0, 84),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type_reference, 2, 0, 84),
  [877] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variable, 1, 0, 4),
  [879] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(294),
  [882] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [888] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [896] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_reference, 1, 0, 4),
  [898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [900] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_class_def_repeat1, 2, 0, 44), SHIFT_REPEAT(264),
  [903] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_def_repeat1, 2, 0, 44),
  [905] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_class_def_repeat1, 2, 0, 44), SHIFT_REPEAT(243),
  [908] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [912] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_class_arguments_repeat1, 2, 0, 44), SHIFT_REPEAT(68),
  [915] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_arguments_repeat1, 2, 0, 44),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [919] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type_variable_restriction, 2, 0, 0),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_signature, 1, 0, 54),
  [925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type_variable_restriction, 3, 0, 0),
  [929] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 1, 0, 4),
  [931] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 1, 0, 4),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_signature, 4, 0, 90),
  [939] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rdf_types_repeat1, 2, 0, 67), SHIFT_REPEAT(68),
  [942] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_rdf_types_repeat1, 2, 0, 67),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [946] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__type_variable_restriction_repeat1, 2, 0, 0),
  [948] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__type_variable_restriction_repeat1, 2, 0, 0), SHIFT_REPEAT(301),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_ordering, 1, 0, 0),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_reference, 2, 0, 81),
  [955] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_constraint_environment_repeat1, 2, 0, 0),
  [957] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_constraint_environment_repeat1, 2, 0, 0), SHIFT_REPEAT(405),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 4, 0, 95),
  [964] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_variant, 1, 0, 4),
  [966] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_variant, 1, 0, 4),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_arguments, 3, 0, 92),
  [970] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_arguments, 3, 0, 91),
  [972] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_body_repeat1, 2, 0, 89),
  [974] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_class_body_repeat1, 2, 0, 89), SHIFT_REPEAT(403),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [983] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 3, 0, 65),
  [985] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 3, 0, 65),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [995] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(303),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0),
  [1000] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_signature_repeat1, 2, 0, 83), SHIFT_REPEAT(320),
  [1003] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_signature_repeat1, 2, 0, 83),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_def_repeat1, 1, 0, 21),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variable, 3, 0, 42),
  [1025] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property_ref, 2, 0, 40),
  [1027] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property_ref, 2, 0, 40),
  [1029] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binary_repeat1, 2, 0, 50),
  [1031] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_binary_repeat1, 2, 0, 50), SHIFT_REPEAT(349),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1042] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [1046] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__cardinality_inner, 1, 0, 38),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1050] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantified_variable, 3, 0, 74),
  [1052] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member, 1, 0, 0),
  [1054] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member, 1, 0, 0),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1058] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variable, 2, 0, 4),
  [1060] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_variable_set_repeat1, 2, 0, 0), SHIFT_REPEAT(344),
  [1063] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_variable_set_repeat1, 2, 0, 0),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [1069] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_variable_set, 1, 0, 0),
  [1071] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_entity_identity, 2, 0, 35),
  [1073] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_identity, 2, 0, 35),
  [1075] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_range, 1, 0, 0),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1079] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binary_repeat1, 1, 0, 24),
  [1081] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 4, 0, 80),
  [1083] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 4, 0, 80),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [1087] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__module_locations, 1, 0, 2),
  [1089] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_rdf_types_repeat1, 1, 0, 41),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1093] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 2, 0, 36),
  [1095] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 2, 0, 36),
  [1097] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_environment_def, 3, 0, 1),
  [1099] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_variant, 2, 0, 36),
  [1101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_variant, 2, 0, 36),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_body_repeat1, 1, 0, 82),
  [1107] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_existential, 1, 0, 0),
  [1109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_existential, 1, 0, 0),
  [1111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 5, 0, 95),
  [1113] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 2, 0, 9),
  [1115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 4, 0, 93),
  [1117] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_def, 2, 0, 73),
  [1119] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_universal, 1, 0, 0),
  [1121] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_universal, 1, 0, 0),
  [1123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_signature_repeat1, 1, 0, 72),
  [1125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_uniqueness, 1, 0, 0),
  [1127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_arguments_repeat1, 1, 0, 21),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [1141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sequence_value_constraints, 4, 0, 69),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 5, 0, 0),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_types, 4, 0, 66),
  [1153] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__module_locations, 4, 0, 10),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 4, 0, 0),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mapping_variable, 5, 0, 86),
  [1163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_builder_body, 3, 0, 0),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__cardinality_inner, 2, 0, 63),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1179] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_builder_body, 1, 0, 0),
  [1181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantified_variable, 1, 0, 28),
  [1183] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantified_variable_binding, 2, 0, 29),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__module_locations, 3, 0, 7),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 3, 0, 0),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_types, 2, 0, 19),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_types, 3, 0, 0),
  [1215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 4, 0, 3),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sequence_value_constraints, 3, 0, 48),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 2, 0, 0),
  [1255] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_range, 2, 0, 77),
  [1257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 3, 0, 1),
  [1259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [1263] = {.entry = {.count = 1, .reusable = false}}, SHIFT(427),
  [1265] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1267] = {.entry = {.count = 1, .reusable = false}}, SHIFT(417),
  [1269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sequence_value_constraints, 3, 0, 47),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [1275] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_sdml(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
